/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.kfs.krad.exception.ClassNotPersistableException;
import org.kuali.rice.core.api.config.property.ConfigContext;

public class PersistenceServiceStructureImplBase {
    protected static final Logger LOG = Logger.getLogger(PersistenceServiceStructureImplBase.class);
    private DescriptorRepository descriptorRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceServiceStructureImplBase() {
        String ojbPropertyFileLocation = ConfigContext.getCurrentContextConfig().getProperty("rice.custom.ojb.properties");
        String currentValue = System.getProperty("OJB.properties");
        try {
            System.setProperty("OJB.properties", ojbPropertyFileLocation);
            MetadataManager metadataManager = MetadataManager.getInstance();
            this.descriptorRepository = metadataManager.getGlobalRepository();
        }
        finally {
            if (currentValue == null) {
                System.getProperties().remove("OJB.properties");
            } else {
                System.setProperty("OJB.properties", currentValue);
            }
        }
    }

    protected DescriptorRepository getDescriptorRepository() {
        return this.descriptorRepository;
    }

    public List listPrimaryKeyFieldNames(Class clazz) {
        ArrayList<String> fieldNamesLegacy = new ArrayList<String>();
        ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
        FieldDescriptor[] keyDescriptors = classDescriptor.getPkFields();
        for (int i = 0; i < keyDescriptors.length; ++i) {
            FieldDescriptor keyDescriptor = keyDescriptors[i];
            fieldNamesLegacy.add(keyDescriptor.getAttributeName());
        }
        return fieldNamesLegacy;
    }

    protected ClassDescriptor getClassDescriptor(Class persistableClass) {
        if (persistableClass == null) {
            throw new IllegalArgumentException("invalid (null) object");
        }
        ClassDescriptor classDescriptor = null;
        DescriptorRepository globalRepository = this.getDescriptorRepository();
        try {
            classDescriptor = globalRepository.getDescriptorFor(persistableClass);
        }
        catch (ClassNotPersistenceCapableException e) {
            throw new ClassNotPersistableException("class '" + persistableClass.getName() + "' is not persistable", e);
        }
        return classDescriptor;
    }

    public Class<? extends PersistableBusinessObjectExtension> getBusinessObjectAttributeClass(Class<? extends PersistableBusinessObject> clazz, String attributeName) {
        String baseAttributeName = attributeName;
        String subAttributeString = null;
        if (attributeName.contains(".")) {
            baseAttributeName = attributeName.substring(0, attributeName.indexOf(46));
            subAttributeString = attributeName.substring(attributeName.indexOf(46) + 1);
        }
        Class<? extends PersistableBusinessObjectExtension> attributeClassLegacy = null;
        ClassDescriptor classDescriptor = null;
        try {
            classDescriptor = this.getClassDescriptor(clazz);
        }
        catch (ClassNotPersistableException e) {
            LOG.warn((Object)("Class descriptor for " + clazz.getName() + "was not found"));
        }
        ObjectReferenceDescriptor refDescriptor = null;
        if (classDescriptor != null) {
            refDescriptor = classDescriptor.getObjectReferenceDescriptorByName(baseAttributeName);
        }
        if (refDescriptor != null) {
            attributeClassLegacy = refDescriptor.getItemClass();
        }
        if (subAttributeString != null) {
            attributeClassLegacy = this.getBusinessObjectAttributeClass((Class<? extends PersistableBusinessObject>)attributeClassLegacy, subAttributeString);
        }
        return attributeClassLegacy;
    }
}

