/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.field;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.ComponentSecurity;
import org.kuali.kfs.krad.uif.field.ActionFieldSecurity;
import org.kuali.kfs.krad.uif.field.FieldBase;
import org.kuali.kfs.krad.uif.field.ImageField;
import org.kuali.kfs.krad.uif.view.FormView;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.LightBox;
import org.kuali.rice.core.api.exception.RiceRuntimeException;

public class ActionField
extends FieldBase {
    private static final long serialVersionUID = 1025672792657238829L;
    private String methodToCall;
    private String navigateToPageId;
    private boolean clientSideValidate;
    private String clientSideJs;
    private String jumpToIdAfterSubmit;
    private String jumpToNameAfterSubmit;
    private String focusOnAfterSubmit;
    private String actionLabel;
    private ImageField actionImage;
    private String actionImageLocation = "LEFT";
    private String actionEvent;
    private Map<String, String> actionParameters = new HashMap<String, String>();
    private LightBox lightBoxLookup;
    private LightBox lightBoxDirectInquiry;
    private boolean blockValidateDirty;
    private boolean disabled = false;
    private String disabledReason;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        if (StringUtils.isBlank((CharSequence)this.actionLabel)) {
            this.actionLabel = this.getLabel();
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.actionImage != null && StringUtils.isNotBlank((CharSequence)this.actionImageLocation) && StringUtils.isNotBlank((CharSequence)this.actionLabel)) {
            this.actionImage.setAltText("");
        }
        if (!this.actionParameters.containsKey("actionEvent") && StringUtils.isNotBlank((CharSequence)this.actionEvent)) {
            this.actionParameters.put("actionEvent", this.actionEvent);
        }
        this.actionParameters.put("showHome", "false");
        this.actionParameters.put("showHistory", "false");
        if (StringUtils.isNotBlank((CharSequence)this.navigateToPageId)) {
            this.actionParameters.put("navigateToPageId", this.navigateToPageId);
            if (StringUtils.isBlank((CharSequence)this.methodToCall)) {
                this.actionParameters.put("methodToCall", "navigate");
            }
        }
        if (!this.actionParameters.containsKey("methodToCall") && StringUtils.isNotBlank((CharSequence)this.methodToCall)) {
            this.actionParameters.put("methodToCall", this.methodToCall);
        }
        if (this.lightBoxLookup == null) {
            String prefixScript = this.getOnClickScript();
            if (prefixScript == null) {
                prefixScript = "";
            }
            boolean validateFormDirty = false;
            if (view instanceof FormView && !this.isBlockValidateDirty()) {
                validateFormDirty = ((FormView)view).isValidateDirty();
            }
            boolean includeDirtyCheckScript = false;
            String writeParamsScript = "";
            if (!this.actionParameters.isEmpty()) {
                Iterator<String> iterator = this.actionParameters.keySet().iterator();
                while (iterator.hasNext()) {
                    String keyValue;
                    String key;
                    String parameterPath = key = iterator.next();
                    if (!key.equals("methodToCall")) {
                        parameterPath = "actionParameters[" + key + "]";
                    }
                    writeParamsScript = writeParamsScript + "writeHiddenToForm('" + parameterPath + "' , '" + this.actionParameters.get(key) + "'); ";
                    if (!validateFormDirty || includeDirtyCheckScript || !key.equals("methodToCall") || !StringUtils.equals((CharSequence)(keyValue = this.actionParameters.get(key)), (CharSequence)"refresh") && !StringUtils.equals((CharSequence)keyValue, (CharSequence)"navigate") && !StringUtils.equals((CharSequence)keyValue, (CharSequence)"cancel") && !StringUtils.equals((CharSequence)keyValue, (CharSequence)"close")) continue;
                    includeDirtyCheckScript = true;
                }
            }
            writeParamsScript = writeParamsScript + "writeHiddenToForm('" + "showHistory" + "', 'false'); ";
            writeParamsScript = writeParamsScript + "writeHiddenToForm('" + "showHome" + "' , 'false'); ";
            if (StringUtils.isBlank((CharSequence)this.focusOnAfterSubmit)) {
                this.focusOnAfterSubmit = this.getId();
                writeParamsScript = writeParamsScript + "writeHiddenToForm('focusId' , '" + this.getId() + "'); ";
            } else {
                writeParamsScript = !this.focusOnAfterSubmit.equalsIgnoreCase(UifConstants.Order.FIRST.toString()) ? writeParamsScript + "writeHiddenToForm('focusId' , '" + this.focusOnAfterSubmit + "'); " : writeParamsScript + "writeHiddenToForm('focusId' , ''); ";
            }
            if (StringUtils.isBlank((CharSequence)this.jumpToIdAfterSubmit) && StringUtils.isBlank((CharSequence)this.jumpToNameAfterSubmit)) {
                this.jumpToIdAfterSubmit = this.getId();
                writeParamsScript = writeParamsScript + "writeHiddenToForm('jumpToId' , '" + this.getId() + "'); ";
            } else {
                writeParamsScript = StringUtils.isNotBlank((CharSequence)this.jumpToIdAfterSubmit) ? writeParamsScript + "writeHiddenToForm('jumpToId' , '" + this.jumpToIdAfterSubmit + "'); " : writeParamsScript + "writeHiddenToForm('jumpToName' , '" + this.jumpToNameAfterSubmit + "'); ";
            }
            String postScript = "";
            if (StringUtils.isNotBlank((CharSequence)this.clientSideJs)) {
                postScript = this.clientSideJs;
            }
            if (this.isClientSideValidate()) {
                postScript = postScript + "validateAndSubmitUsingFormMethodToCall();";
            }
            if (StringUtils.isBlank((CharSequence)postScript)) {
                postScript = "writeHiddenToForm('renderFullView' , 'true'); jq('#kualiForm').submit();";
            }
            if (includeDirtyCheckScript) {
                this.setOnClickScript("e.preventDefault(); if (checkDirty(e) == false) { " + prefixScript + writeParamsScript + postScript + " ; } ");
            } else {
                this.setOnClickScript("e.preventDefault();" + prefixScript + writeParamsScript + postScript);
            }
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            for (String key : this.actionParameters.keySet()) {
                String optionValue = this.actionParameters.get(key);
                if (sb.length() > 1) {
                    sb.append(",");
                }
                if (!key.equals("methodToCall")) {
                    sb.append("\"actionParameters[" + key + "]\"");
                } else {
                    sb.append("\"" + key + "\"");
                }
                sb.append(":");
                sb.append("\"" + optionValue + "\"");
            }
            sb.append("}");
            this.lightBoxLookup.setActionParameterMapString(sb.toString());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.actionImage);
        components.add(this.lightBoxLookup);
        components.add(this.lightBoxDirectInquiry);
        return components;
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public ImageField getActionImage() {
        return this.actionImage;
    }

    public void setActionImage(ImageField actionImage) {
        this.actionImage = actionImage;
    }

    public String getNavigateToPageId() {
        return this.navigateToPageId;
    }

    public void setNavigateToPageId(String navigateToPageId) {
        this.navigateToPageId = navigateToPageId;
        this.actionParameters.put("navigateToPageId", navigateToPageId);
        this.methodToCall = "navigate";
    }

    public String getActionEvent() {
        return this.actionEvent;
    }

    public void setActionEvent(String actionEvent) {
        this.actionEvent = actionEvent;
    }

    public Map<String, String> getActionParameters() {
        return this.actionParameters;
    }

    public void setActionParameters(Map<String, String> actionParameters) {
        this.actionParameters = actionParameters;
    }

    public void addActionParameter(String parameterName, String parameterValue) {
        if (this.actionParameters == null) {
            this.actionParameters = new HashMap<String, String>();
        }
        this.actionParameters.put(parameterName, parameterValue);
    }

    public String getActionParameter(String parameterName) {
        return this.actionParameters.get(parameterName);
    }

    public ActionFieldSecurity getActionFieldSecurity() {
        return (ActionFieldSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (!(componentSecurity instanceof ActionFieldSecurity)) {
            throw new RiceRuntimeException("Component security for ActionField should be instance of ActionFieldSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return ActionFieldSecurity.class;
    }

    @Override
    public boolean getSupportsOnClick() {
        return true;
    }

    public void setLightBoxLookup(LightBox lightBoxLookup) {
        this.lightBoxLookup = lightBoxLookup;
    }

    public LightBox getLightBoxLookup() {
        return this.lightBoxLookup;
    }

    public String getJumpToIdAfterSubmit() {
        return this.jumpToIdAfterSubmit;
    }

    public void setJumpToIdAfterSubmit(String jumpToIdAfterSubmit) {
        this.jumpToIdAfterSubmit = jumpToIdAfterSubmit;
    }

    public String getJumpToNameAfterSubmit() {
        return this.jumpToNameAfterSubmit;
    }

    public void setJumpToNameAfterSubmit(String jumpToNameAfterSubmit) {
        this.jumpToNameAfterSubmit = jumpToNameAfterSubmit;
    }

    public String getFocusOnAfterSubmit() {
        return this.focusOnAfterSubmit;
    }

    public void setFocusOnAfterSubmit(String focusOnAfterSubmit) {
        this.focusOnAfterSubmit = focusOnAfterSubmit;
    }

    public boolean isClientSideValidate() {
        return this.clientSideValidate;
    }

    public void setClientSideValidate(boolean clientSideValidate) {
        this.clientSideValidate = clientSideValidate;
    }

    public String getClientSideJs() {
        return this.clientSideJs;
    }

    public void setClientSideJs(String clientSideJs) {
        if (!StringUtils.endsWith((CharSequence)clientSideJs, (CharSequence)";")) {
            clientSideJs = clientSideJs + ";";
        }
        this.clientSideJs = clientSideJs;
    }

    public void setLightBoxDirectInquiry(LightBox lightBoxDirectInquiry) {
        this.lightBoxDirectInquiry = lightBoxDirectInquiry;
    }

    public LightBox getLightBoxDirectInquiry() {
        return this.lightBoxDirectInquiry;
    }

    public void setBlockValidateDirty(boolean blockValidateDirty) {
        this.blockValidateDirty = blockValidateDirty;
    }

    public boolean isBlockValidateDirty() {
        return this.blockValidateDirty;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getActionImageLocation() {
        return this.actionImageLocation;
    }

    public void setActionImageLocation(String actionImageLocation) {
        this.actionImageLocation = actionImageLocation;
    }
}

