/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.field;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.component.BindingInfo;
import org.kuali.kfs.krad.uif.component.MethodInvokerConfig;

public class AttributeQuery
implements Serializable {
    private static final long serialVersionUID = -4569905665441735255L;
    private String dataObjectClassName;
    private boolean renderNotFoundMessage = true;
    private String returnMessageText;
    private String returnMessageStyleClasses;
    private Map<String, String> queryFieldMapping = new HashMap<String, String>();
    private Map<String, String> returnFieldMapping = new HashMap<String, String>();
    private Map<String, String> additionalCriteria = new HashMap<String, String>();
    private List<String> sortPropertyNames = new ArrayList<String>();
    private String queryMethodToCall;
    private List<String> queryMethodArgumentFieldList = new ArrayList<String>();
    private MethodInvokerConfig queryMethodInvokerConfig;

    public void updateQueryFieldMapping(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedQueryFieldMapping = new HashMap<String, String>();
        for (String fromFieldPath : this.getQueryFieldMapping().keySet()) {
            String toField = this.getQueryFieldMapping().get(fromFieldPath);
            String adjustedFromFieldPath = bindingInfo.getPropertyAdjustedBindingPath(fromFieldPath);
            adjustedQueryFieldMapping.put(adjustedFromFieldPath, toField);
        }
        this.queryFieldMapping = adjustedQueryFieldMapping;
    }

    public void updateReturnFieldMapping(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedReturnFieldMapping = new HashMap<String, String>();
        for (String fromFieldPath : this.getReturnFieldMapping().keySet()) {
            String toFieldPath = this.getReturnFieldMapping().get(fromFieldPath);
            String adjustedToFieldPath = bindingInfo.getPropertyAdjustedBindingPath(toFieldPath);
            adjustedReturnFieldMapping.put(fromFieldPath, adjustedToFieldPath);
        }
        this.returnFieldMapping = adjustedReturnFieldMapping;
    }

    public void updateQueryMethodArgumentFieldList(BindingInfo bindingInfo) {
        ArrayList<String> adjustedArgumentFieldList = new ArrayList<String>();
        for (String argumentFieldPath : this.getQueryMethodArgumentFieldList()) {
            String adjustedFieldPath = bindingInfo.getPropertyAdjustedBindingPath(argumentFieldPath);
            adjustedArgumentFieldList.add(adjustedFieldPath);
        }
        this.queryMethodArgumentFieldList = adjustedArgumentFieldList;
    }

    public String getQueryFieldMappingJsString() {
        String queryFieldMappingJs = "{";
        for (String queryField : this.queryFieldMapping.keySet()) {
            if (!StringUtils.equals((CharSequence)queryFieldMappingJs, (CharSequence)"{")) {
                queryFieldMappingJs = queryFieldMappingJs + ",";
            }
            queryFieldMappingJs = queryFieldMappingJs + "\"" + queryField + "\":\"" + this.queryFieldMapping.get(queryField) + "\"";
        }
        queryFieldMappingJs = queryFieldMappingJs + "}";
        return queryFieldMappingJs;
    }

    public String getReturnFieldMappingJsString() {
        String returnFieldMappingJs = "{";
        for (String fromField : this.returnFieldMapping.keySet()) {
            if (!StringUtils.equals((CharSequence)returnFieldMappingJs, (CharSequence)"{")) {
                returnFieldMappingJs = returnFieldMappingJs + ",";
            }
            returnFieldMappingJs = returnFieldMappingJs + "\"" + this.returnFieldMapping.get(fromField) + "\":\"" + fromField + "\"";
        }
        returnFieldMappingJs = returnFieldMappingJs + "}";
        return returnFieldMappingJs;
    }

    public String getQueryMethodArgumentFieldsJsString() {
        String queryMethodArgsJs = "[";
        for (String methodArg : this.queryMethodArgumentFieldList) {
            if (!StringUtils.equals((CharSequence)queryMethodArgsJs, (CharSequence)"{")) {
                queryMethodArgsJs = queryMethodArgsJs + ",";
            }
            queryMethodArgsJs = queryMethodArgsJs + "\"" + methodArg + "\"";
        }
        queryMethodArgsJs = queryMethodArgsJs + "]";
        return queryMethodArgsJs;
    }

    public boolean hasConfiguredMethod() {
        boolean configuredMethod = false;
        if (StringUtils.isNotBlank((CharSequence)this.getQueryMethodToCall())) {
            configuredMethod = true;
        } else if (this.getQueryMethodInvokerConfig() != null) {
            configuredMethod = true;
        }
        return configuredMethod;
    }

    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public Map<String, String> getQueryFieldMapping() {
        return this.queryFieldMapping;
    }

    public void setQueryFieldMapping(Map<String, String> queryFieldMapping) {
        this.queryFieldMapping = queryFieldMapping;
    }

    public Map<String, String> getReturnFieldMapping() {
        return this.returnFieldMapping;
    }

    public void setReturnFieldMapping(Map<String, String> returnFieldMapping) {
        this.returnFieldMapping = returnFieldMapping;
    }

    public Map<String, String> getAdditionalCriteria() {
        return this.additionalCriteria;
    }

    public void setAdditionalCriteria(Map<String, String> additionalCriteria) {
        this.additionalCriteria = additionalCriteria;
    }

    public List<String> getSortPropertyNames() {
        return this.sortPropertyNames;
    }

    public void setSortPropertyNames(List<String> sortPropertyNames) {
        this.sortPropertyNames = sortPropertyNames;
    }

    public boolean isRenderNotFoundMessage() {
        return this.renderNotFoundMessage;
    }

    public void setRenderNotFoundMessage(boolean renderNotFoundMessage) {
        this.renderNotFoundMessage = renderNotFoundMessage;
    }

    public String getReturnMessageText() {
        return this.returnMessageText;
    }

    public void setReturnMessageText(String returnMessageText) {
        this.returnMessageText = returnMessageText;
    }

    public String getReturnMessageStyleClasses() {
        return this.returnMessageStyleClasses;
    }

    public void setReturnMessageStyleClasses(String returnMessageStyleClasses) {
        this.returnMessageStyleClasses = returnMessageStyleClasses;
    }

    public String getQueryMethodToCall() {
        return this.queryMethodToCall;
    }

    public void setQueryMethodToCall(String queryMethodToCall) {
        this.queryMethodToCall = queryMethodToCall;
    }

    public List<String> getQueryMethodArgumentFieldList() {
        return this.queryMethodArgumentFieldList;
    }

    public void setQueryMethodArgumentFieldList(List<String> queryMethodArgumentFieldList) {
        this.queryMethodArgumentFieldList = queryMethodArgumentFieldList;
    }

    public MethodInvokerConfig getQueryMethodInvokerConfig() {
        return this.queryMethodInvokerConfig;
    }

    public void setQueryMethodInvokerConfig(MethodInvokerConfig queryMethodInvokerConfig) {
        this.queryMethodInvokerConfig = queryMethodInvokerConfig;
    }
}

