/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.field;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.uif.component.BindingInfo;
import org.kuali.kfs.krad.uif.component.ComponentBase;
import org.kuali.kfs.krad.uif.component.DataBinding;
import org.kuali.kfs.krad.uif.component.MethodInvokerConfig;
import org.kuali.kfs.krad.uif.container.Container;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.util.CloneUtils;
import org.kuali.kfs.krad.uif.util.ComponentFactory;
import org.kuali.kfs.krad.uif.view.View;

public class RemoteFieldsHolder
extends ComponentBase
implements DataBinding {
    private static final long serialVersionUID = -8493923312021633727L;
    private static final Logger LOG = Logger.getLogger(RemoteFieldsHolder.class);
    private String propertyName;
    private BindingInfo bindingInfo;
    private String fetchingMethodToCall;
    private MethodInvokerConfig fetchingMethodInvoker;

    public List<InputField> fetchAndTranslateRemoteFields(View view, Object model, Container parent) {
        if (StringUtils.isBlank((CharSequence)this.fetchingMethodToCall) && this.fetchingMethodInvoker == null) {
            throw new RuntimeException("");
        }
        if (this.fetchingMethodInvoker == null) {
            this.fetchingMethodInvoker = new MethodInvokerConfig();
        }
        if (StringUtils.isBlank((CharSequence)this.fetchingMethodInvoker.getTargetMethod())) {
            this.fetchingMethodInvoker.setTargetMethod(this.fetchingMethodToCall);
        }
        if (this.fetchingMethodInvoker.getTargetClass() == null && this.fetchingMethodInvoker.getTargetObject() == null) {
            this.fetchingMethodInvoker.setTargetObject(view.getViewHelperService());
        }
        Object[] arguments = new Object[]{view, model, parent};
        this.fetchingMethodInvoker.setArguments(arguments);
        List remotableFields = null;
        try {
            LOG.debug((Object)("Invoking fetching method: " + this.fetchingMethodInvoker.getTargetMethod()));
            this.fetchingMethodInvoker.prepare();
            remotableFields = (List)this.fetchingMethodInvoker.invoke();
        }
        catch (Exception e) {
            LOG.error((Object)"Error invoking fetching method", (Throwable)e);
            throw new RuntimeException("Error invoking fetching method", e);
        }
        List<Object> attributeFields = new ArrayList();
        if (remotableFields != null && !remotableFields.isEmpty()) {
            attributeFields = ComponentFactory.translateRemotableFields(remotableFields);
        }
        if (this.bindingInfo == null) {
            this.bindingInfo = new BindingInfo();
        }
        this.bindingInfo.addToBindByNamePrefix(this.propertyName);
        this.bindingInfo.setBindToMap(true);
        for (InputField inputField : attributeFields) {
            BindingInfo fieldBindingInfo = CloneUtils.deepClone(this.bindingInfo);
            fieldBindingInfo.setDefaults(view, inputField.getPropertyName());
            inputField.setBindingInfo(fieldBindingInfo);
            view.assignComponentIds(inputField);
        }
        return attributeFields;
    }

    @Override
    public String getComponentTypeName() {
        return "RemoteFieldsHolder";
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public String getFetchingMethodToCall() {
        return this.fetchingMethodToCall;
    }

    public void setFetchingMethodToCall(String fetchingMethodToCall) {
        this.fetchingMethodToCall = fetchingMethodToCall;
    }

    public MethodInvokerConfig getFetchingMethodInvoker() {
        return this.fetchingMethodInvoker;
    }

    public void setFetchingMethodInvoker(MethodInvokerConfig fetchingMethodInvoker) {
        this.fetchingMethodInvoker = fetchingMethodInvoker;
    }
}

