/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.util;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.DataBinding;
import org.kuali.kfs.krad.uif.component.Ordered;
import org.kuali.kfs.krad.uif.container.Container;
import org.kuali.kfs.krad.uif.field.Field;
import org.kuali.kfs.krad.uif.field.FieldGroup;
import org.kuali.kfs.krad.uif.layout.LayoutManager;
import org.kuali.kfs.krad.uif.util.CloneUtils;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.OrderComparator;

public class ComponentUtils {
    private static final Logger LOG = Logger.getLogger(ComponentUtils.class);

    public static <T extends Component> T copy(T component) {
        return ComponentUtils.copy(component, null);
    }

    public static <T extends Component> T copy(T component, String idSuffix) {
        T copy = ComponentUtils.copyObject(component);
        if (StringUtils.isNotBlank((CharSequence)idSuffix)) {
            ComponentUtils.updateIdsWithSuffixNested(copy, idSuffix);
        }
        return copy;
    }

    public static <T> T copyObject(T object) {
        if (object == null) {
            return null;
        }
        T copy = null;
        try {
            copy = CloneUtils.deepClone(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return copy;
    }

    protected static Object getCopyPropertyValue(Set<String> propertiesForReferenceCopy, String propertyName, Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        Object copyValue = propertyValue;
        Class<?> valuePropertyType = propertyValue.getClass();
        if (propertiesForReferenceCopy.contains(propertyName) || TypeUtils.isSimpleType(valuePropertyType) || TypeUtils.isClassClass(valuePropertyType)) {
            return copyValue;
        }
        copyValue = Component.class.isAssignableFrom(valuePropertyType) || LayoutManager.class.isAssignableFrom(valuePropertyType) ? ComponentUtils.copyObject(propertyValue) : ObjectUtils.deepCopy((Serializable)propertyValue);
        return copyValue;
    }

    protected static <T> T getNewInstance(T object) {
        T copy = null;
        try {
            copy = (T)object.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create new instance of class: " + object.getClass());
        }
        return copy;
    }

    public static <T extends Field> List<T> copyFieldList(List<T> fields, String addBindingPrefix, String idSuffix) {
        List<T> copiedFieldList = ComponentUtils.copyFieldList(fields, idSuffix);
        ComponentUtils.prefixBindingPath(copiedFieldList, addBindingPrefix);
        return copiedFieldList;
    }

    public static <T extends Field> List<T> copyFieldList(List<T> fields, String idSuffix) {
        ArrayList<Field> copiedFieldList = new ArrayList<Field>();
        for (Field field : fields) {
            Field copiedField = ComponentUtils.copy(field, idSuffix);
            copiedFieldList.add(copiedField);
        }
        return copiedFieldList;
    }

    public static <T extends Component> T copyComponent(T component, String addBindingPrefix, String idSuffix) {
        T copy = ComponentUtils.copy(component, idSuffix);
        ComponentUtils.prefixBindingPathNested(copy, addBindingPrefix);
        return copy;
    }

    public static <T extends Component> List<T> copyComponentList(List<T> components, String idSuffix) {
        ArrayList<Component> copiedComponentList = new ArrayList<Component>();
        for (Component field : components) {
            Component copiedComponent = ComponentUtils.copy(field, idSuffix);
            copiedComponentList.add(copiedComponent);
        }
        return copiedComponentList;
    }

    public static <T extends Component> List<T> getComponentsOfType(List<? extends Component> items, Class<T> componentType) {
        ArrayList<Component> typeComponents = new ArrayList<Component>();
        for (Component component : items) {
            if (!componentType.isAssignableFrom(component.getClass())) continue;
            typeComponents.add(component);
        }
        return typeComponents;
    }

    public static <T extends Component> List<T> getComponentsOfTypeDeep(List<? extends Component> items, Class<T> componentType) {
        ArrayList<T> typeComponents = new ArrayList<T>();
        for (Component component : items) {
            typeComponents.addAll(ComponentUtils.getComponentsOfTypeDeep(component, componentType));
        }
        return typeComponents;
    }

    public static <T extends Component> List<T> getComponentsOfTypeDeep(Component component, Class<T> componentType) {
        ArrayList<Component> typeComponents = new ArrayList<Component>();
        if (component == null) {
            return typeComponents;
        }
        if (componentType.isAssignableFrom(component.getClass())) {
            typeComponents.add(component);
        }
        for (Component nested : component.getComponentsForLifecycle()) {
            typeComponents.addAll(ComponentUtils.getComponentsOfTypeDeep(nested, componentType));
        }
        return typeComponents;
    }

    public static List<Component> getAllNestedComponents(Component component) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (component == null) {
            return components;
        }
        for (Component nested : component.getComponentsForLifecycle()) {
            if (nested == null) continue;
            components.add(nested);
            components.addAll(ComponentUtils.getAllNestedComponents(nested));
        }
        return components;
    }

    public static void prefixBindingPath(List<? extends Field> fields, String addBindingPrefix) {
        for (Field field : fields) {
            if (field instanceof DataBinding) {
                ComponentUtils.prefixBindingPath((DataBinding)((Object)field), addBindingPrefix);
                continue;
            }
            if (!(field instanceof FieldGroup) || ((FieldGroup)field).getItems() == null) continue;
            List<Field> groupFields = ComponentUtils.getComponentsOfType(((FieldGroup)field).getItems(), Field.class);
            ComponentUtils.prefixBindingPath(groupFields, addBindingPrefix);
        }
    }

    public static void prefixBindingPathNested(Component component, String addBindingPrefix) {
        if (component instanceof DataBinding) {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("setting nested binding prefix '" + addBindingPrefix + "' on " + component));
            }
            ComponentUtils.prefixBindingPath((DataBinding)((Object)component), addBindingPrefix);
        }
        for (Component nested : component.getComponentsForLifecycle()) {
            if (nested == null) continue;
            ComponentUtils.prefixBindingPathNested(nested, addBindingPrefix);
        }
    }

    public static void prefixBindingPath(DataBinding field, String addBindingPrefix) {
        String bindingPrefix = addBindingPrefix;
        if (StringUtils.isNotBlank((CharSequence)field.getBindingInfo().getBindByNamePrefix())) {
            bindingPrefix = bindingPrefix + "." + field.getBindingInfo().getBindByNamePrefix();
        }
        field.getBindingInfo().setBindByNamePrefix(bindingPrefix);
    }

    public static void updateIdsWithSuffixNested(List<? extends Component> components, String idSuffix) {
        for (Component component : components) {
            ComponentUtils.updateIdsWithSuffixNested(component, idSuffix);
        }
    }

    public static void updateIdsWithSuffixNested(Component component, String idSuffix) {
        ComponentUtils.updateIdWithSuffix(component, idSuffix);
        if (Container.class.isAssignableFrom(component.getClass())) {
            LayoutManager layoutManager = ((Container)component).getLayoutManager();
            layoutManager.setId(layoutManager.getId() + idSuffix);
        }
        for (Component nested : component.getComponentsForLifecycle()) {
            if (nested == null) continue;
            ComponentUtils.updateIdsWithSuffixNested(nested, idSuffix);
        }
        for (Component nested : component.getPropertyReplacerComponents()) {
            if (nested == null) continue;
            ComponentUtils.updateIdsWithSuffixNested(nested, idSuffix);
        }
    }

    public static void updateIdWithSuffix(Component component, String idSuffix) {
        component.setId(component.getId() + idSuffix);
    }

    public static void setComponentsPropertyDeep(List<? extends Component> components, String propertyPath, Object propertyValue) {
        for (Component component : components) {
            ComponentUtils.setComponentPropertyDeep(component, propertyPath, propertyValue);
        }
    }

    public static void setComponentPropertyDeep(Component component, String propertyPath, Object propertyValue) {
        ObjectPropertyUtils.setPropertyValue(component, propertyPath, propertyValue, true);
        for (Component nested : component.getComponentsForLifecycle()) {
            if (nested == null) continue;
            ComponentUtils.setComponentPropertyDeep(nested, propertyPath, propertyValue);
        }
    }

    public static List<String> getComponentPropertyNames(Class<? extends Component> componentClass) {
        ArrayList<String> componentProperties = new ArrayList<String>();
        PropertyDescriptor[] properties = BeanUtils.getPropertyDescriptors(componentClass);
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor descriptor = properties[i];
            if (descriptor.getReadMethod() == null) continue;
            componentProperties.add(descriptor.getName());
        }
        return componentProperties;
    }

    public static void pushObjectToContext(List<? extends Component> components, String contextName, Object contextValue) {
        for (Component component : components) {
            ComponentUtils.pushObjectToContext(component, contextName, contextValue);
        }
    }

    public static void pushObjectToContext(Component component, String contextName, Object contextValue) {
        LayoutManager layoutManager;
        if (component == null) {
            return;
        }
        component.pushObjectToContext(contextName, contextValue);
        if (Container.class.isAssignableFrom(component.getClass()) && (layoutManager = ((Container)component).getLayoutManager()) != null) {
            layoutManager.pushObjectToContext(contextName, contextValue);
            for (Component nestedComponent : layoutManager.getComponentsForLifecycle()) {
                ComponentUtils.pushObjectToContext(nestedComponent, contextName, contextValue);
            }
        }
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            ComponentUtils.pushObjectToContext(nestedComponent, contextName, contextValue);
        }
    }

    public static void updateContextsForLine(List<? extends Component> components, Object collectionLine, int lineIndex) {
        for (Component component : components) {
            ComponentUtils.updateContextForLine(component, collectionLine, lineIndex);
        }
    }

    public static void updateContextForLine(Component component, Object collectionLine, int lineIndex) {
        ComponentUtils.pushObjectToContext(component, "line", collectionLine);
        ComponentUtils.pushObjectToContext(component, "index", (Object)new Integer(lineIndex));
        boolean isAddLine = lineIndex == -1;
        ComponentUtils.pushObjectToContext(component, "isAddLine", (Object)isAddLine);
    }

    public static List<? extends Ordered> sort(List<? extends Ordered> items, int defaultOrderSequence) {
        int order;
        ArrayList<Ordered> orderedItems = new ArrayList<Ordered>();
        HashSet<Integer> foundOrders = new HashSet<Integer>();
        Collections.reverse(items);
        for (Ordered ordered : items) {
            order = ordered.getOrder();
            if (order == 0) {
                orderedItems.add(ordered);
                continue;
            }
            if (foundOrders.contains(new Integer(order))) continue;
            orderedItems.add(ordered);
            foundOrders.add(new Integer(order));
        }
        Collections.reverse(items);
        for (Ordered ordered : items) {
            order = ordered.getOrder();
            if (order != 0) continue;
            ++defaultOrderSequence;
            while (foundOrders.contains(new Integer(defaultOrderSequence))) {
                ++defaultOrderSequence;
            }
            ordered.setOrder(defaultOrderSequence);
        }
        Collections.sort(orderedItems, new OrderComparator());
        return orderedItems;
    }
}

