/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.widget;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.component.BindingInfo;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.field.ActionField;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.Inquiry;
import org.kuali.kfs.krad.util.UrlFactory;

public class DirectInquiry
extends Inquiry {
    private static final long serialVersionUID = -2490979579285984314L;
    private ActionField directInquiryActionField;
    private boolean adjustInquiryParameters = false;
    private BindingInfo fieldBindingInfo;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (!this.isRender() || this.isReadOnly()) {
            return;
        }
        this.setRender(false);
        InputField field = (InputField)parent;
        if (StringUtils.isBlank((CharSequence)this.getDataObjectClassName()) || this.getInquiryParameters() == null || this.getInquiryParameters().isEmpty()) {
            this.adjustInquiryParameters = true;
            this.fieldBindingInfo = field.getBindingInfo();
        }
        this.setupLink(view, model, field);
    }

    @Override
    public void buildInquiryLink(Object dataObject, String propertyName, Class<?> inquiryObjectClass, Map<String, String> inquiryParms) {
        boolean lightBoxShow;
        Properties urlParameters = new Properties();
        urlParameters.put("dataObjectClassName", inquiryObjectClass.getName());
        urlParameters.put("methodToCall", "start");
        String inquiryUrl = UrlFactory.parameterizeUrl(this.getBaseInquiryUrl(), urlParameters);
        StringBuilder paramMapString = new StringBuilder();
        String lightBoxOptions = "";
        boolean bl = lightBoxShow = this.directInquiryActionField.getLightBoxDirectInquiry() != null;
        if (lightBoxShow) {
            lightBoxOptions = this.directInquiryActionField.getLightBoxDirectInquiry().getComponentOptionsJSString();
        }
        for (Map.Entry<String, String> inquiryParameter : inquiryParms.entrySet()) {
            String inquiryParameterFrom = inquiryParameter.getKey();
            if (this.adjustInquiryParameters && this.fieldBindingInfo != null) {
                inquiryParameterFrom = this.fieldBindingInfo.getPropertyAdjustedBindingPath(inquiryParameterFrom);
            }
            paramMapString.append(inquiryParameterFrom);
            paramMapString.append(":");
            paramMapString.append(inquiryParameter.getValue());
            paramMapString.append(",");
        }
        paramMapString.deleteCharAt(paramMapString.length() - 1);
        StringBuilder onClickScript = new StringBuilder("showDirectInquiry(\"");
        onClickScript.append(inquiryUrl);
        onClickScript.append("\", \"");
        onClickScript.append((CharSequence)paramMapString);
        onClickScript.append("\", ");
        onClickScript.append(lightBoxShow);
        onClickScript.append(", ");
        onClickScript.append(lightBoxOptions);
        onClickScript.append(");");
        this.directInquiryActionField.setBlockValidateDirty(true);
        this.directInquiryActionField.setClientSideJs(onClickScript.toString());
        this.setRender(true);
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.directInquiryActionField);
        return components;
    }

    public ActionField getDirectInquiryActionField() {
        return this.directInquiryActionField;
    }

    public void setDirectInquiryActionField(ActionField directInquiryActionField) {
        this.directInquiryActionField = directInquiryActionField;
    }
}

