/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CsrfValidator {
    private static final Logger LOG = Logger.getLogger(CsrfValidator.class);
    public static final String CSRF_PARAMETER = "csrfToken";
    public static final String CSRF_SESSION_TOKEN = "csrfSessionToken";

    public static boolean validateCsrf(HttpServletRequest request, HttpServletResponse response) {
        if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod()) || "OPTIONS".equals(request.getMethod())) {
            CsrfValidator.placeSessionToken(request);
        } else {
            String givenCsrf = CsrfValidator.getRequestToken(request);
            String actualCsrf = CsrfValidator.getSessionToken(request);
            if (actualCsrf == null) {
                LOG.error((Object)"CSRF check failed because no CSRF token has been established on the session");
                response.setStatus(403);
                return false;
            }
            if (!StringUtils.equals((CharSequence)givenCsrf, (CharSequence)actualCsrf)) {
                LOG.error((Object)("CSRF check failed, actual value was: " + actualCsrf + ", given value was: " + givenCsrf + ", requested URL was: " + request.getRequestURL()));
                response.setStatus(403);
                return false;
            }
        }
        return true;
    }

    public static String getSessionToken(HttpServletRequest request) {
        return (String)request.getSession().getAttribute(CSRF_SESSION_TOKEN);
    }

    public static String getRequestToken(HttpServletRequest request) {
        return request.getParameter(CSRF_PARAMETER);
    }

    private static void placeSessionToken(HttpServletRequest request) {
        if (CsrfValidator.getSessionToken(request) == null) {
            request.getSession().setAttribute(CSRF_SESSION_TOKEN, (Object)UUID.randomUUID().toString());
        }
    }
}

