/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.BooleanFormatter;

public final class KRADUtils {
    private static final KualiDecimal ONE_HUNDRED = new KualiDecimal("100.00");
    private static KualiModuleService kualiModuleService;

    private KRADUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static final String getBusinessTitleForClass(Class<? extends Object> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The getBusinessTitleForClass method of KRADUtils requires a non-null class");
        }
        String className = clazz.getSimpleName();
        StringBuffer label = new StringBuffer(className.substring(0, 1));
        for (int i = 1; i < className.length(); ++i) {
            if (Character.isLowerCase(className.charAt(i))) {
                label.append(className.charAt(i));
                continue;
            }
            label.append(" ").append(className.charAt(i));
        }
        return label.toString().trim();
    }

    public static final List<String> getFileNameFromPath(List<String> fullFileNames) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (String fullFileName : fullFileNames) {
            if (StringUtils.contains((CharSequence)fullFileName, (CharSequence)"/")) {
                fileNameList.add(StringUtils.substringAfterLast((String)fullFileName, (String)"/"));
                continue;
            }
            fileNameList.add(StringUtils.substringAfterLast((String)fullFileName, (String)"\\"));
        }
        return fileNameList;
    }

    public static final String convertDecimalIntoInteger(KualiDecimal decimalNumber) {
        KualiDecimal decimalAmount = (KualiDecimal)decimalNumber.multiply((AbstractKualiDecimal)ONE_HUNDRED);
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        String formattedAmount = formatter.format(decimalAmount);
        return StringUtils.replace((String)formattedAmount, (String)",", (String)"");
    }

    public static Integer getIntegerValue(String numberStr) {
        Integer numberInt = null;
        try {
            numberInt = new Integer(numberStr);
        }
        catch (NumberFormatException nfe) {
            Double numberDbl = new Double(numberStr);
            numberInt = new Integer(numberDbl.intValue());
        }
        return numberInt;
    }

    public static Object hydrateAttributeValue(Class<?> propertyType, String attributeValue) {
        Object attributeValueObject = null;
        if (propertyType != null && attributeValue != null) {
            attributeValueObject = String.class.equals(propertyType) ? attributeValue : (Boolean.class.equals(propertyType) || Boolean.TYPE.equals(propertyType) ? Truth.strToBooleanIgnoreCase((String)attributeValue) : KRADUtils.createObject(propertyType, new Class[]{String.class}, new Object[]{attributeValue}));
        }
        return attributeValueObject;
    }

    public static Object createObject(Class<?> clazz, Class<?>[] argumentClasses, Object[] argumentValues) {
        if (clazz == null) {
            return null;
        }
        if (argumentClasses.length == 1 && argumentClasses[0] == String.class && argumentValues.length == 1 && argumentValues[0] != null) {
            if (clazz == String.class) {
                return argumentValues[0];
            }
            Method valueOfMethod = null;
            try {
                valueOfMethod = clazz.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (valueOfMethod != null) {
                try {
                    return valueOfMethod.invoke(null, argumentValues[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(argumentClasses);
            return constructor.newInstance(argumentValues);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String joinWithQuotes(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        return "'" + StringUtils.join(list.iterator(), (String)"','") + "'";
    }

    private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    public static String getNamespaceCode(Class<? extends Object> clazz) {
        ModuleService moduleService = KRADUtils.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService == null) {
            return "KUALI";
        }
        return moduleService.getModuleConfiguration().getNamespaceCode();
    }

    public static Map<String, String> getNamespaceAndComponentSimpleName(Class<? extends Object> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("componentName", KRADUtils.getComponentSimpleName(clazz));
        return map;
    }

    public static Map<String, String> getNamespaceAndComponentFullName(Class<? extends Object> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("componentName", KRADUtils.getComponentFullName(clazz));
        return map;
    }

    public static Map<String, String> getNamespaceAndActionClass(Class<? extends Object> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("actionClass", clazz.getName());
        return map;
    }

    private static String getComponentSimpleName(Class<? extends Object> clazz) {
        return clazz.getSimpleName();
    }

    private static String getComponentFullName(Class<? extends Object> clazz) {
        return clazz.getName();
    }

    public static Map<String, String> convertStringParameterToMap(String parameter) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)parameter)) {
            if (StringUtils.contains((CharSequence)parameter, (CharSequence)",")) {
                String[] fieldConversions = StringUtils.split((String)parameter, (String)",");
                for (int i = 0; i < fieldConversions.length; ++i) {
                    String fieldConversionStr = fieldConversions[i];
                    if (!StringUtils.isNotBlank((CharSequence)fieldConversionStr)) continue;
                    if (StringUtils.contains((CharSequence)fieldConversionStr, (CharSequence)":")) {
                        String[] fieldConversion = StringUtils.split((String)fieldConversionStr, (String)":");
                        map.put(fieldConversion[0], fieldConversion[1]);
                        continue;
                    }
                    map.put(fieldConversionStr, fieldConversionStr);
                }
            } else if (StringUtils.contains((CharSequence)parameter, (CharSequence)":")) {
                String[] fieldConversion = StringUtils.split((String)parameter, (String)":");
                map.put(fieldConversion[0], fieldConversion[1]);
            } else {
                map.put(parameter, parameter);
            }
        }
        return map;
    }

    public static List<String> convertStringParameterToList(String parameter) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)parameter)) {
            if (StringUtils.contains((CharSequence)parameter, (CharSequence)",")) {
                String[] parameters = StringUtils.split((String)parameter, (String)",");
                List<String> arraysList = Arrays.asList(parameters);
                list.addAll(arraysList);
            } else {
                list.add(parameter);
            }
        }
        return list;
    }

    public static String translateToMapSafeKey(String key) {
        String safeKey = key;
        safeKey = StringUtils.replace((String)safeKey, (String)"[", (String)"_");
        safeKey = StringUtils.replace((String)safeKey, (String)"]", (String)"_");
        return safeKey;
    }

    public static String buildMapParameterString(Map<String, String> map) {
        String parameterString = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtils.isNotBlank((CharSequence)parameterString)) {
                parameterString = parameterString + ",";
            }
            parameterString = parameterString + entry.getKey() + ":" + entry.getValue();
        }
        return parameterString;
    }

    public static Map<String, String> getMapFromParameterString(String parameterString) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] entries = parameterString.split(",");
        for (int i = 0; i < entries.length; ++i) {
            Object[] keyValue = entries[i].split(":");
            if (keyValue.length != 2) {
                throw new RuntimeException("malformed field conversion pair: " + Arrays.toString(keyValue));
            }
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    public static Boolean getRequestParameterAsBoolean(ServletRequest request, String parameterName) {
        Boolean parameterValue = null;
        String parameterValueStr = request.getParameter(parameterName);
        if (StringUtils.isNotBlank((CharSequence)parameterValueStr)) {
            parameterValue = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)parameterValueStr);
        }
        return parameterValue;
    }

    public static Map<String, String> translateRequestParameterMap(Map<String, String[]> requestParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, String[]> parameter : requestParameters.entrySet()) {
            String parameterValue = "";
            parameterValue = parameter.getValue().length > 1 ? StringUtils.join((Object[])parameter.getValue(), (String)"|") : parameter.getValue()[0];
            parameters.put(parameter.getKey(), parameterValue);
        }
        return parameters;
    }

    public static Map<String, String> getParametersFromRequest(List<String> parameterNames, Class<?> parentObjectClass, Map<String, String> requestParameters) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (String keyPropertyName : parameterNames) {
            if (requestParameters.get(keyPropertyName) == null) continue;
            String keyValue = requestParameters.get(keyPropertyName);
            if (KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(parentObjectClass, keyPropertyName)) {
                try {
                    keyValue = StringUtils.removeEnd((String)keyValue, (String)"(&^#&)");
                    keyValue = CoreApiServiceLocator.getEncryptionService().decrypt(keyValue);
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            parameterValues.put(keyPropertyName, keyValue);
        }
        return parameterValues;
    }

    public static Map<String, String> getPropertyKeyValuesFromDataObject(List<String> propertyNames, Object dataObject) {
        HashMap<String, String> propertyKeyValues = new HashMap<String, String>();
        if (dataObject == null) {
            return propertyKeyValues;
        }
        for (String propertyName : propertyNames) {
            Object propertyValue = ObjectPropertyUtils.getPropertyValue(dataObject, propertyName);
            if (propertyValue == null) {
                propertyValue = "";
            }
            if (KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(dataObject.getClass(), propertyName)) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        propertyValue = CoreApiServiceLocator.getEncryptionService().encrypt(propertyValue) + "(&^#&)";
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException("Exception while trying to encrypt value for key/value map.", e);
                }
            }
            propertyKeyValues.put(propertyName, propertyValue.toString());
        }
        return propertyKeyValues;
    }

    public static Properties convertMapToProperties(Map<String, String> parameters) {
        Properties properties = new Properties();
        if (parameters != null) {
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                properties.put(parameter.getKey(), parameter.getValue());
            }
        }
        return properties;
    }

    public static Properties convertRequestMapToProperties(Map<String, String[]> requestParameters) {
        Properties properties = new Properties();
        if (requestParameters != null) {
            for (Map.Entry<String, String[]> parameter : requestParameters.entrySet()) {
                Object[] parameterValue = parameter.getValue();
                String parameterValueString = StringUtils.join((Object[])parameterValue, (String)",");
                properties.put(parameter.getKey(), parameterValueString);
            }
        }
        return properties;
    }

    public static boolean containsSensitiveDataPatternMatch(String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return false;
        }
        ParameterService parameterService = CoreFrameworkServiceLocator.getParameterService();
        Collection<String> sensitiveDataPatterns = parameterService.getParameterValuesAsString("KR-NS", "All", "SENSITIVE_DATA_PATTERNS");
        for (String pattern : sensitiveDataPatterns) {
            if (!Pattern.compile(pattern).matcher(fieldValue).find()) continue;
            return true;
        }
        return false;
    }

    public static final UserSession getUserSessionFromRequest(HttpServletRequest request) {
        return (UserSession)request.getSession().getAttribute("cf.UserSession");
    }

    public static final String getPrincipalIdFromRequest(HttpServletRequest request) {
        return KRADUtils.getUserSessionFromRequest(request).getPerson().getPrincipalId();
    }

    public static boolean isProductionEnvironment() {
        return KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("production.environment.code").equalsIgnoreCase(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("environment"));
    }
}

