/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util.documentserializer;

import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityMetadata;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializerTrieNode;

public class PropertySerializerTrie {
    private static final String PROPERTY_NAME_COMPONENT_SEPARATOR = ".";
    private PropertySerializerTrieNode rootNode = new PropertySerializerTrieNode("", "");

    public void addSerializablePropertyName(String propertyName, boolean setPropertySerializabilityToObjectAndAllPrimitivesForAll) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null attribute name specified");
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            this.rootNode.setPropertySerializabilityToObjectAndAllPrimitives();
        } else {
            StringTokenizer tok = new StringTokenizer(propertyName, PROPERTY_NAME_COMPONENT_SEPARATOR, false);
            StringBuilder buf = new StringBuilder();
            if (setPropertySerializabilityToObjectAndAllPrimitivesForAll) {
                this.rootNode.setPropertySerializabilityToObjectAndAllPrimitives();
            }
            PropertySerializerTrieNode currentNode = this.rootNode;
            while (tok.hasMoreTokens()) {
                String attributeNameComponent = tok.nextToken();
                this.validateAttributeNameComponent(attributeNameComponent);
                buf.append(attributeNameComponent);
                PropertySerializerTrieNode childNode = currentNode.getChildNode(attributeNameComponent);
                if (childNode == null) {
                    childNode = new PropertySerializerTrieNode(buf.toString(), attributeNameComponent);
                    currentNode.addChildNode(childNode);
                }
                if (tok.hasMoreTokens()) {
                    buf.append(PROPERTY_NAME_COMPONENT_SEPARATOR);
                }
                currentNode = childNode;
                if (!setPropertySerializabilityToObjectAndAllPrimitivesForAll) continue;
                currentNode.setPropertySerializabilityToObjectAndAllPrimitives();
            }
            currentNode.setPropertySerializabilityToObjectAndAllPrimitives();
        }
    }

    public PropertySerializabilityMetadata getPropertySerializabilityMetadata(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null attribute name specified");
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return this.rootNode;
        }
        StringTokenizer tok = new StringTokenizer(propertyName, PROPERTY_NAME_COMPONENT_SEPARATOR, false);
        PropertySerializerTrieNode currentNode = this.rootNode;
        while (tok.hasMoreTokens()) {
            String attributeNameComponent = tok.nextToken();
            this.validateAttributeNameComponent(attributeNameComponent);
            PropertySerializerTrieNode childNode = currentNode.getChildNode(attributeNameComponent);
            if (childNode == null) {
                return null;
            }
            currentNode = childNode;
        }
        return currentNode;
    }

    public PropertySerializabilityMetadata getRootPropertySerializibilityMetadata() {
        return this.rootNode;
    }

    protected void validateAttributeNameComponent(String attributeNameComponent) {
        if (StringUtils.isBlank((CharSequence)attributeNameComponent)) {
            throw new IllegalArgumentException("Blank attribute name component specified");
        }
    }
}

