/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.controller;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ModuleLockingHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = Logger.getLogger(ModuleLockingHandlerInterceptor.class);
    private KualiModuleService kualiModuleService;
    private String moduleLockedMapping;

    public String getModuleLockedMapping() {
        return this.moduleLockedMapping;
    }

    public void setModuleLockedMapping(String moduleLockedMapping) {
        this.moduleLockedMapping = moduleLockedMapping;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndview) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.isModuleLocked(request)) {
            response.sendRedirect(this.getModuleLockedMapping() + "?" + "moduleNamespace" + "=" + this.getModuleService(request).getModuleConfiguration().getNamespaceCode());
        }
        return true;
    }

    private ModuleService getModuleService(HttpServletRequest request) {
        String boClass = request.getParameter("businessObjectClassName");
        if (StringUtils.isBlank((CharSequence)boClass)) {
            boClass = request.getParameter("dataObjectClassName");
        }
        ModuleService moduleService = null;
        if (StringUtils.isNotBlank((CharSequence)boClass)) {
            try {
                moduleService = this.getKualiModuleService().getResponsibleModuleService(Class.forName(boClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.warn((Object)("BO class not found: " + boClass), (Throwable)classNotFoundException);
            }
        } else {
            moduleService = this.getKualiModuleService().getResponsibleModuleService(this.getClass());
        }
        return moduleService;
    }

    protected boolean isModuleLocked(HttpServletRequest request) {
        ModuleService moduleService = this.getModuleService(request);
        if (moduleService != null && moduleService.isLocked()) {
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            String namespaceCode = "KR-SYS";
            String permissionName = "Access Locked Module";
            HashMap permissionDetails = new HashMap();
            HashMap qualification = new HashMap();
            if (!KimApiServiceLocator.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, qualification)) {
                return true;
            }
        }
        return false;
    }

    protected KualiModuleService getKualiModuleService() {
        if (this.kualiModuleService == null) {
            this.kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return this.kualiModuleService;
    }
}

