/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.workflow.authorizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.framework.document.security.AuthorizableAction;
import org.kuali.rice.kew.framework.document.security.Authorization;
import org.kuali.rice.kew.framework.document.security.DocumentTypeAuthorizer;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class CfDocumentTypeAuthorizer
implements DocumentTypeAuthorizer {
    private static final Logger LOG = Logger.getLogger(CfDocumentTypeAuthorizer.class);

    public Authorization isActionAuthorized(AuthorizableAction action, String principalId, DocumentType documentType, org.kuali.rice.kew.api.document.Document document, Map<DocumentTypeAuthorizer.ActionArgument, Object> actionParameters) {
        org.kuali.rice.kew.doctype.bo.DocumentType documentTypeBo = org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)documentType);
        switch (action.type) {
            case INITIATION: {
                return new Authorization(this.canInitiate(principalId, documentTypeBo));
            }
            case SU_APPROVE_ACTION_REQUEST: {
                return new Authorization(this.canSuperUserApproveSingleActionRequest(principalId, documentTypeBo, (Collection)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES), (String)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS)));
            }
            case ACTION: {
                switch (action.actionType) {
                    case BLANKET_APPROVE: {
                        return new Authorization(this.canBlanketApprove(principalId, DocumentRouteHeaderValue.from((org.kuali.rice.kew.api.document.Document)document)));
                    }
                    case SU_APPROVE: {
                        return new Authorization(this.canSuperUserApproveDocument(principalId, documentTypeBo, (Collection)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES), (String)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS)));
                    }
                    case SU_DISAPPROVE: {
                        return new Authorization(this.canSuperUserDisapproveDocument(principalId, documentTypeBo, (Collection)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES), (String)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS)));
                    }
                    case CANCEL: {
                        return new Authorization(this.canCancel(principalId, DocumentRouteHeaderValue.from((org.kuali.rice.kew.api.document.Document)document)));
                    }
                    case RECALL: {
                        return new Authorization(this.canRecall(principalId, DocumentRouteHeaderValue.from((org.kuali.rice.kew.api.document.Document)document)));
                    }
                    case ROUTE: {
                        return new Authorization(this.canRoute(principalId, DocumentRouteHeaderValue.from((org.kuali.rice.kew.api.document.Document)document)));
                    }
                    case SAVE: {
                        return new Authorization(this.canSave(principalId, DocumentRouteHeaderValue.from((org.kuali.rice.kew.api.document.Document)document)));
                    }
                }
                throw new RuntimeException("Unknown document action check");
            }
        }
        throw new RuntimeException("Unknown authorization check");
    }

    public boolean canInitiate(String principalId, org.kuali.rice.kew.doctype.bo.DocumentType documentType) {
        this.validatePrincipalId(principalId);
        this.validateDocumentType(documentType);
        Map<String, String> permissionDetails = this.buildDocumentTypePermissionDetails(documentType, null, null, null);
        if (this.useKimPermission("KR-SYS", "Initiate Document", permissionDetails, true)) {
            return this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-SYS", "Initiate Document", permissionDetails, new HashMap());
        }
        return true;
    }

    public boolean canRoute(String principalId, DocumentRouteHeaderValue document) {
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = document.getDocumentType();
        String documentStatus = document.getDocRouteStatus();
        String initiatorPrincipalId = document.getInitiatorWorkflowId();
        this.validateDocumentType(documentType);
        this.validateDocumentStatus(documentStatus);
        this.validatePrincipalId(initiatorPrincipalId);
        if (!documentType.isPolicyDefined(DocumentTypePolicy.INITIATOR_MUST_ROUTE)) {
            Map<String, String> permissionDetails = this.buildDocumentTypePermissionDetails(documentType, documentStatus, null, null);
            Map<String, String> roleQualifiers = this.buildDocumentRoleQualifiers(document, permissionDetails.get("routeNodeName"));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Permission details values: " + permissionDetails));
                LOG.debug((Object)("Role qualifiers values: " + roleQualifiers));
            }
            if (this.useKimPermission("KR-WKFLW", "Route Document", permissionDetails, true)) {
                return this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Route Document", permissionDetails, roleQualifiers);
            }
        }
        if (documentType.getInitiatorMustRoutePolicy().getPolicyValue().booleanValue()) {
            return this.executeInitiatorPolicyCheck(principalId, initiatorPrincipalId, documentStatus);
        }
        return true;
    }

    protected boolean canSuperUserApproveSingleActionRequest(String principalId, org.kuali.rice.kew.doctype.bo.DocumentType documentType, Collection<String> routeNodeNames, String routeStatusCode) {
        this.validatePrincipalId(principalId);
        this.validateDocumentType(documentType);
        List<Map<String, String>> permissionDetailList = this.buildDocumentTypePermissionDetailsForNodes(documentType, routeNodeNames, routeStatusCode, null);
        PermissionService permissionService = this.getPermissionService();
        for (Map<String, String> permissionDetails : permissionDetailList) {
            if (!permissionService.isAuthorizedByTemplate(principalId, "KR-WKFLW", "Super User Approve Single Action Request", permissionDetails, new HashMap())) continue;
            return true;
        }
        return false;
    }

    protected boolean canSuperUserApproveDocument(String principalId, org.kuali.rice.kew.doctype.bo.DocumentType documentType, Collection<String> routeNodeNames, String routeStatusCode) {
        this.validatePrincipalId(principalId);
        this.validateDocumentType(documentType);
        List<Map<String, String>> permissionDetailList = this.buildDocumentTypePermissionDetailsForNodes(documentType, routeNodeNames, routeStatusCode, null);
        PermissionService permissionService = this.getPermissionService();
        for (Map<String, String> permissionDetails : permissionDetailList) {
            if (!permissionService.isAuthorizedByTemplate(principalId, "KR-WKFLW", "Super User Approve Document", permissionDetails, new HashMap())) continue;
            return true;
        }
        return false;
    }

    protected boolean canSuperUserDisapproveDocument(String principalId, org.kuali.rice.kew.doctype.bo.DocumentType documentType, Collection<String> routeNodeNames, String routeStatusCode) {
        this.validatePrincipalId(principalId);
        this.validateDocumentType(documentType);
        List<Map<String, String>> permissionDetailList = this.buildDocumentTypePermissionDetailsForNodes(documentType, routeNodeNames, routeStatusCode, null);
        PermissionService permissionService = this.getPermissionService();
        for (Map<String, String> permissionDetails : permissionDetailList) {
            if (!permissionService.isAuthorizedByTemplate(principalId, "KR-WKFLW", "Super User Disapprove Document", permissionDetails, new HashMap())) continue;
            return true;
        }
        return false;
    }

    public boolean canCancel(String principalId, DocumentRouteHeaderValue document) {
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = document.getDocumentType();
        String documentStatus = document.getDocRouteStatus();
        String initiatorPrincipalId = document.getInitiatorWorkflowId();
        List routeNodeNames = document.getCurrentNodeNames();
        this.validateDocumentType(documentType);
        this.validateRouteNodeNames(routeNodeNames);
        this.validateDocumentStatus(documentStatus);
        this.validatePrincipalId(initiatorPrincipalId);
        if (!documentType.isPolicyDefined(DocumentTypePolicy.INITIATOR_MUST_CANCEL)) {
            List<Map<String, String>> permissionDetailList = this.buildDocumentTypePermissionDetailsForNodes(documentType, routeNodeNames, documentStatus, null);
            boolean foundAtLeastOnePermission = false;
            for (Map<String, String> permissionDetails : permissionDetailList) {
                Map<String, String> roleQualifiers = this.buildDocumentRoleQualifiers(document, permissionDetails.get("routeNodeName"));
                if (!this.useKimPermission("KR-WKFLW", "Cancel Document", permissionDetails, true)) continue;
                foundAtLeastOnePermission = true;
                if (!this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Cancel Document", permissionDetails, roleQualifiers)) continue;
                return true;
            }
            if (foundAtLeastOnePermission) {
                return false;
            }
        }
        if (documentType.getInitiatorMustCancelPolicy().getPolicyValue().booleanValue()) {
            return this.executeInitiatorPolicyCheck(principalId, initiatorPrincipalId, documentStatus);
        }
        return true;
    }

    public boolean canRecall(String principalId, DocumentRouteHeaderValue document) {
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = document.getDocumentType();
        String documentStatus = document.getDocRouteStatus();
        String appDocStatus = document.getAppDocStatus();
        String initiatorPrincipalId = document.getInitiatorWorkflowId();
        List routeNodeNames = document.getCurrentNodeNames();
        this.validateDocumentType(documentType);
        this.validateRouteNodeNames(routeNodeNames);
        this.validateDocumentStatus(documentStatus);
        List<Map<String, String>> permissionDetailList = this.buildDocumentTypePermissionDetailsForNodes(documentType, routeNodeNames, documentStatus, null);
        if (!StringUtils.isBlank((CharSequence)appDocStatus)) {
            for (Map<String, String> details : permissionDetailList) {
                details.put("appDocStatus", appDocStatus);
            }
        }
        boolean foundAtLeastOnePermission = false;
        boolean authorizedByPermission = false;
        for (Map<String, String> permissionDetails : permissionDetailList) {
            Map<String, String> roleQualifiers = this.buildDocumentRoleQualifiers(document, permissionDetails.get("routeNodeName"));
            if (!this.useKimPermission("KR-WKFLW", "Recall Document", permissionDetails, false) || !this.getPermissionService().isPermissionDefinedByTemplate("KR-WKFLW", "Recall Document", permissionDetails)) continue;
            foundAtLeastOnePermission = true;
            if (!this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Recall Document", permissionDetails, roleQualifiers)) continue;
            return true;
        }
        if (foundAtLeastOnePermission) {
            return false;
        }
        return authorizedByPermission;
    }

    public boolean canBlanketApprove(String principalId, DocumentRouteHeaderValue document) {
        Boolean result;
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = document.getDocumentType();
        String initiatorPrincipalId = document.getInitiatorWorkflowId();
        String documentStatus = document.getDocRouteStatus();
        this.validateDocumentType(documentType);
        this.validateDocumentStatus(documentStatus);
        this.validatePrincipalId(initiatorPrincipalId);
        if (documentType.isBlanketApproveGroupDefined()) {
            boolean initiatorAuthorized = true;
            if (documentType.getInitiatorMustBlanketApprovePolicy().getPolicyValue().booleanValue()) {
                initiatorAuthorized = this.executeInitiatorPolicyCheck(principalId, initiatorPrincipalId, documentStatus);
            }
            result = initiatorAuthorized && documentType.isBlanketApprover(principalId);
        } else {
            Map<String, String> permissionDetails = this.buildDocumentTypePermissionDetails(documentType, documentStatus, null, null);
            result = this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Blanket Approve Document", permissionDetails, new HashMap());
        }
        return result;
    }

    public boolean canSave(String principalId, DocumentRouteHeaderValue document) {
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = document.getDocumentType();
        String documentStatus = document.getDocRouteStatus();
        String initiatorPrincipalId = document.getInitiatorWorkflowId();
        List routeNodeNames = document.getCurrentNodeNames();
        this.validateDocumentType(documentType);
        this.validateRouteNodeNames(routeNodeNames);
        this.validateDocumentStatus(documentStatus);
        this.validatePrincipalId(initiatorPrincipalId);
        if (!documentType.isPolicyDefined(DocumentTypePolicy.INITIATOR_MUST_SAVE)) {
            List<Map<String, String>> permissionDetailList = this.buildDocumentTypePermissionDetailsForNodes(documentType, routeNodeNames, documentStatus, null);
            boolean foundAtLeastOnePermission = false;
            for (Map<String, String> permissionDetails : permissionDetailList) {
                Map<String, String> roleQualifiers = this.buildDocumentRoleQualifiers(document, permissionDetails.get("routeNodeName"));
                if (!this.useKimPermission("KR-WKFLW", "Save Document", permissionDetails, true)) continue;
                foundAtLeastOnePermission = true;
                if (!this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Save Document", permissionDetails, roleQualifiers)) continue;
                return true;
            }
            if (foundAtLeastOnePermission) {
                return false;
            }
        }
        if (documentType.getInitiatorMustSavePolicy().getPolicyValue().booleanValue()) {
            return this.executeInitiatorPolicyCheck(principalId, initiatorPrincipalId, documentStatus);
        }
        return true;
    }

    protected Map<String, String> buildDocumentTypePermissionDetails(org.kuali.rice.kew.doctype.bo.DocumentType documentType, String documentStatus, String actionRequestCode, String routeNodeName) {
        HashMap<String, String> details = new HashMap<String, String>();
        if (documentType != null) {
            details.put("documentTypeName", documentType.getName());
        }
        if (!StringUtils.isBlank((CharSequence)documentStatus)) {
            details.put("routeStatusCode", documentStatus);
        }
        if ("I".equals(documentStatus) || "S".equals(documentStatus)) {
            details.put("routeNodeName", "PreRoute");
        } else if (!StringUtils.isBlank((CharSequence)routeNodeName)) {
            details.put("routeNodeName", routeNodeName);
        }
        if (!StringUtils.isBlank((CharSequence)actionRequestCode)) {
            details.put("actionRequestCd", actionRequestCode);
        }
        return details;
    }

    protected List<Map<String, String>> buildDocumentTypePermissionDetailsForNodes(org.kuali.rice.kew.doctype.bo.DocumentType documentType, Collection<String> routeNodeNames, String documentStatus, String actionRequestCode) {
        ArrayList<Map<String, String>> detailList = new ArrayList<Map<String, String>>();
        if (!routeNodeNames.isEmpty()) {
            for (String routeNodeName : routeNodeNames) {
                detailList.add(this.buildDocumentTypePermissionDetails(documentType, documentStatus, actionRequestCode, routeNodeName));
            }
        } else {
            detailList.add(this.buildDocumentTypePermissionDetails(documentType, documentStatus, actionRequestCode, null));
        }
        return detailList;
    }

    protected Map<String, String> buildDocumentRoleQualifiers(DocumentRouteHeaderValue document, String routeNodeName) {
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        qualifiers.put("documentNumber", document.getDocumentId());
        if (!StringUtils.isBlank((CharSequence)document.getDocRouteStatus())) {
            qualifiers.put("routeStatusCode", document.getDocRouteStatus());
            if ("I".equals(document.getDocRouteStatus()) || "S".equals(document.getDocRouteStatus())) {
                qualifiers.put("routeNodeName", "PreRoute");
            } else {
                qualifiers.put("routeNodeName", routeNodeName);
            }
        }
        qualifiers.put("documentTypeName", document.getDocumentType().getName());
        DocumentEntry documentEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getDocumentType().getName());
        if (documentEntry != null) {
            String namespaceCode;
            Class<? extends Document> documentClass = documentEntry.getDocumentClass();
            if (MaintenanceDocument.class.isAssignableFrom(documentClass)) {
                MaintenanceDocumentEntry maintenanceDocumentEntry = (MaintenanceDocumentEntry)documentEntry;
                namespaceCode = KRADUtils.getNamespaceCode(maintenanceDocumentEntry.getDataObjectClass());
            } else {
                namespaceCode = KRADUtils.getNamespaceCode(documentClass);
            }
            qualifiers.put("namespaceCode", namespaceCode);
        }
        return qualifiers;
    }

    protected boolean useKimPermission(String namespace, String permissionTemplateName, Map<String, String> permissionDetails, boolean checkKimPriorityInd) {
        Boolean b = true;
        if (checkKimPriorityInd) {
            b = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "All", "KIM_PRIORITY_ON_DOC_TYP_PERMS_IND");
        }
        if (b == null || b.booleanValue()) {
            return this.getPermissionService().isPermissionDefinedByTemplate(namespace, permissionTemplateName, permissionDetails);
        }
        return false;
    }

    private boolean executeInitiatorPolicyCheck(String principalId, String initiatorPrincipalId, String documentStatus) {
        return principalId.equals(initiatorPrincipalId) || !"S".equals(documentStatus) && !"I".equals(documentStatus);
    }

    protected void validatePrincipalId(String principalId) {
        if (StringUtils.isBlank((CharSequence)principalId)) {
            throw new IllegalArgumentException("Invalid principal ID, value was empty");
        }
    }

    protected void validateDocument(DocumentRouteHeaderValue document) {
        if (document == null) {
            throw new IllegalArgumentException("document cannot be null");
        }
    }

    protected void validateDocumentType(org.kuali.rice.kew.doctype.bo.DocumentType documentType) {
        if (documentType == null) {
            throw new IllegalArgumentException("DocumentType cannot be null");
        }
    }

    protected void validateRouteNodeNames(List<String> routeNodeNames) {
        if (routeNodeNames.isEmpty()) {
            return;
        }
        for (String routeNodeName : routeNodeNames) {
            if (!StringUtils.isBlank((CharSequence)routeNodeName)) continue;
            throw new IllegalArgumentException("List of route node names contained an invalid route node name, value was empty");
        }
    }

    protected void validateDocumentStatus(String documentStatus) {
        if (StringUtils.isBlank((CharSequence)documentStatus)) {
            throw new IllegalArgumentException("Invalid document status, value was empty");
        }
        if (!KewApiConstants.DOCUMENT_STATUSES.containsKey(documentStatus)) {
            throw new IllegalArgumentException("Invalid document status was given, value was: " + documentStatus);
        }
    }

    protected PermissionService getPermissionService() {
        return KimApiServiceLocator.getPermissionService();
    }
}

