/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.component;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.api.component.Component;
import org.kuali.kfs.coreservice.api.component.ComponentService;
import org.kuali.kfs.coreservice.impl.component.ComponentBo;
import org.kuali.kfs.coreservice.impl.component.ComponentSetBo;
import org.kuali.kfs.coreservice.impl.component.ComponentSetDao;
import org.kuali.kfs.coreservice.impl.component.DerivedComponentBo;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.util.ChecksumUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ComponentServiceImpl
implements ComponentService {
    private static final Logger LOG = LogManager.getLogger(ComponentServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private ComponentSetDao componentSetDao;

    @Override
    public Component getComponentByCode(String namespaceCode, String componentCode) {
        if (StringUtils.isBlank((CharSequence)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        if (StringUtils.isBlank((CharSequence)componentCode)) {
            throw new RiceIllegalArgumentException("componentCode was a null or blank value");
        }
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("namespaceCode", namespaceCode);
        primaryKeys.put("code", componentCode);
        ComponentBo componentBo = this.getBusinessObjectService().findByPrimaryKey(ComponentBo.class, primaryKeys);
        if (componentBo != null) {
            return ComponentBo.to(componentBo);
        }
        DerivedComponentBo derivedComponentBo = this.getBusinessObjectService().findByPrimaryKey(DerivedComponentBo.class, primaryKeys);
        return derivedComponentBo == null ? null : DerivedComponentBo.to(derivedComponentBo);
    }

    @Override
    public List<Component> getAllComponentsByNamespaceCode(String namespaceCode) {
        if (StringUtils.isBlank((CharSequence)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespaceCode", namespaceCode);
        ArrayList components = new ArrayList();
        Collection<ComponentBo> componentBos = this.getBusinessObjectService().findMatching(ComponentBo.class, criteria);
        Collection<DerivedComponentBo> derivedComponentBos = this.getBusinessObjectService().findMatching(DerivedComponentBo.class, criteria);
        return this.translateCollections(componentBos, derivedComponentBos);
    }

    @Override
    public List<Component> getActiveComponentsByNamespaceCode(String namespaceCode) {
        if (StringUtils.isBlank((CharSequence)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("active", Boolean.TRUE);
        Collection<ComponentBo> componentBos = this.getBusinessObjectService().findMatching(ComponentBo.class, criteria);
        criteria.remove("active");
        Collection<DerivedComponentBo> derivedComponentBos = this.getBusinessObjectService().findMatching(DerivedComponentBo.class, criteria);
        return this.translateCollections(componentBos, derivedComponentBos);
    }

    @Override
    public List<Component> getDerivedComponentSet(String componentSetId) {
        if (StringUtils.isBlank((CharSequence)componentSetId)) {
            throw new RiceIllegalArgumentException("componentSetId was a null or blank value");
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("componentSetId", componentSetId);
        Collection<DerivedComponentBo> derivedComponentBos = this.getBusinessObjectService().findMatching(DerivedComponentBo.class, criteria);
        return this.translateCollections(null, derivedComponentBos);
    }

    @Override
    public void publishDerivedComponents(String componentSetId, List<Component> components) {
        String checksum;
        if (StringUtils.isBlank((CharSequence)componentSetId)) {
            throw new RiceIllegalArgumentException("componentSetId was a null or blank value");
        }
        components = this.validateAndNormalizeComponents(componentSetId, components);
        LOG.info("Requesting to publish " + components.size() + " derived components for componentSetId=" + componentSetId);
        ComponentSetBo componentSet = this.getComponentSetDao().getComponentSet(componentSetId);
        if (componentSet == null) {
            componentSet = new ComponentSetBo();
            componentSet.setComponentSetId(componentSetId);
        }
        if (!(checksum = this.calculateChecksum(components)).equals(componentSet.getChecksum())) {
            LOG.info("Checksums were different, proceeding with update of derived components for componentSetId=" + componentSetId);
            componentSet.setChecksum(checksum);
            componentSet.setLastUpdateTimestamp(new Timestamp(System.currentTimeMillis()));
            if (this.getComponentSetDao().saveIgnoreLockingFailure(componentSet)) {
                this.updateDerivedComponents(componentSetId, components);
            }
        } else {
            LOG.info("Checksums were the same, no derived component update needed for componentSetId=" + componentSetId);
        }
    }

    protected List<Component> validateAndNormalizeComponents(String componentSetId, List<Component> components) {
        ArrayList<Component> processedComponents = new ArrayList<Component>();
        components = components == null ? new ArrayList<Component>() : new ArrayList<Component>(components);
        for (Component component : components) {
            String currentComponentSetId;
            if (component.getComponentSetId() == null) {
                Component.Builder builder = Component.Builder.create(component);
                builder.setComponentSetId(componentSetId);
                component = builder.build();
            }
            if (!componentSetId.equals(currentComponentSetId = component.getComponentSetId())) {
                throw new RiceIllegalArgumentException("Encountered a component with an invalid componentSetId of '" + currentComponentSetId + "'.  Expected null or '" + componentSetId + "'.");
            }
            processedComponents.add(component);
        }
        return processedComponents;
    }

    protected String calculateChecksum(List<Component> components) {
        Collections.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component component1, Component component2) {
                return CompareToBuilder.reflectionCompare((Object)component1, (Object)component2);
            }
        });
        return ChecksumUtils.calculateChecksum(components);
    }

    protected void updateDerivedComponents(String componentSetId, List<Component> components) {
        HashMap<String, String> deleteCriteria = new HashMap<String, String>();
        deleteCriteria.put("componentSetId", componentSetId);
        this.businessObjectService.deleteMatching(DerivedComponentBo.class, deleteCriteria);
        if (CollectionUtils.isNotEmpty(components)) {
            ArrayList<DerivedComponentBo> derivedComponentBos = new ArrayList<DerivedComponentBo>();
            for (Component component : components) {
                derivedComponentBos.add(DerivedComponentBo.from(component));
            }
            this.businessObjectService.save(derivedComponentBos);
        }
    }

    protected List<Component> translateCollections(Collection<ComponentBo> componentBos, Collection<DerivedComponentBo> derivedComponentBos) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (CollectionUtils.isNotEmpty(componentBos)) {
            for (ComponentBo componentBo : componentBos) {
                components.add(ComponentBo.to(componentBo));
            }
        }
        if (CollectionUtils.isNotEmpty(derivedComponentBos)) {
            for (DerivedComponentBo derivedComponentBo : derivedComponentBos) {
                components.add(DerivedComponentBo.to(derivedComponentBo));
            }
        }
        return Collections.unmodifiableList(components);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ComponentSetDao getComponentSetDao() {
        return this.componentSetDao;
    }

    public void setComponentSetDao(ComponentSetDao componentSetDao) {
        this.componentSetDao = componentSetDao;
    }
}

