/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.parameter;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterKey;
import org.kuali.kfs.coreservice.api.parameter.ParameterRepositoryService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.KualiModuleService;

public class ParameterServiceImpl
implements ParameterService {
    private KualiModuleService kualiModuleService;
    private ParameterRepositoryService parameterRepositoryService;
    private String applicationId = "KUALI";

    @Override
    public Parameter createParameter(Parameter parameter) {
        return this.parameterRepositoryService.createParameter(parameter);
    }

    @Override
    public Parameter updateParameter(Parameter parameter) {
        return this.parameterRepositoryService.updateParameter(parameter);
    }

    @Override
    public Parameter getParameter(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<Parameter>(){

            @Override
            public Parameter f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameter(key);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    @Override
    public Parameter getParameter(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<Parameter>(){

            @Override
            public Parameter f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameter(key);
            }
        }, componentClass, parameterName);
    }

    @Override
    public Boolean parameterExists(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<Boolean>(){

            @Override
            public Boolean f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameter(key) != null;
            }
        }, namespaceCode, componentCode, parameterName);
    }

    @Override
    public Boolean parameterExists(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<Boolean>(){

            @Override
            public Boolean f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameter(key) != null;
            }
        }, componentClass, parameterName);
    }

    @Override
    public Boolean getParameterValueAsBoolean(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<Boolean>(){

            @Override
            public Boolean f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValueAsBoolean(key);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    @Override
    public Boolean getParameterValueAsBoolean(String namespaceCode, String componentCode, String parameterName, Boolean defaultValue) {
        Boolean value = this.getParameterValueAsBoolean(namespaceCode, componentCode, parameterName);
        return value != null ? value : defaultValue;
    }

    @Override
    public Boolean getParameterValueAsBoolean(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<Boolean>(){

            @Override
            public Boolean f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValueAsBoolean(key);
            }
        }, componentClass, parameterName);
    }

    @Override
    public Boolean getParameterValueAsBoolean(Class<?> componentClass, String parameterName, Boolean defaultValue) {
        Boolean value = this.getParameterValueAsBoolean(componentClass, parameterName);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getParameterValueAsString(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<String>(){

            @Override
            public String f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValueAsString(key);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    @Override
    public String getParameterValueAsString(String namespaceCode, String componentCode, String parameterName, String defaultValue) {
        String value = this.getParameterValueAsString(namespaceCode, componentCode, parameterName);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getParameterValueAsString(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<String>(){

            @Override
            public String f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValueAsString(key);
            }
        }, componentClass, parameterName);
    }

    @Override
    public String getParameterValueAsString(Class<?> componentClass, String parameterName, String defaultValue) {
        String value = this.getParameterValueAsString(componentClass, parameterName);
        return value != null ? value : defaultValue;
    }

    @Override
    public Collection<String> getParameterValuesAsString(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<Collection<String>>(){

            @Override
            public Collection<String> f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValuesAsString(key);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    @Override
    public Collection<String> getParameterValuesAsString(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<Collection<String>>(){

            @Override
            public Collection<String> f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValuesAsString(key);
            }
        }, componentClass, parameterName);
    }

    @Override
    public Collection<String> getSubParameterValuesAsString(String namespaceCode, String componentCode, String parameterName, final String constrainingValue) {
        return this.exec(new Fun<Collection<String>>(){

            @Override
            public Collection<String> f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getSubParameterValuesAsString(key, constrainingValue);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    @Override
    public Collection<String> getSubParameterValuesAsString(Class<?> componentClass, String parameterName, final String constrainingValue) {
        return this.exec(new Fun<Collection<String>>(){

            @Override
            public Collection<String> f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getSubParameterValuesAsString(key, constrainingValue);
            }
        }, componentClass, parameterName);
    }

    @Override
    public String getSubParameterValueAsString(String namespaceCode, String componentCode, String parameterName, final String constrainingValue) {
        return this.exec(new Fun<String>(){

            @Override
            public String f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getSubParameterValueAsString(key, constrainingValue);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    @Override
    public String getSubParameterValueAsString(Class<?> componentClass, String parameterName, final String constrainingValue) {
        return this.exec(new Fun<String>(){

            @Override
            public String f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getSubParameterValueAsString(key, constrainingValue);
            }
        }, componentClass, parameterName);
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setParameterRepositoryService(ParameterRepositoryService parameterRepositoryService) {
        this.parameterRepositoryService = parameterRepositoryService;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    private <R> R exec(Fun<R> fun, String namespaceCode, String componentCode, String parameterName) {
        if (StringUtils.isBlank((CharSequence)this.applicationId)) {
            throw new IllegalStateException("applicationId is blank - this service is not configured correctly");
        }
        return fun.f(ParameterKey.create(this.applicationId, namespaceCode, componentCode, parameterName));
    }

    private <R> R exec(Fun<R> fun, Class<?> componentClass, String parameterName) {
        return this.exec(fun, this.kualiModuleService.getNamespaceCode(componentClass), this.kualiModuleService.getComponentCode(componentClass), parameterName);
    }

    private static interface Fun<R> {
        public R f(ParameterKey var1);
    }
}

