/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.web.component;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.impl.component.ComponentBo;
import org.kuali.kfs.coreservice.impl.component.DerivedComponentBo;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class ComponentLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = -3978422770535345525L;
    private static final String ACTIVE = "active";
    private static final String CODE = "code";
    private static final String NAMESPACE_CODE = "namespaceCode";
    private static final String NAME = "name";

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List<? extends BusinessObject> baseLookup = super.getSearchResults(fieldValues);
        String activeCheck = fieldValues.get(ACTIVE);
        if (activeCheck == null) {
            activeCheck = "";
        }
        int maxResultsCount = LookupUtils.getSearchResultsLimit(ComponentBo.class);
        if (baseLookup instanceof CollectionIncomplete && !activeCheck.equals("N")) {
            long originalCount;
            long totalCount = originalCount = Math.max((long)baseLookup.size(), ((CollectionIncomplete)baseLookup).getActualSizeIfTruncated());
            Collection<DerivedComponentBo> derivedComponentBos = null;
            derivedComponentBos = StringUtils.isBlank((CharSequence)fieldValues.get(CODE)) && StringUtils.isBlank((CharSequence)fieldValues.get(NAMESPACE_CODE)) && StringUtils.isBlank((CharSequence)fieldValues.get(NAME)) ? KRADServiceLocator.getBusinessObjectService().findAll(DerivedComponentBo.class) : this.getLookupService().findCollectionBySearchHelper(DerivedComponentBo.class, fieldValues, false);
            if (CollectionUtils.isNotEmpty(derivedComponentBos)) {
                for (DerivedComponentBo derivedComponentBo : derivedComponentBos) {
                    if (totalCount++ >= (long)maxResultsCount) break;
                    baseLookup.add(DerivedComponentBo.toComponentBo(derivedComponentBo));
                }
            }
            if (totalCount > (long)maxResultsCount) {
                ((CollectionIncomplete)baseLookup).setActualSizeIfTruncated(totalCount);
            } else {
                ((CollectionIncomplete)baseLookup).setActualSizeIfTruncated(0L);
            }
        }
        return baseLookup;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        if (((ComponentBo)businessObject).getObjectId() == null) {
            return super.getEmptyActionUrls();
        }
        return super.getCustomActionUrls(businessObject, pkNames);
    }
}

