/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.datadictionary.HeaderNavigation;
import org.kuali.kfs.kns.datadictionary.KNSDocumentEntry;
import org.kuali.kfs.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.kfs.kns.document.MaintenanceDocumentBase;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.DocumentPresentationController;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentPresentationControllerBase;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.rule.PromptBeforeValidation;
import org.kuali.kfs.kns.rules.MaintenanceDocumentRule;
import org.kuali.kfs.kns.web.derivedvaluesetter.DerivedValuesSetter;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;
import org.kuali.kfs.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;

public class MaintenanceDocumentEntry
extends org.kuali.kfs.krad.datadictionary.MaintenanceDocumentEntry
implements KNSDocumentEntry {
    protected List<MaintainableSectionDefinition> maintainableSections = new ArrayList<MaintainableSectionDefinition>();
    protected List<String> lockingKeys = new ArrayList<String>();
    protected Map<String, MaintainableSectionDefinition> maintainableSectionMap = new LinkedHashMap<String, MaintainableSectionDefinition>();
    protected boolean allowsNewOrCopy = true;
    protected String additionalSectionsFile;
    protected boolean preserveLockingKeysOnCopy = false;
    protected boolean allowsRecordDeletion = false;
    protected boolean translateCodes = false;
    protected Class<? extends PromptBeforeValidation> promptBeforeValidationClass;
    protected Class<? extends DerivedValuesSetter> derivedValuesSetterClass;
    protected List<String> webScriptFiles = new ArrayList<String>(3);
    protected List<HeaderNavigation> headerNavigationList = new ArrayList<HeaderNavigation>();
    protected boolean sessionDocument = false;

    public MaintenanceDocumentEntry() {
        this.documentAuthorizerClass = MaintenanceDocumentAuthorizerBase.class;
        this.documentPresentationControllerClass = MaintenanceDocumentPresentationControllerBase.class;
    }

    @Override
    public Class<? extends PromptBeforeValidation> getPromptBeforeValidationClass() {
        return this.promptBeforeValidationClass;
    }

    @Override
    public void setPromptBeforeValidationClass(Class<? extends PromptBeforeValidation> preRulesCheckClass) {
        this.promptBeforeValidationClass = preRulesCheckClass;
    }

    @Override
    public Class<? extends Document> getStandardDocumentBaseClass() {
        return MaintenanceDocumentBase.class;
    }

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        this.setDataObjectClass(businessObjectClass);
    }

    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return this.getDataObjectClass();
    }

    @Override
    public Class getEntryClass() {
        return this.getDataObjectClass();
    }

    public Class<? extends Maintainable> getMaintainableClass() {
        return super.getMaintainableClass();
    }

    public List<MaintainableSectionDefinition> getMaintainableSections() {
        return this.maintainableSections;
    }

    @Override
    public List<String> getLockingKeyFieldNames() {
        return this.lockingKeys;
    }

    @Override
    public boolean getAllowsNewOrCopy() {
        return this.allowsNewOrCopy;
    }

    @Override
    public void setAllowsNewOrCopy(boolean allowsNewOrCopy) {
        this.allowsNewOrCopy = allowsNewOrCopy;
    }

    @Override
    public void completeValidation() {
        if (!MaintenanceDocumentRule.class.isAssignableFrom(this.getBusinessRulesClass())) {
            throw new DataDictionaryException("ERROR: Business rules class for KNS Maintenance document entry " + this.getBusinessRulesClass().getName() + " does not implement the expected " + MaintenanceDocumentRule.class.getName() + " interface.");
        }
        super.completeValidation();
        for (MaintainableSectionDefinition maintainableSectionDefinition : this.maintainableSections) {
            maintainableSectionDefinition.completeValidation((Class)this.getDataObjectClass(), (Class)null);
        }
    }

    @Override
    public String toString() {
        return "MaintenanceDocumentEntry for documentType " + this.getDocumentTypeName();
    }

    @Deprecated
    public String getAdditionalSectionsFile() {
        return this.additionalSectionsFile;
    }

    @Deprecated
    public void setAdditionalSectionsFile(String additionalSectionsFile) {
        this.additionalSectionsFile = additionalSectionsFile;
    }

    @Override
    public List<String> getLockingKeys() {
        return this.lockingKeys;
    }

    @Override
    public void setLockingKeys(List<String> lockingKeys) {
        for (String lockingKey : lockingKeys) {
            if (lockingKey != null) continue;
            throw new IllegalArgumentException("invalid (null) lockingKey");
        }
        this.lockingKeys = lockingKeys;
    }

    @Deprecated
    public void setMaintainableSections(List<MaintainableSectionDefinition> maintainableSections) {
        this.maintainableSectionMap.clear();
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSections) {
            if (maintainableSectionDefinition == null) {
                throw new IllegalArgumentException("invalid (null) maintainableSectionDefinition");
            }
            String sectionTitle = maintainableSectionDefinition.getTitle();
            if (this.maintainableSectionMap.containsKey(sectionTitle)) {
                throw new DuplicateEntryException("section '" + sectionTitle + "' already defined for maintenanceDocument '" + this.getDocumentTypeName() + "'");
            }
            this.maintainableSectionMap.put(sectionTitle, maintainableSectionDefinition);
        }
        this.maintainableSections = maintainableSections;
    }

    @Override
    public boolean getPreserveLockingKeysOnCopy() {
        return this.preserveLockingKeysOnCopy;
    }

    @Override
    public void setPreserveLockingKeysOnCopy(boolean preserveLockingKeysOnCopy) {
        this.preserveLockingKeysOnCopy = preserveLockingKeysOnCopy;
    }

    @Override
    public boolean getAllowsRecordDeletion() {
        return this.allowsRecordDeletion;
    }

    @Override
    public void setAllowsRecordDeletion(boolean allowsRecordDeletion) {
        this.allowsRecordDeletion = allowsRecordDeletion;
    }

    @Deprecated
    public boolean isTranslateCodes() {
        return this.translateCodes;
    }

    @Deprecated
    public void setTranslateCodes(boolean translateCodes) {
        this.translateCodes = translateCodes;
    }

    @Override
    public Class<? extends DocumentAuthorizer> getDocumentAuthorizerClass() {
        return super.getDocumentAuthorizerClass();
    }

    @Override
    public Class<? extends DocumentPresentationController> getDocumentPresentationControllerClass() {
        return super.getDocumentPresentationControllerClass();
    }

    @Override
    public List<HeaderNavigation> getHeaderNavigationList() {
        return this.headerNavigationList;
    }

    @Override
    public List<String> getWebScriptFiles() {
        return this.webScriptFiles;
    }

    @Override
    public void setWebScriptFiles(List<String> webScriptFiles) {
        this.webScriptFiles = webScriptFiles;
    }

    @Override
    public void setHeaderNavigationList(List<HeaderNavigation> headerNavigationList) {
        this.headerNavigationList = headerNavigationList;
    }

    @Override
    public boolean isSessionDocument() {
        return this.sessionDocument;
    }

    @Override
    public void setSessionDocument(boolean sessionDocument) {
        this.sessionDocument = sessionDocument;
    }

    @Override
    public Class<? extends DerivedValuesSetter> getDerivedValuesSetterClass() {
        return this.derivedValuesSetterClass;
    }

    @Override
    public void setDerivedValuesSetterClass(Class<? extends DerivedValuesSetter> derivedValuesSetter) {
        this.derivedValuesSetterClass = derivedValuesSetter;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getBusinessRulesClass() == null || this.getBusinessRulesClass().equals(MaintenanceDocumentRuleBase.class)) {
            this.setBusinessRulesClass(org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase.class);
        }
        super.afterPropertiesSet();
    }
}

