/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.document.authorization;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.mask.MaskFormatter;

public class FieldRestriction {
    private String fieldName;
    private boolean editable;
    private boolean viewable;
    private boolean masked;
    private boolean partiallyMasked;
    private MaskFormatter maskFormatter;
    private boolean shouldBeEncrypted;

    public FieldRestriction() {
        this.editable = true;
        this.viewable = true;
    }

    public FieldRestriction(String fieldName, boolean canEdit, boolean canView) {
        this.fieldName = fieldName;
        this.setEditable(canEdit);
        this.setViewable(canView);
    }

    public FieldRestriction(String fieldName, String fieldAuthorizationFlag) {
        if (!(fieldAuthorizationFlag.equals("editable") || fieldAuthorizationFlag.equals("readOnly") || fieldAuthorizationFlag.equals("hidden") || fieldAuthorizationFlag.equals("masked") || fieldAuthorizationFlag.equals("partiallyMasked"))) {
            throw new IllegalArgumentException("The only allowable values are Field.HIDDEN, Field.READONLY, Field.EDITABLE, Field.MASKED and Field.PARTIALLY_MASKED");
        }
        this.fieldName = fieldName;
        if (fieldAuthorizationFlag.equals("editable")) {
            this.editable = true;
            this.viewable = true;
        } else if (fieldAuthorizationFlag.equals("readOnly")) {
            this.editable = false;
            this.viewable = true;
        } else if (fieldAuthorizationFlag.equals("hidden")) {
            this.editable = false;
            this.viewable = false;
        } else if (fieldAuthorizationFlag.equals("masked")) {
            this.masked = true;
            this.viewable = true;
            this.editable = false;
        } else if (fieldAuthorizationFlag.equals("partiallyMasked")) {
            this.partiallyMasked = true;
            this.viewable = true;
            this.editable = false;
        }
    }

    public String getKualiFieldDisplayFlag() {
        if (!this.editable && !this.viewable) {
            return "hidden";
        }
        if (!this.editable && this.viewable) {
            return "readOnly";
        }
        return "editable";
    }

    public boolean isRestricted() {
        return !this.editable || !this.viewable;
    }

    public boolean isHidden() {
        return !this.editable && !this.viewable;
    }

    public boolean isReadOnly() {
        return !this.editable && this.viewable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (editable && !this.viewable) {
            this.viewable = true;
        }
        this.editable = editable;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public void setViewable(boolean viewable) {
        if (!viewable && this.editable) {
            this.editable = false;
        }
        this.viewable = viewable;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.fieldName);
        sb.append(" [");
        if (this.editable) {
            sb.append("editable");
        } else {
            sb.append("not editable");
        }
        sb.append(",");
        if (this.viewable) {
            sb.append("viewable");
        } else {
            sb.append("not viewable");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        FieldRestriction other;
        boolean equal = false;
        if (obj != null && this.getClass().equals(obj.getClass()) && StringUtils.equals((CharSequence)this.fieldName, (CharSequence)(other = (FieldRestriction)obj).getFieldName()) && this.editable == other.isEditable() && this.viewable == other.isViewable()) {
            equal = true;
        }
        return equal;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isMasked() {
        return this.masked;
    }

    public boolean isPartiallyMasked() {
        return this.partiallyMasked;
    }

    public boolean isShouldBeEncrypted() {
        return this.shouldBeEncrypted;
    }

    public void setShouldBeEncrypted(boolean shouldBeEncrypted) {
        this.shouldBeEncrypted = shouldBeEncrypted;
    }

    public MaskFormatter getMaskFormatter() {
        return this.maskFormatter;
    }

    public void setMaskFormatter(MaskFormatter maskFormatter) {
        this.maskFormatter = maskFormatter;
    }
}

