/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.form;

import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.krad.bo.BusinessObject;

public class DisplayInactivationBlockersForm
extends KualiForm {
    private static final Logger LOG = LogManager.getLogger(DisplayInactivationBlockersForm.class);
    private String businessObjectClassName;
    private Map<String, String> primaryKeyFieldValues;
    private Map<String, List<String>> blockingValues;

    @Override
    public void populate(HttpServletRequest request) {
        super.populate(request);
        this.primaryKeyFieldValues = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)this.businessObjectClassName)) {
            throw new IllegalArgumentException("BO Class Name missing.");
        }
        Class<?> businessObjectClass = null;
        try {
            businessObjectClass = Class.forName(this.businessObjectClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to find class: " + this.businessObjectClassName, (Throwable)e);
            throw new IllegalArgumentException("Unable to find class: " + this.businessObjectClassName, e);
        }
        if (!BusinessObject.class.isAssignableFrom(businessObjectClass)) {
            LOG.error("BO Class is not a BusinessObject: " + this.businessObjectClassName);
            throw new IllegalArgumentException("BO Class is not a BusinessObject: " + this.businessObjectClassName);
        }
        EncryptionService encryptionService = CoreApiServiceLocator.getEncryptionService();
        BusinessObjectAuthorizationService businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        List<String> primaryKeyFieldNames = KNSServiceLocator.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(businessObjectClass);
        for (String primaryKeyFieldName : primaryKeyFieldNames) {
            String primaryKeyFieldValue = request.getParameter(primaryKeyFieldName);
            if (StringUtils.isBlank((CharSequence)primaryKeyFieldValue)) {
                LOG.error("Missing primary key value for: " + primaryKeyFieldName);
                throw new IllegalArgumentException("Missing primary key value for: " + primaryKeyFieldName);
            }
            if (businessObjectAuthorizationService.attributeValueNeedsToBeEncryptedOnFormsAndLinks(businessObjectClass, primaryKeyFieldName)) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        primaryKeyFieldValue = encryptionService.decrypt(primaryKeyFieldValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error("Unable to decrypt secure field for BO " + this.businessObjectClassName + " field " + primaryKeyFieldName, (Throwable)e);
                    throw new RuntimeException("Unable to decrypt secure field for BO " + this.businessObjectClassName + " field " + primaryKeyFieldName, e);
                }
            }
            this.primaryKeyFieldValues.put(primaryKeyFieldName, primaryKeyFieldValue);
        }
    }

    public String getBusinessObjectClassName() {
        return this.businessObjectClassName;
    }

    public void setBusinessObjectClassName(String businessObjectClassName) {
        this.businessObjectClassName = businessObjectClassName;
    }

    public Map<String, String> getPrimaryKeyFieldValues() {
        return this.primaryKeyFieldValues;
    }

    public void setPrimaryKeyFieldValues(Map<String, String> primaryKeyFieldValues) {
        this.primaryKeyFieldValues = primaryKeyFieldValues;
    }

    public Map<String, List<String>> getBlockingValues() {
        return this.blockingValues;
    }

    public void setBlockingValues(Map<String, List<String>> blockingValues) {
        this.blockingValues = blockingValues;
    }
}

