/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.config;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.util.ApplicationThreadLocal;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class GlobalResourceLoaderServiceFactoryBean
implements FactoryBean<Object>,
InitializingBean {
    private String serviceNamespace;
    private String serviceName;
    private boolean singleton;
    private boolean mustExist = true;
    private ThreadLocal<Boolean> isFetchingService = new ApplicationThreadLocal<Boolean>(){

        protected Boolean initialValue() {
            return false;
        }
    };

    public Object getObject() {
        if (this.isFetchingService.get().booleanValue()) {
            return null;
        }
        this.isFetchingService.set(true);
        try {
            Object service = null;
            service = StringUtils.isBlank((CharSequence)this.getServiceNamespace()) ? GlobalResourceLoader.getService((String)this.getServiceName()) : GlobalResourceLoader.getService((QName)new QName(this.getServiceNamespace(), this.getServiceName()));
            if (this.mustExist && service == null) {
                throw new IllegalStateException("Service must exist and no service could be located with serviceNamespace='" + this.getServiceNamespace() + "' and name='" + this.getServiceName() + "'");
            }
            Object object = service;
            return object;
        }
        finally {
            this.isFetchingService.remove();
        }
    }

    public Class<?> getObjectType() {
        return Object.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getServiceName())) {
            throw new ConfigurationException("No serviceName given.");
        }
    }
}

