/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.dao.jdbc;

import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.dao.SequenceAccessorDao;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.framework.persistence.jdbc.dao.PlatformAwareDaoBaseJdbc;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springmodules.orm.ojb.OjbFactoryUtils;

public class SequenceAccessorDaoJdbc
extends PlatformAwareDaoBaseJdbc
implements SequenceAccessorDao {
    private KualiModuleService kualiModuleService;

    private Long nextAvailableSequenceNumber(String sequenceName, Class<? extends BusinessObject> clazz) {
        ModuleService moduleService = this.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService == null) {
            throw new ConfigurationException("moduleService is null");
        }
        ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
        if (moduleConfig == null) {
            throw new ConfigurationException("moduleConfiguration is null");
        }
        String dataSourceName = moduleConfig.getDataSourceName();
        if (StringUtils.isEmpty((CharSequence)dataSourceName)) {
            throw new ConfigurationException("dataSourceName is not set");
        }
        PBKey key = new PBKey(dataSourceName);
        PersistenceBroker broker = OjbFactoryUtils.getPersistenceBroker((PBKey)key, (boolean)false);
        if (broker != null) {
            return this.getDbPlatform().getNextValSQL(sequenceName, (Object)broker);
        }
        throw new ConfigurationException("PersistenceBroker is null");
    }

    @Override
    public Long getNextAvailableSequenceNumber(String sequenceName, Class<? extends BusinessObject> clazz) {
        try {
            return this.nextAvailableSequenceNumber(sequenceName, clazz);
        }
        catch (ConfigurationException e) {
            return this.nextAvailableSequenceNumber(sequenceName, DocumentHeader.class);
        }
    }

    @Override
    public Long getNextAvailableSequenceNumber(String sequenceName) {
        return this.nextAvailableSequenceNumber(sequenceName, DocumentHeader.class);
    }

    private KualiModuleService getKualiModuleService() {
        if (this.kualiModuleService == null) {
            this.kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return this.kualiModuleService;
    }
}

