/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.kfs.krad.datadictionary.BeanOverride;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;
import org.kuali.kfs.krad.datadictionary.DataDictionaryIndex;
import org.kuali.kfs.krad.datadictionary.DataDictionaryIndexMapper;
import org.kuali.kfs.krad.datadictionary.DataDictionaryMapper;
import org.kuali.kfs.krad.datadictionary.DataObjectEntry;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.datadictionary.UifDictionaryIndex;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.parse.StringListConverter;
import org.kuali.kfs.krad.datadictionary.parse.StringMapConverter;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.util.ComponentBeanPostProcessor;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.ResourceLoaderUtil;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

public class DataDictionary {
    private static final Log LOG = LogFactory.getLog(DataDictionary.class);
    private static Map<String, Map<String, PropertyDescriptor>> cache = new TreeMap<String, Map<String, PropertyDescriptor>>();
    static boolean validateEBOs = false;
    public static PersistenceStructureService persistenceStructureService;
    protected DefaultListableBeanFactory ddBeans = new DefaultListableBeanFactory();
    protected XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.ddBeans);
    protected DataDictionaryIndex ddIndex = new DataDictionaryIndex(this.ddBeans);
    protected UifDictionaryIndex uifIndex = new UifDictionaryIndex(this.ddBeans);
    protected DataDictionaryMapper ddMapper = new DataDictionaryIndexMapper();
    protected List<String> configFileLocations = new ArrayList<String>();

    public List<String> getConfigFileLocations() {
        return this.configFileLocations;
    }

    public void setConfigFileLocations(List<String> configFileLocations) {
        this.configFileLocations = configFileLocations;
    }

    public void addConfigFileLocation(String location) throws IOException {
        this.indexSource(location);
    }

    public void addConfigFileLocation(String location, ApplicationContext applicationContext) throws IOException {
        this.indexSource(location, applicationContext);
    }

    public void setDataDictionaryMapper(DataDictionaryMapper mapper) {
        this.ddMapper = mapper;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void indexSource(String sourceName) throws IOException {
        Resource resource;
        if (sourceName == null) {
            throw new DataDictionaryException("Source Name given is null");
        }
        if (!sourceName.endsWith(".xml")) {
            Resource resource2 = ResourceLoaderUtil.getFileResource(sourceName);
            if (resource2.exists()) {
                this.indexSource(resource2.getFile());
                return;
            }
            LOG.warn((Object)("Could not find " + sourceName));
            throw new DataDictionaryException("DD Resource " + sourceName + " not found");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding sourceName " + sourceName + " "));
        }
        if (!(resource = ResourceLoaderUtil.getFileResource(sourceName)).exists()) {
            throw new DataDictionaryException("DD Resource " + sourceName + " not found");
        }
        String indexName = sourceName.substring(sourceName.lastIndexOf("/") + 1, sourceName.indexOf(".xml"));
        this.configFileLocations.add(sourceName);
    }

    private void indexSource(String sourceName, ApplicationContext applicationContext) throws IOException {
        if (sourceName == null) {
            throw new DataDictionaryException("Source Name given is null");
        }
        if (sourceName.endsWith(".xml")) {
            Resource[] resources;
            for (Resource resource : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)applicationContext).getResources(sourceName)) {
                if (resource.exists()) {
                    String resourcePath = ResourceLoaderUtil.parseResourcePathFromUrl(resource);
                    if (StringUtils.isBlank((CharSequence)resourcePath)) continue;
                    this.configFileLocations.add(resourcePath);
                    continue;
                }
                LOG.warn((Object)("Could not find " + sourceName));
                throw new DataDictionaryException("DD Resource " + sourceName + " not found");
            }
        } else {
            Resource resource;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("adding sourceName " + sourceName + " "));
            }
            if (!(resource = ResourceLoaderUtil.getFileResource(sourceName, applicationContext)).exists()) {
                throw new DataDictionaryException("DD Resource " + sourceName + " not found");
            }
            String indexName = sourceName.substring(sourceName.lastIndexOf("/") + 1, sourceName.indexOf(".xml"));
            this.configFileLocations.add(sourceName);
        }
    }

    private void indexSource(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.indexSource(file);
                continue;
            }
            if (file.getName().endsWith(".xml")) {
                this.configFileLocations.add("file:" + file.getAbsolutePath());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping non xml file " + file.getAbsolutePath() + " in DD load"));
        }
    }

    public void parseDataDictionaryConfigurationFiles(boolean allowConcurrentValidation) {
        try {
            BeanPostProcessor idPostProcessor = (BeanPostProcessor)ComponentBeanPostProcessor.class.newInstance();
            this.ddBeans.addBeanPostProcessor(idPostProcessor);
            this.ddBeans.setBeanExpressionResolver((BeanExpressionResolver)new StandardBeanExpressionResolver());
            GenericConversionService conversionService = new GenericConversionService();
            conversionService.addConverter((GenericConverter)new StringMapConverter());
            conversionService.addConverter((GenericConverter)new StringListConverter());
            this.ddBeans.setConversionService((ConversionService)conversionService);
        }
        catch (Exception e1) {
            LOG.error((Object)("Cannot create component decorator post processor: " + e1.getMessage()), (Throwable)e1);
            throw new RuntimeException("Cannot create component decorator post processor: " + e1.getMessage(), e1);
        }
        LOG.info((Object)"Starting DD XML File Load");
        String[] configFileLocationsArray = new String[this.configFileLocations.size()];
        configFileLocationsArray = this.configFileLocations.toArray(configFileLocationsArray);
        this.configFileLocations.clear();
        try {
            this.xmlReader.loadBeanDefinitions(configFileLocationsArray);
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading bean definitions", (Throwable)e);
            throw new DataDictionaryException("Error loading bean definitions: " + e.getLocalizedMessage());
        }
        LOG.info((Object)"Completed DD XML File Load");
        if (allowConcurrentValidation) {
            Thread t = new Thread(this.ddIndex);
            t.start();
        } else {
            this.ddIndex.run();
        }
    }

    public void validateDD(boolean validateEbos) {
        validateEBOs = validateEbos;
        Map doBeans = this.ddBeans.getBeansOfType(DataObjectEntry.class);
        for (DataObjectEntry entry : doBeans.values()) {
            entry.completeValidation();
        }
        Map docBeans = this.ddBeans.getBeansOfType(DocumentEntry.class);
        for (DocumentEntry entry : docBeans.values()) {
            entry.completeValidation();
        }
    }

    public void validateDD() {
        this.validateDD(validateEBOs);
    }

    public BusinessObjectEntry getBusinessObjectEntry(String className) {
        return this.ddMapper.getBusinessObjectEntry(this.ddIndex, className);
    }

    public DataObjectEntry getDataObjectEntry(String className) {
        return this.ddMapper.getDataObjectEntry(this.ddIndex, className);
    }

    public BusinessObjectEntry getBusinessObjectEntryForConcreteClass(String className) {
        return this.ddMapper.getBusinessObjectEntryForConcreteClass(this.ddIndex, className);
    }

    public List<String> getBusinessObjectClassNames() {
        return this.ddMapper.getBusinessObjectClassNames(this.ddIndex);
    }

    public Map<String, BusinessObjectEntry> getBusinessObjectEntries() {
        return this.ddMapper.getBusinessObjectEntries(this.ddIndex);
    }

    public DataDictionaryEntry getDictionaryObjectEntry(String className) {
        return this.ddMapper.getDictionaryObjectEntry(this.ddIndex, className);
    }

    public DocumentEntry getDocumentEntry(String documentTypeDDKey) {
        return this.ddMapper.getDocumentEntry(this.ddIndex, documentTypeDDKey);
    }

    public MaintenanceDocumentEntry getMaintenanceDocumentEntryForBusinessObjectClass(Class<?> businessObjectClass) {
        return this.ddMapper.getMaintenanceDocumentEntryForBusinessObjectClass(this.ddIndex, businessObjectClass);
    }

    public Map<String, DocumentEntry> getDocumentEntries() {
        return this.ddMapper.getDocumentEntries(this.ddIndex);
    }

    public View getViewById(String viewId) {
        return this.ddMapper.getViewById(this.uifIndex, viewId);
    }

    public View getViewByTypeIndex(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.getViewByTypeIndex(this.uifIndex, viewTypeName, indexKey);
    }

    public boolean viewByTypeExist(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.viewByTypeExist(this.uifIndex, viewTypeName, indexKey);
    }

    public List<View> getViewsForType(UifConstants.ViewType viewTypeName) {
        return this.ddMapper.getViewsForType(this.uifIndex, viewTypeName);
    }

    public Object getDictionaryObject(String beanName) {
        return this.ddBeans.getBean(beanName);
    }

    public boolean containsDictionaryObject(String id) {
        return this.ddBeans.containsBean(id);
    }

    public PropertyValues getViewPropertiesById(String viewId) {
        return this.ddMapper.getViewPropertiesById(this.uifIndex, viewId);
    }

    public PropertyValues getViewPropertiesByType(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.getViewPropertiesByType(this.uifIndex, viewTypeName, indexKey);
    }

    public static boolean isPropertyOf(Class targetClass, String propertyName) {
        if (targetClass == null) {
            throw new IllegalArgumentException("invalid (null) targetClass");
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        PropertyDescriptor propertyDescriptor = DataDictionary.buildReadDescriptor(targetClass, propertyName);
        boolean isPropertyOf = propertyDescriptor != null;
        return isPropertyOf;
    }

    public static boolean isCollectionPropertyOf(Class targetClass, String propertyName) {
        Class<?> clazz;
        boolean isCollectionPropertyOf = false;
        PropertyDescriptor propertyDescriptor = DataDictionary.buildReadDescriptor(targetClass, propertyName);
        if (propertyDescriptor != null && (clazz = propertyDescriptor.getPropertyType()) != null && Collection.class.isAssignableFrom(clazz)) {
            isCollectionPropertyOf = true;
        }
        return isCollectionPropertyOf;
    }

    public static PersistenceStructureService getPersistenceStructureService() {
        if (persistenceStructureService == null) {
            persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return persistenceStructureService;
    }

    public static Class getAttributeClass(Class boClass, String attributeName) {
        if (!DataDictionary.isPropertyOf(boClass, attributeName)) {
            throw new AttributeValidationException("unable to find attribute '" + attributeName + "' in rootClass '" + boClass.getName() + "'");
        }
        if (boClass.isInterface()) {
            return DataDictionary.getAttributeClassWhenBOIsInterface(boClass, attributeName);
        }
        return DataDictionary.getAttributeClassWhenBOIsClass(boClass, attributeName);
    }

    private static Class getAttributeClassWhenBOIsClass(Class boClass, String attributeName) {
        Object boInstance;
        try {
            boInstance = boClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate Data Object: " + boClass, e);
        }
        try {
            return ObjectUtils.getPropertyType(boInstance, attributeName, DataDictionary.getPersistenceStructureService());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine property type for: " + boClass.getName() + "." + attributeName, e);
        }
    }

    private static Class getAttributeClassWhenBOIsInterface(Class boClass, String attributeName) {
        if (boClass == null) {
            throw new IllegalArgumentException("invalid (null) boClass");
        }
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        PropertyDescriptor propertyDescriptor = null;
        String[] intermediateProperties = attributeName.split("\\.");
        int lastLevel = intermediateProperties.length - 1;
        Class<?> currentClass = boClass;
        for (int i = 0; i <= lastLevel; ++i) {
            Class<?> propertyType;
            String currentPropertyName = intermediateProperties[i];
            propertyDescriptor = DataDictionary.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (propertyDescriptor != null) {
                propertyType = propertyDescriptor.getPropertyType();
                if (propertyType.equals(PersistableBusinessObjectExtension.class)) {
                    propertyType = DataDictionary.getPersistenceStructureService().getBusinessObjectAttributeClass((Class<? extends PersistableBusinessObject>)currentClass, currentPropertyName);
                }
                if (Collection.class.isAssignableFrom(propertyType)) {
                    throw new AttributeValidationException("Can't determine the Class of Collection elements because when the business object is an (possibly ExternalizableBusinessObject) interface.");
                }
            } else {
                throw new AttributeValidationException("Can't find getter method of " + boClass.getName() + " for property " + attributeName);
            }
            currentClass = propertyType;
        }
        return currentClass;
    }

    public static Class getCollectionElementClass(Class boClass, String collectionName) {
        if (boClass == null) {
            throw new IllegalArgumentException("invalid (null) boClass");
        }
        if (StringUtils.isBlank((CharSequence)collectionName)) {
            throw new IllegalArgumentException("invalid (blank) collectionName");
        }
        PropertyDescriptor propertyDescriptor = null;
        String[] intermediateProperties = collectionName.split("\\.");
        Class currentClass = boClass;
        for (int i = 0; i < intermediateProperties.length; ++i) {
            String currentPropertyName = intermediateProperties[i];
            propertyDescriptor = DataDictionary.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (propertyDescriptor == null) continue;
            Class<?> type = propertyDescriptor.getPropertyType();
            if (Collection.class.isAssignableFrom(type)) {
                if (DataDictionary.getPersistenceStructureService().isPersistable(currentClass)) {
                    Map<Object, Object> collectionClasses = new HashMap();
                    collectionClasses = DataDictionary.getPersistenceStructureService().listCollectionObjectTypes(currentClass);
                    currentClass = (Class)collectionClasses.get(currentPropertyName);
                    continue;
                }
                throw new RuntimeException("Can't determine the Class of Collection elements because persistenceStructureService.isPersistable(" + currentClass.getName() + ") returns false.");
            }
            currentClass = propertyDescriptor.getPropertyType();
        }
        return currentClass;
    }

    public static PropertyDescriptor buildReadDescriptor(Class propertyClass, String propertyName) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("invalid (null) propertyClass");
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        PropertyDescriptor propertyDescriptor = null;
        String[] intermediateProperties = propertyName.split("\\.");
        int lastLevel = intermediateProperties.length - 1;
        Class<Object> currentClass = propertyClass;
        for (int i = 0; i <= lastLevel; ++i) {
            String currentPropertyName = intermediateProperties[i];
            propertyDescriptor = DataDictionary.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (i >= lastLevel || propertyDescriptor == null) continue;
            Class<Object> propertyType = propertyDescriptor.getPropertyType();
            if (propertyType.equals(PersistableBusinessObjectExtension.class)) {
                propertyType = DataDictionary.getPersistenceStructureService().getBusinessObjectAttributeClass((Class<? extends PersistableBusinessObject>)currentClass, currentPropertyName);
            }
            if (Collection.class.isAssignableFrom(propertyType)) {
                if (DataDictionary.getPersistenceStructureService().isPersistable(currentClass)) {
                    Map<Object, Object> collectionClasses = new HashMap();
                    collectionClasses = DataDictionary.getPersistenceStructureService().listCollectionObjectTypes(currentClass);
                    currentClass = (Class)collectionClasses.get(currentPropertyName);
                    continue;
                }
                throw new RuntimeException("Can't determine the Class of Collection elements because persistenceStructureService.isPersistable(" + currentClass.getName() + ") returns false.");
            }
            currentClass = propertyType;
        }
        return propertyDescriptor;
    }

    public static PropertyDescriptor buildSimpleReadDescriptor(Class propertyClass, String propertyName) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("invalid (null) propertyClass");
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        Object p = null;
        String propertyClassName = propertyClass.getName();
        Map<String, PropertyDescriptor> m = cache.get(propertyClassName);
        if (null != m && null != (p = m.get(propertyName))) {
            return p;
        }
        Object[] descriptors = PropertyUtils.getPropertyDescriptors((Class)propertyClass);
        if (ArrayUtils.isNotEmpty((Object[])descriptors)) {
            for (Object descriptor : descriptors) {
                if (!((FeatureDescriptor)descriptor).getName().equals(propertyName)) continue;
                p = descriptor;
            }
        }
        if (p != null) {
            if (m == null) {
                m = new TreeMap<String, PropertyDescriptor>();
                cache.put(propertyClassName, m);
            }
            m.put(propertyName, (PropertyDescriptor)p);
        }
        return p;
    }

    public Set<InactivationBlockingMetadata> getAllInactivationBlockingMetadatas(Class blockedClass) {
        return this.ddMapper.getAllInactivationBlockingMetadatas(this.ddIndex, blockedClass);
    }

    public void performBeanOverrides() {
        Collection beanOverrides = this.ddBeans.getBeansOfType(BeanOverride.class).values();
        if (beanOverrides.isEmpty()) {
            LOG.info((Object)"DataDictionary.performOverrides(): No beans to override");
        }
        for (BeanOverride beanOverride : beanOverrides) {
            Object bean = this.ddBeans.getBean(beanOverride.getBeanName());
            beanOverride.performOverride(bean);
            LOG.info((Object)("DataDictionary.performOverrides(): Performing override on bean: " + bean.toString()));
        }
    }

    public Map<String, String> getChildAttributesParent() {
        return this.ddIndex.getChildAttributesParent();
    }
}

