/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.datadictionary.validation.constraint.ValidDataPatternConstraint;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class IntegerPatternConstraint
extends ValidDataPatternConstraint {
    protected boolean allowNegative;
    protected boolean onlyNegative;
    protected boolean omitZero;

    @Override
    protected String getRegexString() {
        StringBuffer regex = new StringBuffer();
        if (this.isAllowNegative() && !this.onlyNegative) {
            regex.append("((-?");
        } else if (this.onlyNegative) {
            regex.append("((-");
        } else {
            regex.append("((");
        }
        if (this.omitZero) {
            regex.append("[1-9][0-9]*))");
        } else {
            regex.append("[1-9][0-9]*)|[0]*)");
        }
        return regex.toString();
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public boolean isOnlyNegative() {
        return this.onlyNegative;
    }

    public void setOnlyNegative(boolean onlyNegative) {
        this.onlyNegative = onlyNegative;
    }

    public boolean isOmitZero() {
        return this.omitZero;
    }

    public void setOmitZero(boolean omitZero) {
        this.omitZero = omitZero;
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            ConfigurationService configService = KRADServiceLocator.getKualiConfigurationService();
            if (this.allowNegative && !this.onlyNegative) {
                if (this.omitZero) {
                    this.validationMessageParams.add(configService.getPropertyValueAsString("validation.positiveOrNegative"));
                } else {
                    this.validationMessageParams.add(configService.getPropertyValueAsString("validation.positiveOrNegativeOrZero"));
                }
            } else if (this.onlyNegative) {
                if (this.omitZero) {
                    this.validationMessageParams.add(configService.getPropertyValueAsString("validation.negative"));
                } else {
                    this.validationMessageParams.add(configService.getPropertyValueAsString("validation.negativeOrZero"));
                }
            } else if (this.omitZero) {
                this.validationMessageParams.add(configService.getPropertyValueAsString("validation.positive"));
            } else {
                this.validationMessageParams.add(configService.getPropertyValueAsString("validation.positiveOrZero"));
            }
        }
        return this.validationMessageParams;
    }
}

