/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.processor;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.ValidationUtils;
import org.kuali.kfs.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.Formatable;
import org.kuali.kfs.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.kfs.krad.datadictionary.validation.processor.MandatoryElementConstraintProcessor;
import org.kuali.kfs.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.ProcessorResult;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.web.format.DateFormatter;

public class ValidCharactersConstraintProcessor
extends MandatoryElementConstraintProcessor<ValidCharactersConstraint> {
    public static final String VALIDATE_METHOD = "validate";
    private static final Logger LOG = LogManager.getLogger(ValidCharactersConstraintProcessor.class);
    private static final String[] DATE_RANGE_ERROR_PREFIXES = new String[]{"rangeLowerBoundKeyPrefix_", "rangeUpperBoundKeyPrefix_"};
    private static final String CONSTRAINT_NAME = "valid characters constraint";

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Object value, ValidCharactersConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        return new ProcessorResult(this.processSingleValidCharacterConstraint(result, value, constraint, attributeValueReader));
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return ValidCharactersConstraint.class;
    }

    protected ConstraintValidationResult processSingleValidCharacterConstraint(DictionaryValidationResult result, Object value, ValidCharactersConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        if (constraint == null) {
            return result.addNoConstraint(attributeValueReader, CONSTRAINT_NAME);
        }
        if (ValidationUtils.isNullOrEmpty(value)) {
            return result.addSkipped(attributeValueReader, CONSTRAINT_NAME);
        }
        Constrainable definition = attributeValueReader.getDefinition(attributeValueReader.getAttributeName());
        if (definition instanceof Formatable) {
            return this.doProcessFormattableValidCharConstraint(result, constraint, (Formatable)((Object)definition), value, attributeValueReader);
        }
        ConstraintValidationResult constraintValidationResult = this.doProcessValidCharConstraint(constraint, value);
        if (constraintValidationResult == null) {
            return result.addSuccess(attributeValueReader, CONSTRAINT_NAME);
        }
        result.addConstraintValidationResult(attributeValueReader, constraintValidationResult);
        constraintValidationResult.setConstraintLabelKey(constraint.getLabelKey());
        constraintValidationResult.setErrorParameters(constraint.getValidationMessageParamsArray());
        return constraintValidationResult;
    }

    protected ConstraintValidationResult doProcessFormattableValidCharConstraint(DictionaryValidationResult result, ValidCharactersConstraint validCharsConstraint, Formatable definition, Object value, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        String entryName = attributeValueReader.getEntryName();
        String attributeName = attributeValueReader.getAttributeName();
        List<String> parsedAttributeValues = attributeValueReader.getCleanSearchableValues(attributeName);
        if (parsedAttributeValues != null) {
            ConstraintValidationResult dateOrderValidationResult;
            Class formatterClass = null;
            Boolean doValidateDateRangeOrder = null;
            if (parsedAttributeValues.size() != 2) {
                doValidateDateRangeOrder = Boolean.FALSE;
            }
            for (int i = 0; i < parsedAttributeValues.size(); ++i) {
                String formatterClassName;
                String parsedAttributeValue = parsedAttributeValues.get(i);
                ConstraintValidationResult constraintValidationResult = this.doProcessValidCharConstraint(validCharsConstraint, parsedAttributeValue);
                if (constraintValidationResult == null) continue;
                constraintValidationResult.setConstraintLabelKey(validCharsConstraint.getLabelKey());
                constraintValidationResult.setErrorParameters(validCharsConstraint.getValidationMessageParamsArray());
                if (formatterClass == null && (formatterClassName = definition.getFormatterClass()) != null) {
                    formatterClass = ClassLoaderUtils.getClass((String)formatterClassName);
                }
                if (formatterClass != null) {
                    if (doValidateDateRangeOrder == null) {
                        doValidateDateRangeOrder = DateFormatter.class.isAssignableFrom(formatterClass) && StringUtils.contains((CharSequence)ValidationUtils.getString(value), (CharSequence)SearchOperator.BETWEEN.toString());
                    }
                    if ((constraintValidationResult = this.processFormatterValidation(result, formatterClass, entryName, attributeName, parsedAttributeValue, DATE_RANGE_ERROR_PREFIXES[i])) == null) continue;
                    result.addConstraintValidationResult(attributeValueReader, constraintValidationResult);
                    return constraintValidationResult;
                }
                result.addConstraintValidationResult(attributeValueReader, constraintValidationResult);
                return constraintValidationResult;
            }
            if (doValidateDateRangeOrder != null && doValidateDateRangeOrder.booleanValue() && (dateOrderValidationResult = this.validateDateOrder(parsedAttributeValues.get(0), parsedAttributeValues.get(1), entryName, attributeName)) != null) {
                result.addConstraintValidationResult(attributeValueReader, dateOrderValidationResult);
                return dateOrderValidationResult;
            }
            return result.addSuccess(attributeValueReader, CONSTRAINT_NAME);
        }
        return result.addSkipped(attributeValueReader, CONSTRAINT_NAME);
    }

    protected ConstraintValidationResult doProcessValidCharConstraint(ValidCharactersConstraint validCharsConstraint, Object value) {
        StringBuilder fieldValue = new StringBuilder();
        String validChars = validCharsConstraint.getValue();
        fieldValue.append(ValidationUtils.getString(value));
        if (!fieldValue.toString().matches(validChars)) {
            ConstraintValidationResult constraintValidationResult = new ConstraintValidationResult(CONSTRAINT_NAME);
            if (validCharsConstraint.getLabelKey() != null) {
                constraintValidationResult.setError("error.custom", validCharsConstraint.getLabelKey());
                return constraintValidationResult;
            }
            constraintValidationResult.setError("error.invalidFormat", fieldValue.toString());
            constraintValidationResult.setConstraintLabelKey(validCharsConstraint.getLabelKey());
            constraintValidationResult.setErrorParameters(validCharsConstraint.getValidationMessageParamsArray());
            return constraintValidationResult;
        }
        return null;
    }

    protected ConstraintValidationResult processFormatterValidation(DictionaryValidationResult result, Class<?> formatterClass, String entryName, String attributeName, String parsedAttributeValue, String errorKeyPrefix) {
        boolean isError = false;
        try {
            Method validatorMethod = formatterClass.getDeclaredMethod(VALIDATE_METHOD, String.class);
            Object o = validatorMethod.invoke(formatterClass.newInstance(), parsedAttributeValue);
            if (o instanceof Boolean) {
                isError = (Boolean)o == false;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            isError = true;
        }
        if (isError) {
            String errorMessageKey = this.getDataDictionaryService().getAttributeValidatingErrorMessageKey(entryName, attributeName);
            String[] errorMessageParameters = this.getDataDictionaryService().getAttributeValidatingErrorMessageParameters(entryName, attributeName);
            ConstraintValidationResult constraintValidationResult = new ConstraintValidationResult(CONSTRAINT_NAME);
            constraintValidationResult.setEntryName(entryName);
            constraintValidationResult.setAttributeName(errorKeyPrefix + attributeName);
            constraintValidationResult.setError(errorMessageKey, errorMessageParameters);
            return constraintValidationResult;
        }
        return null;
    }

    protected ConstraintValidationResult validateDateOrder(String firstDateTime, String secondDateTime, String entryName, String attributeName) {
        Timestamp lVal = null;
        Timestamp uVal = null;
        try {
            lVal = CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(firstDateTime);
            uVal = CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(secondDateTime);
        }
        catch (Exception ex) {
            String errorMessageKey = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeValidatingErrorMessageKey(entryName, attributeName);
            String[] errorMessageParameters = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeValidatingErrorMessageParameters(entryName, attributeName);
            ConstraintValidationResult constraintValidationResult = new ConstraintValidationResult(CONSTRAINT_NAME);
            constraintValidationResult.setEntryName(entryName);
            constraintValidationResult.setAttributeName("rangeLowerBoundKeyPrefix_" + attributeName);
            constraintValidationResult.setError(errorMessageKey, errorMessageParameters);
            return constraintValidationResult;
        }
        if (lVal != null && lVal.compareTo(uVal) > 0) {
            String errorMessageKey = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeValidatingErrorMessageKey(entryName, attributeName);
            String[] errorMessageParameters = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeValidatingErrorMessageParameters(entryName, attributeName);
            ConstraintValidationResult constraintValidationResult = new ConstraintValidationResult(CONSTRAINT_NAME);
            constraintValidationResult.setEntryName(entryName);
            constraintValidationResult.setAttributeName("rangeLowerBoundKeyPrefix_" + attributeName);
            constraintValidationResult.setError(errorMessageKey + ".range", errorMessageParameters);
            return constraintValidationResult;
        }
        return null;
    }
}

