/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.result;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.ErrorLevel;
import org.kuali.kfs.krad.datadictionary.validation.ValidationUtils;
import org.kuali.kfs.krad.datadictionary.validation.result.AttributeValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.EntryValidationResult;

public class DictionaryValidationResult
implements Iterable<ConstraintValidationResult> {
    private Map<String, EntryValidationResult> entryValidationResultMap = new LinkedHashMap<String, EntryValidationResult>();
    private ErrorLevel errorLevel = ErrorLevel.ERROR;
    private int numberOfErrors = 0;
    private int numberOfWarnings = 0;
    private Iterator<ConstraintValidationResult> iterator;

    public void addConstraintValidationResult(AttributeValueReader attributeValueReader, ConstraintValidationResult constraintValidationResult) {
        if (constraintValidationResult.getStatus().getLevel() < this.errorLevel.getLevel()) {
            return;
        }
        switch (constraintValidationResult.getStatus()) {
            case ERROR: {
                ++this.numberOfErrors;
                break;
            }
            case WARN: {
                ++this.numberOfWarnings;
                break;
            }
        }
        String entryName = constraintValidationResult.getEntryName();
        String attributeName = constraintValidationResult.getAttributeName();
        String attributePath = constraintValidationResult.getAttributePath();
        if (entryName == null) {
            entryName = attributeValueReader.getEntryName();
        }
        if (attributeName == null) {
            attributeName = attributeValueReader.getAttributeName();
        }
        if (attributePath == null) {
            attributePath = attributeValueReader.getPath();
        }
        constraintValidationResult.setEntryName(entryName);
        constraintValidationResult.setAttributeName(attributeName);
        constraintValidationResult.setAttributePath(attributePath);
        String entryKey = this.getEntryValdidationResultKey(entryName, attributePath);
        this.getEntryValidationResult(entryKey).getAttributeValidationResult(attributeName).addConstraintValidationResult(constraintValidationResult);
    }

    public ConstraintValidationResult addError(AttributeValueReader attributeValueReader, String constraintName, String errorKey, String ... errorParameters) {
        ConstraintValidationResult constraintValidationResult = this.getConstraintValidationResult(attributeValueReader.getEntryName(), attributeValueReader.getAttributeName(), attributeValueReader.getPath(), constraintName);
        constraintValidationResult.setError(errorKey, errorParameters);
        ++this.numberOfErrors;
        return constraintValidationResult;
    }

    public ConstraintValidationResult addError(String constraintLabelKey, AttributeValueReader attributeValueReader, String constraintName, String errorKey, String ... errorParameters) {
        ConstraintValidationResult constraintValidationResult = this.getConstraintValidationResult(attributeValueReader.getEntryName(), attributeValueReader.getAttributeName(), attributeValueReader.getPath(), constraintName);
        constraintValidationResult.setError(errorKey, errorParameters);
        constraintValidationResult.setConstraintLabelKey(constraintLabelKey);
        ++this.numberOfErrors;
        return constraintValidationResult;
    }

    public ConstraintValidationResult addWarning(AttributeValueReader attributeValueReader, String constraintName, String errorKey, String ... errorParameters) {
        if (this.errorLevel.getLevel() > ErrorLevel.WARN.getLevel()) {
            return new ConstraintValidationResult(constraintName, ErrorLevel.WARN);
        }
        ConstraintValidationResult constraintValidationResult = this.getConstraintValidationResult(attributeValueReader.getEntryName(), attributeValueReader.getAttributeName(), attributeValueReader.getPath(), constraintName);
        constraintValidationResult.setWarning(errorKey, errorParameters);
        ++this.numberOfWarnings;
        return constraintValidationResult;
    }

    public ConstraintValidationResult addSuccess(AttributeValueReader attributeValueReader, String constraintName) {
        if (this.errorLevel.getLevel() > ErrorLevel.OK.getLevel()) {
            return new ConstraintValidationResult(constraintName, ErrorLevel.OK);
        }
        return this.getConstraintValidationResult(attributeValueReader.getEntryName(), attributeValueReader.getAttributeName(), attributeValueReader.getPath(), constraintName);
    }

    public ConstraintValidationResult addSkipped(AttributeValueReader attributeValueReader, String constraintName) {
        if (this.errorLevel.getLevel() > ErrorLevel.OK.getLevel()) {
            return new ConstraintValidationResult(constraintName, ErrorLevel.INAPPLICABLE);
        }
        ConstraintValidationResult constraintValidationResult = this.getConstraintValidationResult(attributeValueReader.getEntryName(), attributeValueReader.getAttributeName(), attributeValueReader.getPath(), constraintName);
        constraintValidationResult.setStatus(ErrorLevel.INAPPLICABLE);
        return constraintValidationResult;
    }

    public ConstraintValidationResult addNoConstraint(AttributeValueReader attributeValueReader, String constraintName) {
        if (this.errorLevel.getLevel() > ErrorLevel.OK.getLevel()) {
            return new ConstraintValidationResult(constraintName, ErrorLevel.NOCONSTRAINT);
        }
        ConstraintValidationResult constraintValidationResult = this.getConstraintValidationResult(attributeValueReader.getEntryName(), attributeValueReader.getAttributeName(), attributeValueReader.getPath(), constraintName);
        constraintValidationResult.setStatus(ErrorLevel.NOCONSTRAINT);
        return constraintValidationResult;
    }

    @Override
    public Iterator<ConstraintValidationResult> iterator() {
        this.iterator = new Iterator<ConstraintValidationResult>(){
            private Iterator<EntryValidationResult> entryIterator;
            private Iterator<AttributeValidationResult> attributeIterator;
            private Iterator<ConstraintValidationResult> constraintIterator;

            @Override
            public boolean hasNext() {
                Iterator<ConstraintValidationResult> currentConstraintIterator = this.getCurrentConstraintIterator();
                return currentConstraintIterator != null && currentConstraintIterator.hasNext();
            }

            @Override
            public ConstraintValidationResult next() {
                Iterator<ConstraintValidationResult> currentConstraintIterator = this.getCurrentConstraintIterator();
                return currentConstraintIterator != null ? currentConstraintIterator.next() : null;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Can't remove from this iterator!");
            }

            private Iterator<ConstraintValidationResult> getCurrentConstraintIterator() {
                Iterator<AttributeValidationResult> currentAttributeIterator;
                if ((this.constraintIterator == null || !this.constraintIterator.hasNext()) && (currentAttributeIterator = this.getCurrentAttributeIterator()) != null && currentAttributeIterator.hasNext()) {
                    AttributeValidationResult currentAttributeValidationResult = currentAttributeIterator.next();
                    this.constraintIterator = currentAttributeValidationResult.iterator();
                }
                return this.constraintIterator;
            }

            private Iterator<AttributeValidationResult> getCurrentAttributeIterator() {
                Iterator<EntryValidationResult> currentEntryIterator;
                if ((this.attributeIterator == null || !this.attributeIterator.hasNext()) && (currentEntryIterator = this.getCurrentEntryIterator()) != null && currentEntryIterator.hasNext()) {
                    EntryValidationResult currentEntryValidationResult = currentEntryIterator.next();
                    this.attributeIterator = currentEntryValidationResult.iterator();
                }
                return this.attributeIterator;
            }

            private Iterator<EntryValidationResult> getCurrentEntryIterator() {
                if (this.entryIterator == null) {
                    this.entryIterator = DictionaryValidationResult.this.entryValidationResultMap.values().iterator();
                }
                return this.entryIterator;
            }
        };
        return this.iterator;
    }

    protected EntryValidationResult getEntryValidationResult(String entryName) {
        EntryValidationResult entryValidationResult = this.entryValidationResultMap.get(entryName);
        if (entryValidationResult == null) {
            entryValidationResult = new EntryValidationResult(entryName);
            this.entryValidationResultMap.put(entryName, entryValidationResult);
        }
        return entryValidationResult;
    }

    private ConstraintValidationResult getConstraintValidationResult(String entryName, String attributeName, String attributePath, String constraintName) {
        String entryKey = this.getEntryValdidationResultKey(entryName, attributePath);
        ConstraintValidationResult constraintValidationResult = this.getEntryValidationResult(entryKey).getAttributeValidationResult(attributeName).getConstraintValidationResult(constraintName);
        constraintValidationResult.setEntryName(entryName);
        constraintValidationResult.setAttributeName(attributeName);
        constraintValidationResult.setAttributePath(attributePath);
        return constraintValidationResult;
    }

    private String getEntryValdidationResultKey(String entryName, String attributePath) {
        if (attributePath.contains("[")) {
            return entryName + "[" + ValidationUtils.getLastPathIndex(attributePath) + "]";
        }
        return entryName;
    }

    public ErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(ErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public int getNumberOfWarnings() {
        return this.numberOfWarnings;
    }
}

