/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.kfs.coreservice.api.component.Component;
import org.kuali.kfs.coreservice.api.component.ComponentService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterConstants;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.TransactionalDocumentEntry;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.service.DataDictionaryComponentPublisherService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.krad.bo.BusinessObject;

public class DataDictionaryComponentPublisherServiceImpl
implements DataDictionaryComponentPublisherService {
    private static final Logger LOG = LogManager.getLogger(DataDictionaryComponentPublisherServiceImpl.class);
    private static final String DEFAULT_COMPONENT_SET_ID_PREFIX = "DD:";
    private DataDictionaryService dataDictionaryService;
    private static volatile KualiModuleService kualiModuleService;
    private ComponentService componentService;
    private String applicationId;

    @Override
    public void publishAllComponents() {
        List<Component> componentsToPublish = this.getComponentsToPublish();
        this.getComponentService().publishDerivedComponents(this.generateComponentSetId(), componentsToPublish);
    }

    protected String generateComponentSetId() {
        if (StringUtils.isBlank((CharSequence)this.getApplicationId())) {
            throw new ConfigurationException("A valid non-null, non-blank application id was not injected into " + this.getClass().getName());
        }
        return DEFAULT_COMPONENT_SET_ID_PREFIX + this.getApplicationId();
    }

    protected List<Component> getComponentsToPublish() {
        Component component;
        ArrayList<Component> components = new ArrayList<Component>();
        HashMap<String, Component> uniqueComponentMap = new HashMap<String, Component>();
        for (BusinessObjectEntry businessObjectEntry : this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntries().values()) {
            try {
                component = this.deriveComponentFromBusinessObjectEntry(businessObjectEntry);
                uniqueComponentMap.put(component.getCode(), component);
            }
            catch (Exception e) {
                LOG.error("An exception was encountered when attempting to publish all components for business object class: " + businessObjectEntry.getBusinessObjectClass(), (Throwable)e);
            }
        }
        for (DocumentEntry documentEntry : this.getDataDictionaryService().getDataDictionary().getDocumentEntries().values()) {
            if (!(documentEntry instanceof TransactionalDocumentEntry)) continue;
            try {
                component = this.deriveComponentFromDocumentEntry(documentEntry);
                uniqueComponentMap.put(component.getCode(), component);
            }
            catch (Exception e) {
                LOG.error("An exception was encountered when attempting to publish all components for transactional document class: " + documentEntry.getDocumentClass(), (Throwable)e);
            }
        }
        components.addAll(uniqueComponentMap.values());
        return components;
    }

    protected Component deriveComponentFromClass(Class<?> componentSourceClass) {
        String componentCode = this.getKualiModuleService().getComponentCode(componentSourceClass);
        String componentName = this.deriveComponentName(componentSourceClass);
        String namespace = this.getKualiModuleService().getNamespaceCode(componentSourceClass);
        if (StringUtils.isBlank((CharSequence)componentName)) {
            componentName = componentCode;
        }
        Component.Builder detailType = Component.Builder.create(namespace, componentCode, componentName);
        return detailType.build();
    }

    protected Component deriveComponentFromBusinessObjectEntry(BusinessObjectEntry businessObjectEntry) {
        Class<? extends BusinessObject> businessObjectClass = businessObjectEntry.getBaseBusinessObjectClass();
        if (businessObjectClass == null) {
            businessObjectClass = businessObjectEntry.getBusinessObjectClass();
        }
        return this.deriveComponentFromClass(businessObjectClass);
    }

    protected Component deriveComponentFromDocumentEntry(DocumentEntry documentEntry) {
        Class<? extends Document> documentClass = documentEntry.getBaseDocumentClass();
        if (documentClass == null) {
            documentClass = documentEntry.getDocumentClass();
        }
        return this.deriveComponentFromClass(documentClass);
    }

    protected String deriveComponentName(Class<?> componentSourceClass) {
        if (componentSourceClass == null) {
            throw new IllegalArgumentException("The deriveComponentName method requires non-null componentSourceClass");
        }
        if (componentSourceClass.isAnnotationPresent(ParameterConstants.COMPONENT.class)) {
            BusinessObjectEntry boe = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(componentSourceClass.getName());
            if (boe != null) {
                return boe.getObjectLabel();
            }
            return componentSourceClass.getAnnotation(ParameterConstants.COMPONENT.class).component();
        }
        if (TransactionalDocument.class.isAssignableFrom(componentSourceClass)) {
            return this.getDataDictionaryService().getDocumentLabelByClass(componentSourceClass);
        }
        if (BusinessObject.class.isAssignableFrom(componentSourceClass)) {
            BusinessObjectEntry boe = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(componentSourceClass.getName());
            if (boe != null) {
                return boe.getObjectLabel();
            }
            return KRADUtils.getBusinessTitleForClass(componentSourceClass);
        }
        throw new IllegalArgumentException("The deriveComponentName method of requires TransactionalDocument or BusinessObject class. Was: " + componentSourceClass.getName());
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        DataDictionaryComponentPublisherServiceImpl.kualiModuleService = kualiModuleService;
    }

    public ComponentService getComponentService() {
        if (this.componentService == null) {
            this.componentService = CoreServiceApiServiceLocator.getComponentService();
        }
        return this.componentService;
    }

    public void setComponentService(ComponentService componentService) {
        this.componentService = componentService;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }
}

