/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.UserSessionUtils;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentAuthorizer;
import org.kuali.kfs.krad.document.DocumentPresentationController;
import org.kuali.kfs.krad.exception.DocumentAuthorizationException;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.maintenance.MaintenanceDocumentBase;
import org.kuali.kfs.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.BlanketApproveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.CompleteDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.NoteType;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.framework.persistence.jta.TransactionalNoValidationExceptionRollback;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.dao.OptimisticLockingFailureException;

@TransactionalNoValidationExceptionRollback
public class DocumentServiceImpl
implements DocumentService {
    private static final Logger LOG = LogManager.getLogger(DocumentServiceImpl.class);
    private DocumentDao documentDao;
    private DateTimeService dateTimeService;
    private NoteService noteService;
    private WorkflowDocumentService workflowDocumentService;
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private DocumentHeaderService documentHeaderService;
    private DocumentDictionaryService documentDictionaryService;
    private PersonService personService;
    private ConfigurationService kualiConfigurationService;

    @Override
    public Document saveDocument(Document document) throws WorkflowException, ValidationException {
        return this.saveDocument(document, SaveDocumentEvent.class);
    }

    @Override
    public Document saveDocument(Document document, Class<? extends KualiDocumentEvent> kualiDocumentEventClass) throws WorkflowException, ValidationException {
        this.checkForNulls(document);
        if (kualiDocumentEventClass == null) {
            throw new IllegalArgumentException("invalid (null) kualiDocumentEventClass");
        }
        if (!SaveEvent.class.isAssignableFrom(kualiDocumentEventClass)) {
            throw new ConfigurationException("The KualiDocumentEvent class '" + kualiDocumentEventClass.getName() + "' does not implement the class '" + SaveEvent.class.getName() + "'");
        }
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocumentAndSaveAdHocRoutingRecipients(document, this.generateKualiDocumentEvent(document, kualiDocumentEventClass));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().save(savedDocument.getDocumentHeader().getWorkflowDocument(), null);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), savedDocument.getDocumentHeader().getWorkflowDocument());
        return savedDocument;
    }

    private KualiDocumentEvent generateKualiDocumentEvent(Document document, Class<? extends KualiDocumentEvent> eventClass) throws ConfigurationException {
        String potentialErrorMessage = "Found error trying to generate Kuali Document Event using event class '" + eventClass.getName() + "' for document " + document.getDocumentNumber();
        try {
            Constructor<?> usableConstructor = null;
            ArrayList<Document> paramList = new ArrayList<Document>();
            for (Constructor<?> currentConstructor : eventClass.getConstructors()) {
                for (Class<?> parameterClass : currentConstructor.getParameterTypes()) {
                    if (Document.class.isAssignableFrom(parameterClass)) {
                        usableConstructor = currentConstructor;
                        paramList.add(document);
                        continue;
                    }
                    paramList.add(null);
                }
                if (ObjectUtils.isNotNull(usableConstructor)) break;
            }
            if (usableConstructor == null) {
                throw new RuntimeException("Cannot find a constructor for class '" + eventClass.getName() + "' that takes in a document parameter");
            }
            return (KualiDocumentEvent)usableConstructor.newInstance(paramList.toArray());
        }
        catch (SecurityException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
    }

    @Override
    public Document routeDocument(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        this.checkForNulls(document);
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocument(document, new RouteDocumentEvent(document));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().route(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation, adHocRecipients);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    @Override
    public Document approveDocument(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        this.checkForNulls(document);
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocument(document, new ApproveDocumentEvent(document));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().approve(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation, adHocRecipients);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    @Override
    public Document superUserApproveDocument(Document document, String annotation) throws WorkflowException {
        this.getDocumentDao().save(document);
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().superUserApprove(document.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    @Override
    public Document superUserCancelDocument(Document document, String annotation) throws WorkflowException {
        this.getDocumentDao().save(document);
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().superUserCancel(document.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    @Override
    public Document superUserDisapproveDocument(Document document, String annotation) throws WorkflowException {
        this.getDocumentDao().save(document);
        return this.superUserDisapproveDocumentWithoutSaving(document, annotation);
    }

    @Override
    public Document superUserDisapproveDocumentWithoutSaving(Document document, String annotation) throws WorkflowException {
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().superUserDisapprove(document.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    @Override
    public Document disapproveDocument(Document document, String annotation) throws Exception {
        this.checkForNulls(document);
        Note note = this.createNoteFromDocument(document, annotation);
        if (document.getNoteType().equals((Object)NoteType.BUSINESS_OBJECT)) {
            note.setNoteTypeCode(NoteType.DOCUMENT_HEADER.getCode());
            note.setRemoteObjectIdentifier(document.getDocumentHeader().getObjectId());
        }
        document.addNote(note);
        this.getNoteService().save(note);
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().disapprove(document.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    @Override
    public Document cancelDocument(Document document, String annotation) throws WorkflowException {
        this.checkForNulls(document);
        if (document instanceof MaintenanceDocument) {
            MaintenanceDocument maintDoc = (MaintenanceDocument)document;
            if (maintDoc.getOldMaintainableObject() != null && maintDoc.getOldMaintainableObject().getDataObject() instanceof BusinessObject) {
                ((BusinessObject)maintDoc.getOldMaintainableObject().getDataObject()).refresh();
            }
            if (maintDoc.getNewMaintainableObject().getDataObject() instanceof BusinessObject) {
                ((BusinessObject)maintDoc.getNewMaintainableObject().getDataObject()).refresh();
            }
        }
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().cancel(document.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    @Override
    public Document recallDocument(Document document, String annotation, boolean cancel) throws WorkflowException {
        this.checkForNulls(document);
        Note note = this.createNoteFromDocument(document, annotation);
        document.addNote(note);
        this.getNoteService().save(note);
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().recall(document.getDocumentHeader().getWorkflowDocument(), annotation, cancel);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    @Override
    public Document acknowledgeDocument(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.checkForNulls(document);
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().acknowledge(document.getDocumentHeader().getWorkflowDocument(), annotation, adHocRecipients);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    @Override
    public Document blanketApproveDocument(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        this.checkForNulls(document);
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocument(document, new BlanketApproveDocumentEvent(document));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().blanketApprove(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation, adHocRecipients);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    @Override
    public Document clearDocumentFyi(Document document, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.checkForNulls(document);
        document.populateDocumentForRouting();
        this.getWorkflowDocumentService().clearFyi(document.getDocumentHeader().getWorkflowDocument(), adHocRecipients);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    @Override
    public Document completeDocument(Document document, String annotation, List adHocRecipients) throws WorkflowException {
        this.checkForNulls(document);
        document.prepareForSave();
        this.validateAndPersistDocument(document, new CompleteDocumentEvent(document));
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().complete(document.getDocumentHeader().getWorkflowDocument(), annotation, adHocRecipients);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    protected void checkForNulls(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentNumber() == null) {
            throw new IllegalStateException("invalid (null) documentHeaderId");
        }
    }

    private Document validateAndPersistDocumentAndSaveAdHocRoutingRecipients(Document document, KualiDocumentEvent event) {
        ArrayList<AdHocRouteRecipient> adHocRoutingRecipients = new ArrayList<AdHocRouteRecipient>();
        adHocRoutingRecipients.addAll(document.getAdHocRoutePersons());
        adHocRoutingRecipients.addAll(document.getAdHocRouteWorkgroups());
        for (AdHocRouteRecipient recipient : adHocRoutingRecipients) {
            recipient.setdocumentNumber(document.getDocumentNumber());
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("documentNumber", document.getDocumentNumber());
        this.getBusinessObjectService().deleteMatching(AdHocRouteRecipient.class, criteria);
        this.getBusinessObjectService().save(adHocRoutingRecipients);
        return this.validateAndPersistDocument(document, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean documentExists(String documentHeaderId) {
        if (StringUtils.isBlank((CharSequence)documentHeaderId)) {
            throw new IllegalArgumentException("invalid (blank) documentHeaderId");
        }
        boolean internalUserSession = false;
        try {
            if (GlobalVariables.getUserSession() == null) {
                internalUserSession = true;
                GlobalVariables.setUserSession(new UserSession("kr"));
                GlobalVariables.clear();
            }
            if (this.getWorkflowDocumentService().workflowDocumentExists(documentHeaderId)) {
                boolean bl = this.getDocumentHeaderService().getDocumentHeaderById(documentHeaderId) != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (internalUserSession) {
                GlobalVariables.clear();
                GlobalVariables.setUserSession(null);
            }
        }
    }

    @Override
    public Document getNewDocument(Class<? extends Document> documentClass) throws WorkflowException {
        if (documentClass == null) {
            throw new IllegalArgumentException("invalid (null) documentClass");
        }
        if (!Document.class.isAssignableFrom(documentClass)) {
            throw new IllegalArgumentException("invalid (non-Document) documentClass");
        }
        String documentTypeName = this.getDataDictionaryService().getDocumentTypeNameByClass(documentClass);
        if (StringUtils.isBlank((CharSequence)documentTypeName)) {
            throw new UnknownDocumentTypeException("unable to get documentTypeName for unknown documentClass '" + documentClass.getName() + "'");
        }
        return this.getNewDocument(documentTypeName);
    }

    @Override
    public Document getNewDocument(String documentTypeName, String initiatorPrincipalNm) throws WorkflowException {
        String watchName = "DocumentServiceImpl.getNewDocument";
        StopWatch watch = new StopWatch();
        watch.start();
        if (LOG.isDebugEnabled()) {
            LOG.debug(watchName + ": started");
        }
        if (StringUtils.isBlank((CharSequence)documentTypeName)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        if (GlobalVariables.getUserSession() == null) {
            throw new IllegalStateException("GlobalVariables must be populated with a valid UserSession before a new document can be created");
        }
        Class<? extends Document> documentClass = this.getDocumentClassByTypeName(documentTypeName);
        Person initiator = null;
        if (StringUtils.isBlank((CharSequence)initiatorPrincipalNm)) {
            initiator = GlobalVariables.getUserSession().getPerson();
        } else {
            initiator = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(initiatorPrincipalNm);
            if (ObjectUtils.isNull(initiator)) {
                initiator = GlobalVariables.getUserSession().getPerson();
            }
        }
        DocumentAuthorizer documentAuthorizer = this.getDocumentDictionaryService().getDocumentAuthorizer(documentTypeName);
        DocumentPresentationController documentPresentationController = this.getDocumentDictionaryService().getDocumentPresentationController(documentTypeName);
        LOG.debug("calling canInitiate from getNewDocument()");
        if (!documentPresentationController.canInitiate(documentTypeName) || !documentAuthorizer.canInitiate(documentTypeName, initiator)) {
            throw new DocumentAuthorizationException(initiator.getPrincipalName(), "initiate", documentTypeName);
        }
        WorkflowDocument workflowDocument = this.getWorkflowDocumentService().createWorkflowDocument(documentTypeName, initiator);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), workflowDocument);
        DocumentHeader documentHeader = null;
        try {
            Class<? extends DocumentHeader> documentHeaderClass = this.getDocumentHeaderService().getDocumentHeaderBaseClass();
            documentHeader = documentHeaderClass.newInstance();
            documentHeader.setWorkflowDocument(workflowDocument);
            documentHeader.setDocumentNumber(workflowDocument.getDocumentId());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error instantiating DocumentHeader", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instantiating DocumentHeader", e);
        }
        Document document = null;
        try {
            if (MaintenanceDocumentBase.class.isAssignableFrom(documentClass)) {
                Class[] defaultConstructor = new Class[]{String.class};
                Constructor<? extends Document> cons = documentClass.getConstructor(defaultConstructor);
                if (ObjectUtils.isNull(cons)) {
                    throw new ConfigurationException("Could not find constructor with document type name parameter needed for Maintenance Document Base class");
                }
                document = cons.newInstance(documentTypeName);
            } else {
                document = documentClass.newInstance();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error instantiating Document", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instantiating Document", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error instantiating Maintenance Document", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error instantiating Maintenance Document: No constructor with String parameter found", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error instantiating Maintenance Document", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error instantiating Maintenance Document", e);
        }
        document.setDocumentHeader(documentHeader);
        document.setDocumentNumber(documentHeader.getDocumentNumber());
        watch.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug(watchName + ": " + watch.toString());
        }
        return document;
    }

    @Override
    public Document getNewDocument(String documentTypeName) throws WorkflowException {
        return this.getNewDocument(documentTypeName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getByDocumentHeaderId(String documentHeaderId) throws WorkflowException {
        if (documentHeaderId == null) {
            throw new IllegalArgumentException("invalid (null) documentHeaderId");
        }
        boolean internalUserSession = false;
        try {
            if (GlobalVariables.getUserSession() == null) {
                internalUserSession = true;
                GlobalVariables.setUserSession(new UserSession("kr"));
                GlobalVariables.clear();
            }
            WorkflowDocument workflowDocument = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrieving doc id: " + documentHeaderId + " from workflow service.");
            }
            workflowDocument = this.getWorkflowDocumentService().loadWorkflowDocument(documentHeaderId, GlobalVariables.getUserSession().getPerson());
            UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), workflowDocument);
            Class<? extends Document> documentClass = this.getDocumentClassByTypeName(workflowDocument.getDocumentTypeName());
            Document document = this.getDocumentDao().findByDocumentHeaderId(documentClass, documentHeaderId);
            Document document2 = this.postProcessDocument(documentHeaderId, workflowDocument, document);
            return document2;
        }
        finally {
            if (internalUserSession) {
                GlobalVariables.clear();
                GlobalVariables.setUserSession(null);
            }
        }
    }

    @Override
    public Document getByDocumentHeaderIdSessionless(String documentHeaderId) throws WorkflowException {
        if (documentHeaderId == null) {
            throw new IllegalArgumentException("invalid (null) documentHeaderId");
        }
        WorkflowDocument workflowDocument = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving doc id: " + documentHeaderId + " from workflow service.");
        }
        Person person = this.getPersonService().getPersonByPrincipalName("kr");
        workflowDocument = this.workflowDocumentService.loadWorkflowDocument(documentHeaderId, person);
        Class<? extends Document> documentClass = this.getDocumentClassByTypeName(workflowDocument.getDocumentTypeName());
        Document document = this.getDocumentDao().findByDocumentHeaderId(documentClass, documentHeaderId);
        return this.postProcessDocument(documentHeaderId, workflowDocument, document);
    }

    private Class<? extends Document> getDocumentClassByTypeName(String documentTypeName) {
        if (StringUtils.isBlank((CharSequence)documentTypeName)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        Class<? extends Document> clazz = this.getDataDictionaryService().getDocumentClassByTypeName(documentTypeName);
        if (clazz == null) {
            throw new UnknownDocumentTypeException("unable to get class for unknown documentTypeName '" + documentTypeName + "'");
        }
        return clazz;
    }

    protected void loadNotes(Document document) {
        if (this.isNoteTargetReady(document)) {
            ArrayList<Note> notes = new ArrayList<Note>();
            if (StringUtils.isNotBlank((CharSequence)document.getNoteTarget().getObjectId())) {
                notes.addAll(this.getNoteService().getByRemoteObjectId(document.getNoteTarget().getObjectId()));
            }
            if (document.getNoteType().equals((Object)NoteType.BUSINESS_OBJECT) && document.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
                notes.addAll(this.getNoteService().getByRemoteObjectId(document.getDocumentHeader().getObjectId()));
            }
            for (Note note : notes) {
                note.refreshReferenceObject("attachment");
            }
            document.setNotes(notes);
        }
    }

    protected Document postProcessDocument(String documentHeaderId, WorkflowDocument workflowDocument, Document document) {
        if (document != null) {
            document.getDocumentHeader().setWorkflowDocument(workflowDocument);
            document.processAfterRetrieve();
            this.loadNotes(document);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Document> getDocumentsByListOfDocumentHeaderIds(Class<? extends Document> documentClass, List<String> documentHeaderIds) throws WorkflowException {
        if (documentHeaderIds == null) {
            throw new IllegalArgumentException("invalid (null) documentHeaderId list");
        }
        int index = 0;
        for (String documentHeaderId : documentHeaderIds) {
            if (StringUtils.isBlank((CharSequence)documentHeaderId)) {
                throw new IllegalArgumentException("invalid (blank) documentHeaderId at list index " + index);
            }
            ++index;
        }
        boolean internalUserSession = false;
        try {
            if (GlobalVariables.getUserSession() == null) {
                internalUserSession = true;
                GlobalVariables.setUserSession(new UserSession("kr"));
                GlobalVariables.clear();
            }
            List<? extends Document> rawDocuments = this.getDocumentDao().findByDocumentHeaderIds(documentClass, documentHeaderIds);
            ArrayList<Document> documents = new ArrayList<Document>();
            for (Document document : rawDocuments) {
                WorkflowDocument workflowDocument = this.getWorkflowDocumentService().loadWorkflowDocument(document.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
                Document document2 = this.postProcessDocument(document.getDocumentNumber(), workflowDocument, document);
                documents.add(document2);
            }
            ArrayList<Document> arrayList = documents;
            return arrayList;
        }
        finally {
            if (internalUserSession) {
                GlobalVariables.clear();
                GlobalVariables.setUserSession(null);
            }
        }
    }

    @Override
    public Document validateAndPersistDocument(Document document, KualiDocumentEvent event) throws ValidationException {
        if (document == null) {
            LOG.error("document passed to validateAndPersist was null");
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("validating and preparing to persist document " + document.getDocumentNumber());
        }
        document.validateBusinessRules(event);
        document.prepareForSave(event);
        Document savedDocument = null;
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("storing document " + document.getDocumentNumber());
            }
            savedDocument = this.getDocumentDao().save(document);
        }
        catch (OptimisticLockingFailureException e) {
            LOG.error("exception encountered on store of document " + e.getMessage());
            throw e;
        }
        boolean notesSaved = this.saveDocumentNotes(document);
        if (!notesSaved && LOG.isInfoEnabled()) {
            LOG.info("Notes not saved during validateAndPersistDocument, likely means that note save needs to be deferred because note target is not ready.");
        }
        savedDocument.postProcessSave(event);
        return savedDocument;
    }

    @Override
    public void prepareWorkflowDocument(Document document) throws WorkflowException {
        document.populateDocumentForRouting();
        this.populateDocumentTitle(document);
        this.populateApplicationDocumentId(document);
    }

    private void populateDocumentTitle(Document document) throws WorkflowException {
        String documentTitle = document.getDocumentTitle();
        if (StringUtils.isNotBlank((CharSequence)documentTitle)) {
            document.getDocumentHeader().getWorkflowDocument().setTitle(documentTitle);
        }
    }

    private void populateApplicationDocumentId(Document document) {
        String organizationDocumentNumber = document.getDocumentHeader().getOrganizationDocumentNumber();
        if (StringUtils.isNotBlank((CharSequence)organizationDocumentNumber)) {
            document.getDocumentHeader().getWorkflowDocument().setApplicationDocumentId(organizationDocumentNumber);
        }
    }

    @Override
    public Document updateDocument(Document document) {
        this.checkForNulls(document);
        return this.getDocumentDao().save(document);
    }

    @Override
    public Note createNoteFromDocument(Document document, String text) {
        Note note = new Note();
        note.setNotePostedTimestamp(this.getDateTimeService().getCurrentTimestamp());
        note.setVersionNumber(1L);
        note.setNoteText(text);
        note.setNoteTypeCode(document.getNoteType().getCode());
        PersistableBusinessObject bo = document.getNoteTarget();
        Person kualiUser = GlobalVariables.getUserSession().getPerson();
        if (kualiUser == null) {
            throw new IllegalStateException("Current UserSession has a null Person.");
        }
        return bo == null ? null : this.getNoteService().createNote(note, bo, kualiUser.getPrincipalId());
    }

    @Override
    public boolean saveDocumentNotes(Document document) {
        if (this.isNoteTargetReady(document)) {
            List<Note> notes = document.getNotes();
            for (Note note : document.getNotes()) {
                this.linkNoteRemoteObjectId(note, document.getNoteTarget());
            }
            this.getNoteService().saveNoteList(notes);
            return true;
        }
        return false;
    }

    @Override
    public void sendNoteRouteNotification(Document document, Note note, Person sender) throws WorkflowException {
        AdHocRouteRecipient routeRecipient = note.getAdHocRouteRecipient();
        Person requestedUser = this.getPersonService().getPersonByPrincipalName(routeRecipient.getId());
        String senderName = sender.getFirstName() + " " + sender.getLastName();
        String requestedName = requestedUser.getFirstName() + " " + requestedUser.getLastName();
        String notificationText = this.kualiConfigurationService.getPropertyValueAsString("message.note.notification.annotation");
        if (StringUtils.isBlank((CharSequence)notificationText)) {
            throw new RuntimeException("No annotation message found for note notification. Message needs added to application resources with key:message.note.notification.annotation");
        }
        notificationText = MessageFormat.format(notificationText, senderName, requestedName, note.getNoteText());
        ArrayList<AdHocRouteRecipient> routeRecipients = new ArrayList<AdHocRouteRecipient>();
        routeRecipients.add(routeRecipient);
        this.workflowDocumentService.sendWorkflowNotification(document.getDocumentHeader().getWorkflowDocument(), notificationText, routeRecipients, "READ NOTES");
        note.setAdHocRouteRecipient(new AdHocRoutePerson());
    }

    protected boolean isNoteTargetReady(Document document) {
        if (document.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            return true;
        }
        PersistableBusinessObject noteTarget = document.getNoteTarget();
        return noteTarget != null && !StringUtils.isBlank((CharSequence)noteTarget.getObjectId());
    }

    private void linkNoteRemoteObjectId(Note note, PersistableBusinessObject noteTarget) {
        String objectId = noteTarget.getObjectId();
        if (StringUtils.isBlank((CharSequence)objectId)) {
            throw new IllegalStateException("Attempted to link a Note with a PersistableBusinessObject with no object id");
        }
        note.setRemoteObjectIdentifier(noteTarget.getObjectId());
    }

    @Override
    public void sendAdHocRequests(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().sendWorkflowNotification(document.getDocumentHeader().getWorkflowDocument(), annotation, adHocRecipients);
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
    }

    private void removeAdHocPersonsAndWorkgroups(Document document) {
        ArrayList<AdHocRoutePerson> adHocRoutePersons = new ArrayList<AdHocRoutePerson>();
        ArrayList<AdHocRouteWorkgroup> adHocRouteWorkgroups = new ArrayList<AdHocRouteWorkgroup>();
        this.getBusinessObjectService().delete(document.getAdHocRoutePersons());
        this.getBusinessObjectService().delete(document.getAdHocRouteWorkgroups());
        document.setAdHocRoutePersons(adHocRoutePersons);
        document.setAdHocRouteWorkgroups(adHocRouteWorkgroups);
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = CoreApiServiceLocator.getDateTimeService();
        }
        return this.dateTimeService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    protected NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        if (this.workflowDocumentService == null) {
            this.workflowDocumentService = KRADServiceLocatorWeb.getWorkflowDocumentService();
        }
        return this.workflowDocumentService;
    }

    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    protected DocumentDao getDocumentDao() {
        if (this.documentDao == null) {
            this.documentDao = KRADServiceLocatorInternal.getDocumentDao();
        }
        return this.documentDao;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDocumentHeaderService(DocumentHeaderService documentHeaderService) {
        this.documentHeaderService = documentHeaderService;
    }

    protected DocumentHeaderService getDocumentHeaderService() {
        if (this.documentHeaderService == null) {
            this.documentHeaderService = KRADServiceLocatorWeb.getDocumentHeaderService();
        }
        return this.documentHeaderService;
    }

    protected DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

