/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.dao.BusinessObjectDao;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KeyValuesService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class KeyValuesServiceImpl
implements KeyValuesService {
    private static final Logger LOG = LogManager.getLogger(KeyValuesServiceImpl.class);
    private BusinessObjectDao businessObjectDao;
    private PersistenceStructureService persistenceStructureService;

    @Override
    public <T extends BusinessObject> Collection<T> findAll(Class<T> clazz) {
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(clazz);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(clazz)) {
            return responsibleModuleService.getExternalizableBusinessObjectsList(clazz, Collections.emptyMap());
        }
        if (this.containsActiveIndicator(clazz)) {
            return this.businessObjectDao.findAllActive(clazz);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Active indicator not found for class " + clazz.getName());
        }
        return this.businessObjectDao.findAll(clazz);
    }

    public static <E> Collection<E> createUnmodifiableUpcastList(Collection<? extends E> list, Class<E> type) {
        return new ArrayList<E>(list);
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending) {
        if (this.containsActiveIndicator(clazz)) {
            return this.businessObjectDao.findAllActiveOrderBy(clazz, sortField, sortAscending);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Active indicator not found for class " + clazz.getName());
        }
        return this.businessObjectDao.findAllOrderBy(clazz, sortField, sortAscending);
    }

    @Override
    public <T extends BusinessObject> Collection<T> findMatching(Class<T> clazz, Map<String, Object> fieldValues) {
        if (this.containsActiveIndicator(clazz)) {
            return this.businessObjectDao.findMatchingActive(clazz, fieldValues);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Active indicator not found for class " + clazz.getName());
        }
        return this.businessObjectDao.findMatching(clazz, fieldValues);
    }

    public BusinessObjectDao getBusinessObjectDao() {
        return this.businessObjectDao;
    }

    public void setBusinessObjectDao(BusinessObjectDao businessObjectDao) {
        this.businessObjectDao = businessObjectDao;
    }

    public PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    private <T extends BusinessObject> boolean containsActiveIndicator(Class<T> clazz) {
        boolean containsActive = false;
        if (this.persistenceStructureService.listFieldNames(clazz).contains("active")) {
            containsActive = true;
        }
        return containsActive;
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAllInactive(Class<T> clazz) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Active indicator not found for class " + clazz.getName());
        }
        return this.businessObjectDao.findAllInactive(clazz);
    }
}

