/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.container;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.DataBinding;
import org.kuali.kfs.krad.uif.container.ContainerBase;
import org.kuali.kfs.krad.uif.field.Field;
import org.kuali.kfs.krad.uif.field.FieldGroup;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.Disclosure;

public class Group
extends ContainerBase {
    private static final long serialVersionUID = 7953641325356535509L;
    private String fieldBindByNamePrefix;
    private String fieldBindingObjectPath;
    private Disclosure disclosure;
    private List<? extends Component> items = new ArrayList<Component>();

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        for (Component component : this.getItems()) {
            if (component instanceof DataBinding) {
                DataBinding dataBinding = (DataBinding)((Object)component);
                if (StringUtils.isNotBlank((CharSequence)this.getFieldBindByNamePrefix())) {
                    String bindByNamePrefixToSet = this.getFieldBindByNamePrefix();
                    if (StringUtils.isNotBlank((CharSequence)dataBinding.getBindingInfo().getBindByNamePrefix())) {
                        bindByNamePrefixToSet = bindByNamePrefixToSet + "." + dataBinding.getBindingInfo().getBindByNamePrefix();
                    }
                    dataBinding.getBindingInfo().setBindByNamePrefix(bindByNamePrefixToSet);
                }
                if (!StringUtils.isNotBlank((CharSequence)this.fieldBindingObjectPath) || !StringUtils.isBlank((CharSequence)dataBinding.getBindingInfo().getBindingObjectPath())) continue;
                dataBinding.getBindingInfo().setBindingObjectPath(this.fieldBindingObjectPath);
                continue;
            }
            if (component instanceof FieldGroup) {
                FieldGroup fieldGroup = (FieldGroup)component;
                if (fieldGroup.getGroup() == null) continue;
                if (StringUtils.isBlank((CharSequence)fieldGroup.getGroup().getFieldBindByNamePrefix())) {
                    fieldGroup.getGroup().setFieldBindByNamePrefix(this.fieldBindByNamePrefix);
                }
                if (!StringUtils.isBlank((CharSequence)fieldGroup.getGroup().getFieldBindingObjectPath())) continue;
                fieldGroup.getGroup().setFieldBindingObjectPath(this.fieldBindingObjectPath);
                continue;
            }
            if (!(component instanceof Group)) continue;
            Group subGroup = (Group)component;
            if (StringUtils.isNotBlank((CharSequence)this.getFieldBindByNamePrefix())) {
                if (StringUtils.isNotBlank((CharSequence)subGroup.getFieldBindByNamePrefix())) {
                    subGroup.setFieldBindByNamePrefix(this.getFieldBindByNamePrefix() + "." + subGroup.getFieldBindByNamePrefix());
                } else {
                    subGroup.setFieldBindByNamePrefix(this.getFieldBindByNamePrefix());
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)this.getFieldBindingObjectPath())) continue;
            if (StringUtils.isNotBlank((CharSequence)subGroup.getFieldBindingObjectPath())) {
                subGroup.setFieldBindingObjectPath(this.getFieldBindingObjectPath() + "." + subGroup.getFieldBindingObjectPath());
                continue;
            }
            subGroup.setFieldBindingObjectPath(this.getFieldBindingObjectPath());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.disclosure);
        return components;
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> supportedComponents = new HashSet<Class<? extends Component>>();
        supportedComponents.add(Field.class);
        supportedComponents.add(Group.class);
        return supportedComponents;
    }

    @Override
    public final String getComponentTypeName() {
        return "group";
    }

    public String getFieldBindByNamePrefix() {
        return this.fieldBindByNamePrefix;
    }

    public void setFieldBindByNamePrefix(String fieldBindByNamePrefix) {
        this.fieldBindByNamePrefix = fieldBindByNamePrefix;
    }

    public String getFieldBindingObjectPath() {
        return this.fieldBindingObjectPath;
    }

    public void setFieldBindingObjectPath(String fieldBindingObjectPath) {
        this.fieldBindingObjectPath = fieldBindingObjectPath;
    }

    public Disclosure getDisclosure() {
        return this.disclosure;
    }

    public void setDisclosure(Disclosure disclosure) {
        this.disclosure = disclosure;
    }

    @Override
    public List<? extends Component> getItems() {
        return this.items;
    }

    @Override
    public void setItems(List<? extends Component> items) {
        this.items = items;
    }
}

