/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.text.StringEscapeUtils;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.springframework.util.AutoPopulatingList;

public class MessageMap
implements Serializable {
    private static final long serialVersionUID = -2328635367656516150L;
    private List<String> errorPath = new ArrayList<String>();
    private Map<String, AutoPopulatingList<ErrorMessage>> errorMessages = new LinkedHashMap<String, AutoPopulatingList<ErrorMessage>>();
    private Map<String, AutoPopulatingList<ErrorMessage>> warningMessages = new LinkedHashMap<String, AutoPopulatingList<ErrorMessage>>();
    private Map<String, AutoPopulatingList<ErrorMessage>> infoMessages = new LinkedHashMap<String, AutoPopulatingList<ErrorMessage>>();

    public MessageMap() {
    }

    public MessageMap(MessageMap messageMap) {
        this.errorPath = messageMap.errorPath;
        this.errorMessages = messageMap.errorMessages;
        this.warningMessages = messageMap.warningMessages;
        this.infoMessages = messageMap.infoMessages;
    }

    public void merge(MessageMap messageMap) {
        if (messageMap != null) {
            if (messageMap.hasErrors()) {
                this.merge(messageMap.getErrorMessages(), this.errorMessages);
            }
            if (messageMap.hasInfo()) {
                this.merge(messageMap.getInfoMessages(), this.infoMessages);
            }
            if (messageMap.hasWarnings()) {
                this.merge(messageMap.getWarningMessages(), this.warningMessages);
            }
        }
    }

    protected void merge(Map<String, AutoPopulatingList<ErrorMessage>> messagesFrom, Map<String, AutoPopulatingList<ErrorMessage>> messagesTo) {
        for (String key : messagesFrom.keySet()) {
            if (messagesTo.containsKey(key)) {
                AutoPopulatingList<ErrorMessage> tal = messagesFrom.get(key);
                AutoPopulatingList<ErrorMessage> parentList = messagesTo.get(key);
                for (Object o : tal) {
                    if (parentList.contains(o)) continue;
                    parentList.add((Object)((ErrorMessage)o));
                }
                continue;
            }
            messagesTo.put(key, messagesFrom.get(key));
        }
    }

    public AutoPopulatingList<ErrorMessage> putError(String propertyName, String errorKey, String ... errorParameters) {
        return this.putMessageInMap(this.errorMessages, propertyName, errorKey, true, true, errorParameters);
    }

    public AutoPopulatingList<ErrorMessage> putWarning(String propertyName, String messageKey, String ... messageParameters) {
        return this.putMessageInMap(this.warningMessages, propertyName, messageKey, true, true, messageParameters);
    }

    public AutoPopulatingList<ErrorMessage> putInfo(String propertyName, String messageKey, String ... messageParameters) {
        return this.putMessageInMap(this.infoMessages, propertyName, messageKey, true, true, messageParameters);
    }

    public AutoPopulatingList<ErrorMessage> putErrorWithoutFullErrorPath(String propertyName, String errorKey, String ... errorParameters) {
        return this.putMessageInMap(this.errorMessages, propertyName, errorKey, false, true, errorParameters);
    }

    public AutoPopulatingList<ErrorMessage> putWarningWithoutFullErrorPath(String propertyName, String messageKey, String ... messageParameters) {
        return this.putMessageInMap(this.warningMessages, propertyName, messageKey, false, true, messageParameters);
    }

    public AutoPopulatingList<ErrorMessage> putInfoWithoutFullErrorPath(String propertyName, String messageKey, String ... messageParameters) {
        return this.putMessageInMap(this.infoMessages, propertyName, messageKey, false, true, messageParameters);
    }

    public AutoPopulatingList<ErrorMessage> putErrorForSectionId(String sectionId, String errorKey, String ... errorParameters) {
        return this.putErrorWithoutFullErrorPath(sectionId, errorKey, errorParameters);
    }

    public AutoPopulatingList<ErrorMessage> putWarningForSectionId(String sectionId, String messageKey, String ... messageParameters) {
        return this.putWarningWithoutFullErrorPath(sectionId, messageKey, messageParameters);
    }

    public AutoPopulatingList<ErrorMessage> putInfoForSectionId(String sectionId, String messageKey, String ... messageParameters) {
        return this.putInfoWithoutFullErrorPath(sectionId, messageKey, messageParameters);
    }

    private AutoPopulatingList<ErrorMessage> putMessageInMap(Map<String, AutoPopulatingList<ErrorMessage>> messagesMap, String propertyName, String messageKey, boolean prependFullErrorPath, boolean escapeHtmlMessageParameters, String ... messageParameters) {
        ErrorMessage errorMessage;
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        if (StringUtils.isBlank((CharSequence)messageKey)) {
            throw new IllegalArgumentException("invalid (blank) errorKey");
        }
        AutoPopulatingList errorList = null;
        String propertyKey = this.getKeyPath(propertyName, prependFullErrorPath);
        errorList = messagesMap.containsKey(propertyKey) ? messagesMap.get(propertyKey) : new AutoPopulatingList(ErrorMessage.class);
        if (escapeHtmlMessageParameters && messageParameters != null) {
            String[] filteredMessageParameters = new String[messageParameters.length];
            for (int i = 0; i < messageParameters.length; ++i) {
                filteredMessageParameters[i] = StringEscapeUtils.escapeHtml4((String)messageParameters[i]);
            }
            messageParameters = filteredMessageParameters;
        }
        if (!errorList.contains((Object)(errorMessage = new ErrorMessage(messageKey, messageParameters)))) {
            errorList.add((Object)errorMessage);
        }
        return messagesMap.put(propertyKey, (AutoPopulatingList<ErrorMessage>)errorList);
    }

    public boolean replaceError(String propertyName, String targetKey, String replaceKey, String ... replaceParameters) {
        return this.replaceError(propertyName, targetKey, true, replaceKey, replaceParameters);
    }

    public boolean replaceErrorWithoutFullErrorPath(String propertyName, String targetKey, String replaceKey, String ... replaceParameters) {
        return this.replaceError(propertyName, targetKey, false, replaceKey, replaceParameters);
    }

    private boolean replaceError(String propertyName, String targetKey, boolean withFullErrorPath, String replaceKey, String ... replaceParameters) {
        boolean replaced = false;
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        if (StringUtils.isBlank((CharSequence)targetKey)) {
            throw new IllegalArgumentException("invalid (blank) targetKey");
        }
        if (StringUtils.isBlank((CharSequence)replaceKey)) {
            throw new IllegalArgumentException("invalid (blank) replaceKey");
        }
        AutoPopulatingList<ErrorMessage> errorList = null;
        String propertyKey = this.getKeyPath(propertyName, withFullErrorPath);
        if (this.errorMessages.containsKey(propertyKey)) {
            errorList = this.errorMessages.get(propertyKey);
            for (int i = 0; i < errorList.size(); ++i) {
                ErrorMessage em = (ErrorMessage)errorList.get(i);
                if (!em.getErrorKey().equals(targetKey)) continue;
                ErrorMessage rm = new ErrorMessage(replaceKey, replaceParameters);
                errorList.set(i, (Object)rm);
                replaced = true;
            }
        }
        return replaced;
    }

    public boolean fieldHasMessage(String fieldName, String errorKey) {
        boolean found = false;
        List fieldMessages = (List)this.errorMessages.get(fieldName);
        if (fieldMessages != null) {
            Iterator i = fieldMessages.iterator();
            while (!found && i.hasNext()) {
                ErrorMessage errorMessage = (ErrorMessage)i.next();
                found = errorMessage.getErrorKey().equals(errorKey);
            }
        }
        return found;
    }

    public int countFieldMessages(String fieldName) {
        int count = 0;
        List fieldMessages = (List)this.errorMessages.get(fieldName);
        if (fieldMessages != null) {
            count = fieldMessages.size();
        }
        return count;
    }

    public boolean containsMessageKey(String messageKey) {
        ErrorMessage foundMessage = null;
        if (!this.hasNoErrors()) {
            Iterator<Map.Entry<String, AutoPopulatingList<ErrorMessage>>> i = this.getAllPropertiesAndErrors().iterator();
            while (foundMessage == null && i.hasNext()) {
                Map.Entry<String, AutoPopulatingList<ErrorMessage>> e = i.next();
                AutoPopulatingList<ErrorMessage> entryErrorList = e.getValue();
                for (ErrorMessage em : entryErrorList) {
                    if (!messageKey.equals(em.getErrorKey())) continue;
                    foundMessage = em;
                }
            }
        }
        return foundMessage != null;
    }

    private int getMessageCount(Map<String, AutoPopulatingList<ErrorMessage>> messageMap) {
        int messageCount = 0;
        for (String errorKey : messageMap.keySet()) {
            List errors = (List)messageMap.get(errorKey);
            messageCount += errors.size();
        }
        return messageCount;
    }

    public int getErrorCount() {
        return this.getMessageCount(this.errorMessages);
    }

    public int getWarningCount() {
        return this.getMessageCount(this.warningMessages);
    }

    public int getInfoCount() {
        return this.getMessageCount(this.infoMessages);
    }

    public AutoPopulatingList<ErrorMessage> getMessages(String path) {
        return this.errorMessages.get(path);
    }

    public void addToErrorPath(String parentName) {
        this.errorPath.add(parentName);
    }

    public List<String> getErrorPath() {
        return this.errorPath;
    }

    public boolean removeFromErrorPath(String parentName) {
        return this.errorPath.remove(parentName);
    }

    public void clearErrorPath() {
        this.errorPath.clear();
    }

    public String getKeyPath(String propertyName, boolean prependFullErrorPath) {
        String keyPath = "";
        if ("GLOBAL_ERRORS".equals(propertyName)) {
            return "GLOBAL_ERRORS";
        }
        if (!this.errorPath.isEmpty() && prependFullErrorPath) {
            keyPath = StringUtils.join(this.errorPath.iterator(), (String)".");
            keyPath = keyPath + (keyPath != null && keyPath.endsWith(".") ? propertyName : "." + propertyName);
        } else {
            keyPath = propertyName;
        }
        return keyPath;
    }

    public List<String> getPropertiesWithErrors() {
        ArrayList<String> properties = new ArrayList<String>();
        Iterator<String> iter = this.errorMessages.keySet().iterator();
        while (iter.hasNext()) {
            properties.add(iter.next());
        }
        return properties;
    }

    public List<String> getPropertiesWithWarnings() {
        ArrayList<String> properties = new ArrayList<String>(this.warningMessages.keySet());
        return properties;
    }

    public List<String> getPropertiesWithInfo() {
        ArrayList<String> properties = new ArrayList<String>(this.infoMessages.keySet());
        return properties;
    }

    public void clearErrorMessages() {
        this.errorMessages.clear();
    }

    public boolean doesPropertyHaveError(String key) {
        return this.errorMessages.containsKey(key);
    }

    public boolean containsKeyMatchingPattern(String pattern) {
        ArrayList<String> simplePatterns = new ArrayList<String>();
        ArrayList<String> wildcardPatterns = new ArrayList<String>();
        String[] patterns = pattern.split(",");
        for (int i = 0; i < patterns.length; ++i) {
            String s = patterns[i];
            if (s.endsWith("*")) {
                wildcardPatterns.add(s.substring(0, s.length() - 1));
                continue;
            }
            simplePatterns.add(s);
        }
        for (String key : this.errorMessages.keySet()) {
            if (simplePatterns.contains(key)) {
                return true;
            }
            for (String wildcard : wildcardPatterns) {
                if (!key.startsWith(wildcard)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Map.Entry<String, AutoPopulatingList<ErrorMessage>>> getAllPropertiesAndErrors() {
        return this.errorMessages.entrySet();
    }

    public AutoPopulatingList<ErrorMessage> getErrorMessagesForProperty(String propertyName) {
        return this.errorMessages.get(propertyName);
    }

    public AutoPopulatingList<ErrorMessage> getWarningMessagesForProperty(String propertyName) {
        return this.warningMessages.get(propertyName);
    }

    public AutoPopulatingList<ErrorMessage> getInfoMessagesForProperty(String propertyName) {
        return this.infoMessages.get(propertyName);
    }

    public List<AutoPopulatingList<ErrorMessage>> getErrorMessagesForProperty(String propertyName, boolean allowWildcard) {
        ArrayList<AutoPopulatingList<ErrorMessage>> foundMessages = new ArrayList<AutoPopulatingList<ErrorMessage>>();
        if (allowWildcard) {
            boolean wildcard = false;
            if (propertyName.endsWith("*")) {
                wildcard = true;
                propertyName = propertyName.substring(0, propertyName.length() - 1);
            }
            for (String key : this.errorMessages.keySet()) {
                if (!wildcard && propertyName.equals(key)) {
                    foundMessages.add(this.errorMessages.get(key));
                    break;
                }
                if (!wildcard || !key.startsWith(propertyName)) continue;
                foundMessages.add(this.errorMessages.get(key));
            }
        } else {
            foundMessages.add(this.getErrorMessagesForProperty(propertyName));
        }
        return foundMessages;
    }

    public List<AutoPopulatingList<ErrorMessage>> getWarningMessagesForProperty(String propertyName, boolean allowWildcard) {
        ArrayList<AutoPopulatingList<ErrorMessage>> foundMessages = new ArrayList<AutoPopulatingList<ErrorMessage>>();
        if (allowWildcard) {
            boolean wildcard = false;
            if (propertyName.endsWith("*")) {
                wildcard = true;
                propertyName = propertyName.substring(0, propertyName.length() - 1);
            }
            for (String key : this.warningMessages.keySet()) {
                if (!wildcard && propertyName.equals(key)) {
                    foundMessages.add(this.warningMessages.get(key));
                    break;
                }
                if (!wildcard || !key.startsWith(propertyName)) continue;
                foundMessages.add(this.warningMessages.get(key));
            }
        } else {
            foundMessages.add(this.getWarningMessagesForProperty(propertyName));
        }
        return foundMessages;
    }

    public List<AutoPopulatingList<ErrorMessage>> getInfoMessagesForProperty(String propertyName, boolean allowWildcard) {
        ArrayList<AutoPopulatingList<ErrorMessage>> foundMessages = new ArrayList<AutoPopulatingList<ErrorMessage>>();
        if (allowWildcard) {
            boolean wildcard = false;
            if (propertyName.endsWith("*")) {
                wildcard = true;
                propertyName = propertyName.substring(0, propertyName.length() - 1);
            }
            for (String key : this.infoMessages.keySet()) {
                if (!wildcard && propertyName.equals(key)) {
                    foundMessages.add(this.infoMessages.get(key));
                    break;
                }
                if (!wildcard || !key.startsWith(propertyName)) continue;
                foundMessages.add(this.infoMessages.get(key));
            }
        } else {
            foundMessages.add(this.getInfoMessagesForProperty(propertyName));
        }
        return foundMessages;
    }

    public boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    public boolean hasNoErrors() {
        return this.errorMessages.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warningMessages.isEmpty();
    }

    public boolean hasNoWarnings() {
        return this.warningMessages.isEmpty();
    }

    public boolean hasInfo() {
        return !this.infoMessages.isEmpty();
    }

    public boolean hasNoInfo() {
        return this.infoMessages.isEmpty();
    }

    public boolean hasMessages() {
        return !this.errorMessages.isEmpty() || !this.warningMessages.isEmpty() || !this.infoMessages.isEmpty();
    }

    public boolean hasNoMessages() {
        return this.errorMessages.isEmpty() && this.warningMessages.isEmpty() && this.infoMessages.isEmpty();
    }

    public Set<String> getAllPropertiesWithErrors() {
        return this.errorMessages.keySet();
    }

    public Set<String> getAllPropertiesWithWarnings() {
        return this.warningMessages.keySet();
    }

    public Set<String> getAllPropertiesWithInfo() {
        return this.infoMessages.keySet();
    }

    public AutoPopulatingList<ErrorMessage> removeAllErrorMessagesForProperty(String property) {
        return this.errorMessages.remove(property);
    }

    public AutoPopulatingList<ErrorMessage> removeAllWarningMessagesForProperty(String property) {
        return this.warningMessages.remove(property);
    }

    public AutoPopulatingList<ErrorMessage> removeAllInfoMessagesForProperty(String property) {
        return this.infoMessages.remove(property);
    }

    public int getNumberOfPropertiesWithErrors() {
        return this.errorMessages.size();
    }

    public Map<String, AutoPopulatingList<ErrorMessage>> getErrorMessages() {
        return this.errorMessages;
    }

    public Map<String, AutoPopulatingList<ErrorMessage>> getWarningMessages() {
        return this.warningMessages;
    }

    public Map<String, AutoPopulatingList<ErrorMessage>> getInfoMessages() {
        return this.infoMessages;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

