/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.bind;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.service.ViewService;
import org.kuali.kfs.krad.uif.util.UifWebUtils;
import org.kuali.kfs.krad.uif.view.History;
import org.kuali.kfs.krad.uif.view.HistoryEntry;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.form.DocumentFormBase;
import org.kuali.kfs.krad.web.form.IncidentReportForm;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class UifHandlerExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger LOG = LogManager.getLogger(UifHandlerExceptionResolver.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LOG.error("The following error was caught by the UifHandlerExceptionResolver : ", (Throwable)ex);
        LOG.error(ex.getMessage(), (Throwable)ex);
        String incidentDocId = request.getParameter("document.documentNumber");
        String incidentViewId = "";
        UifFormBase form = GlobalVariables.getUifFormManager().getCurrentForm();
        if (form instanceof DocumentFormBase) {
            if (((DocumentFormBase)form).getDocument() != null) {
                incidentDocId = ((DocumentFormBase)form).getDocument().getDocumentNumber();
            }
            incidentViewId = form.getViewId();
        }
        GlobalVariables.getUifFormManager().removeForm(form);
        UserSession userSession = (UserSession)request.getSession().getAttribute("cf.UserSession");
        IncidentReportForm incidentReportForm = new IncidentReportForm();
        String postUrl = request.getRequestURL().toString();
        postUrl = postUrl.substring(0, postUrl.lastIndexOf("/")) + "/incidentReport";
        incidentReportForm.setFormPostUrl(postUrl);
        incidentReportForm.setException(ex);
        incidentReportForm.setIncidentDocId(incidentDocId);
        incidentReportForm.setIncidentViewId(incidentViewId);
        incidentReportForm.setController(handler.getClass().toString());
        incidentReportForm.setUserId(userSession.getPrincipalId());
        incidentReportForm.setUserName(userSession.getPrincipalName());
        incidentReportForm.setUserEmail(userSession.getPerson().getEmailAddress());
        incidentReportForm.setDevMode(!KRADUtils.isProductionEnvironment());
        incidentReportForm.setViewId("Uif-IncidentReportView");
        incidentReportForm.setView(this.getViewService().getViewById("Uif-IncidentReportView"));
        History history = new History();
        HistoryEntry entry = new HistoryEntry("", "", "Incident Report", "", "");
        history.setCurrent(entry);
        incidentReportForm.setFormHistory(history);
        incidentReportForm.setRenderFullView(true);
        ModelAndView modelAndView = UifWebUtils.getUIFModelAndView(incidentReportForm, "");
        try {
            UifWebUtils.postControllerHandle(request, response, handler, modelAndView);
        }
        catch (Exception e) {
            LOG.error("An error stopped the incident form from loading", (Throwable)e);
        }
        GlobalVariables.getUifFormManager().setCurrentForm(incidentReportForm);
        return modelAndView;
    }

    protected ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }
}

