/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.workflow.attribute;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.maintenance.KualiGlobalMaintainableImpl;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.SearchingAttribute;
import org.kuali.kfs.krad.datadictionary.SearchingTypeDefinition;
import org.kuali.kfs.krad.datadictionary.WorkflowAttributes;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowAttributePropertyResolutionService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.kew.api.document.DocumentWithContent;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeString;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.krad.bo.BusinessObject;

public class DataDictionarySearchableAttribute
implements SearchableAttribute {
    private static final long serialVersionUID = 173059488280366451L;
    private static final Logger LOG = LogManager.getLogger(DataDictionarySearchableAttribute.class);
    public static final String DATA_TYPE_BOOLEAN = "boolean";

    public String generateSearchContent(ExtensionDefinition extensionDefinition, String documentTypeName, WorkflowAttributeDefinition attributeDefinition) {
        return "";
    }

    public List<DocumentAttribute> extractDocumentAttributes(ExtensionDefinition extensionDefinition, DocumentWithContent documentWithContent) {
        Class<? extends BusinessObject> businessObjectClass;
        ArrayList<DocumentAttribute> attributes = new ArrayList<DocumentAttribute>();
        String docId = documentWithContent.getDocument().getDocumentId();
        DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
        Document doc = null;
        try {
            doc = docService.getByDocumentHeaderIdSessionless(docId);
        }
        catch (WorkflowException we) {
            LOG.error("Unable to retrieve document " + docId + " in getSearchStorageValues()", (Throwable)we);
        }
        String attributeValue = "";
        attributeValue = doc != null ? (doc.getDocumentHeader() != null ? doc.getDocumentHeader().getDocumentDescription() : "null document header") : "null document";
        DocumentAttributeString attribute = DocumentAttributeFactory.createStringAttribute((String)"documentDescription", (String)attributeValue);
        attributes.add((DocumentAttribute)attribute);
        attributeValue = "";
        attributeValue = doc != null ? (doc.getDocumentHeader() != null ? doc.getDocumentHeader().getOrganizationDocumentNumber() : "null document header") : "null document";
        attribute = DocumentAttributeFactory.createStringAttribute((String)"organizationDocumentNumber", (String)attributeValue);
        attributes.add((DocumentAttribute)attribute);
        if (doc != null && doc instanceof MaintenanceDocument && (businessObjectClass = this.getBusinessObjectClass(documentWithContent.getDocument().getDocumentTypeName())) != null) {
            if (GlobalBusinessObject.class.isAssignableFrom(businessObjectClass)) {
                GlobalBusinessObject globalBO = this.retrieveGlobalBusinessObject(docId, businessObjectClass);
                if (globalBO != null) {
                    attributes.addAll(this.findAllDocumentAttributesForGlobalBusinessObject(globalBO));
                }
            } else {
                attributes.addAll(this.parsePrimaryKeyValuesFromDocument(businessObjectClass, (MaintenanceDocument)doc));
            }
        }
        if (doc != null) {
            DocumentEntry docEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(documentWithContent.getDocument().getDocumentTypeName());
            if (docEntry != null) {
                WorkflowAttributes workflowAttributes = docEntry.getWorkflowAttributes();
                WorkflowAttributePropertyResolutionService waprs = KRADServiceLocatorInternal.getWorkflowAttributePropertyResolutionService();
                attributes.addAll(waprs.resolveSearchableAttributeValues(doc, workflowAttributes));
            } else {
                LOG.error("Unable to find DD document entry for document type: " + documentWithContent.getDocument().getDocumentTypeName());
            }
        }
        return attributes;
    }

    public List<RemotableAttributeField> getSearchFields(ExtensionDefinition extensionDefinition, String documentTypeName) {
        List<Row> searchRows = this.getSearchingRows(documentTypeName);
        return FieldUtils.convertRowsToAttributeFields(searchRows);
    }

    protected List<Row> getSearchingRows(String documentTypeName) {
        WorkflowAttributes workflowAttributes;
        ArrayList<Row> docSearchRows = new ArrayList<Row>();
        Class<DocumentHeader> boClass = DocumentHeader.class;
        Field descriptionField = FieldUtils.getPropertyField(boClass, "documentDescription", true);
        descriptionField.setFieldDataType("string");
        Field orgDocNumberField = FieldUtils.getPropertyField(boClass, "organizationDocumentNumber", true);
        orgDocNumberField.setFieldDataType("string");
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(descriptionField);
        docSearchRows.add(new Row(fieldList));
        fieldList = new ArrayList();
        fieldList.add(orgDocNumberField);
        docSearchRows.add(new Row(fieldList));
        DocumentEntry entry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(documentTypeName);
        if (entry == null) {
            return docSearchRows;
        }
        if (entry instanceof MaintenanceDocumentEntry) {
            Class<? extends BusinessObject> businessObjectClass = this.getBusinessObjectClass(documentTypeName);
            Class<? extends Maintainable> maintainableClass = this.getMaintainableClass(documentTypeName);
            KualiGlobalMaintainableImpl globalMaintainable = null;
            try {
                globalMaintainable = (KualiGlobalMaintainableImpl)maintainableClass.newInstance();
                businessObjectClass = globalMaintainable.getPrimaryEditedBusinessObjectClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (businessObjectClass != null) {
                docSearchRows.addAll(this.createFieldRowsForBusinessObject(businessObjectClass));
            }
        }
        if ((workflowAttributes = entry.getWorkflowAttributes()) != null) {
            docSearchRows.addAll(this.createFieldRowsForWorkflowAttributes(workflowAttributes));
        }
        return docSearchRows;
    }

    public List<RemotableAttributeError> validateDocumentAttributeCriteria(ExtensionDefinition extensionDefinition, DocumentSearchCriteria documentSearchCriteria) {
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        DictionaryValidationService validationService = KNSServiceLocator.getKNSDictionaryValidationService();
        Map documentAttributeValues = documentSearchCriteria.getDocumentAttributeValues();
        for (String key : documentAttributeValues.keySet()) {
            List values = (List)documentAttributeValues.get(key);
            if (!CollectionUtils.isNotEmpty((Collection)values)) continue;
            for (String value : values) {
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                validationService.validateAttributeFormat(documentSearchCriteria.getDocumentTypeName(), key, value, key);
            }
        }
        this.retrieveValidationErrorsFromGlobalVariables(validationErrors);
        return validationErrors;
    }

    protected void retrieveValidationErrorsFromGlobalVariables(List<RemotableAttributeError> validationErrors) {
        ConfigurationService configurationService = KRADServiceLocator.getKualiConfigurationService();
        if (GlobalVariables.getMessageMap().hasErrors()) {
            MessageMap deepCopy = (MessageMap)ObjectUtils.deepCopy(GlobalVariables.getMessageMap());
            for (String errorKey : deepCopy.getErrorMessages().keySet()) {
                List errorMessages = (List)deepCopy.getErrorMessages().get(errorKey);
                if (!CollectionUtils.isNotEmpty((Collection)errorMessages)) continue;
                ArrayList<String> errors = new ArrayList<String>();
                for (ErrorMessage errorMessage : errorMessages) {
                    String error = MessageFormat.format(configurationService.getPropertyValueAsString(errorMessage.getErrorKey()), errorMessage.getMessageParameters());
                    errors.add(error);
                }
                RemotableAttributeError remotableAttributeError = RemotableAttributeError.Builder.create((String)errorKey, errors).build();
                validationErrors.add(remotableAttributeError);
            }
            GlobalVariables.getMessageMap().clearErrorMessages();
        }
    }

    protected List<Row> createFieldRowsForWorkflowAttributes(WorkflowAttributes attrs) {
        ArrayList<Row> searchFields = new ArrayList<Row>();
        List<SearchingTypeDefinition> searchingTypeDefinitions = attrs.getSearchingTypeDefinitions();
        WorkflowAttributePropertyResolutionService propertyResolutionService = KRADServiceLocatorInternal.getWorkflowAttributePropertyResolutionService();
        for (SearchingTypeDefinition definition : searchingTypeDefinitions) {
            String fieldDataType;
            SearchingAttribute attr = definition.getSearchingAttribute();
            String attributeName = attr.getAttributeName();
            String businessObjectClassName = attr.getBusinessObjectClassName();
            Class<?> boClass = null;
            BusinessObject businessObject = null;
            try {
                boClass = Class.forName(businessObjectClassName);
                businessObject = (BusinessObject)boClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Field searchField = FieldUtils.getPropertyField(boClass, attributeName, false);
            searchField.setColumnVisible(attr.isShowAttributeInResultSet());
            if (!attr.isShowAttributeInSearchCriteria()) {
                searchField.setFieldType("hidden");
            }
            if ((fieldDataType = propertyResolutionService.determineFieldDataType(boClass, attributeName)).equals(DATA_TYPE_BOOLEAN)) {
                fieldDataType = "string";
            }
            if (fieldDataType.equals("float") || fieldDataType.equals("long") || fieldDataType.equals("datetime")) {
                searchField.setAllowInlineRange(true);
            }
            searchField.setFieldDataType(fieldDataType);
            ArrayList<String> displayedFieldNames = new ArrayList<String>();
            displayedFieldNames.add(attributeName);
            LookupUtils.setFieldQuickfinder(businessObject, attributeName, searchField, displayedFieldNames);
            ArrayList<Field> fieldList = new ArrayList<Field>();
            fieldList.add(searchField);
            Row row = new Row(fieldList);
            if (!attr.isShowAttributeInSearchCriteria()) {
                row.setHidden(true);
            }
            searchFields.add(row);
        }
        return searchFields;
    }

    protected List<DocumentAttribute> parsePrimaryKeyValuesFromDocument(Class<? extends BusinessObject> businessObjectClass, MaintenanceDocument document) {
        ArrayList<DocumentAttribute> values = new ArrayList<DocumentAttribute>();
        List<String> primaryKeyNames = KNSServiceLocator.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(businessObjectClass);
        for (String primaryKeyNameAsObj : primaryKeyNames) {
            String primaryKeyName = primaryKeyNameAsObj;
            DocumentAttribute searchableValue = this.parseSearchableAttributeValueForPrimaryKey(primaryKeyName, businessObjectClass, document);
            if (searchableValue == null) continue;
            values.add(searchableValue);
        }
        return values;
    }

    protected DocumentAttribute parseSearchableAttributeValueForPrimaryKey(String propertyName, Class<? extends BusinessObject> businessObjectClass, MaintenanceDocument document) {
        Maintainable maintainable = document.getNewMaintainableObject();
        PersistableBusinessObject bo = maintainable.getBusinessObject();
        Object propertyValue = ObjectUtils.getPropertyValue(bo, propertyName);
        if (propertyValue == null) {
            return null;
        }
        WorkflowAttributePropertyResolutionService propertyResolutionService = KRADServiceLocatorInternal.getWorkflowAttributePropertyResolutionService();
        DocumentAttribute value = propertyResolutionService.buildSearchableAttribute(businessObjectClass, propertyName, propertyValue);
        return value;
    }

    protected Class<? extends BusinessObject> getBusinessObjectClass(String documentTypeName) {
        MaintenanceDocumentEntry entry = this.retrieveMaintenanceDocumentEntry(documentTypeName);
        return entry == null ? null : entry.getDataObjectClass();
    }

    protected Class<? extends Maintainable> getMaintainableClass(String documentTypeName) {
        MaintenanceDocumentEntry entry = this.retrieveMaintenanceDocumentEntry(documentTypeName);
        return entry == null ? null : entry.getMaintainableClass();
    }

    protected MaintenanceDocumentEntry retrieveMaintenanceDocumentEntry(String documentTypeName) {
        return (MaintenanceDocumentEntry)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(documentTypeName);
    }

    protected GlobalBusinessObject retrieveGlobalBusinessObject(String documentNumber, Class<? extends BusinessObject> businessObjectClass) {
        GlobalBusinessObject globalBO = null;
        LinkedHashMap<String, String> pkMap = new LinkedHashMap<String, String>();
        pkMap.put("documentNumber", documentNumber);
        List returnedBOs = (List)KRADServiceLocator.getBusinessObjectService().findMatching(businessObjectClass, pkMap);
        if (returnedBOs.size() > 0) {
            globalBO = (GlobalBusinessObject)returnedBOs.get(0);
        }
        return globalBO;
    }

    protected List<DocumentAttribute> findAllDocumentAttributesForGlobalBusinessObject(GlobalBusinessObject globalBO) {
        ArrayList<DocumentAttribute> searchValues = new ArrayList<DocumentAttribute>();
        List<PersistableBusinessObject> globalChangesToPersist = globalBO.generateGlobalChangesToPersist();
        if (!CollectionUtils.isEmpty(globalChangesToPersist)) {
            for (PersistableBusinessObject bo : globalChangesToPersist) {
                List<DocumentAttribute> values = this.generateSearchableAttributeFromChange(bo);
                if (CollectionUtils.isEmpty(values)) continue;
                searchValues.addAll(values);
            }
        }
        return searchValues;
    }

    protected List<DocumentAttribute> generateSearchableAttributeFromChange(PersistableBusinessObject changeToPersist) {
        List primaryKeyNames = KNSServiceLocator.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(changeToPersist.getClass()).stream().distinct().collect(Collectors.toList());
        WorkflowAttributePropertyResolutionService propertyResolutionService = KRADServiceLocatorInternal.getWorkflowAttributePropertyResolutionService();
        ArrayList<DocumentAttribute> documentAttributes = new ArrayList<DocumentAttribute>();
        for (Object primaryKeyNameAsObject : primaryKeyNames) {
            String primaryKeyName = (String)primaryKeyNameAsObject;
            Object value = ObjectUtils.getPropertyValue(changeToPersist, primaryKeyName);
            if (value == null) continue;
            DocumentAttribute saValue = propertyResolutionService.buildSearchableAttribute(changeToPersist.getClass(), primaryKeyName, value);
            documentAttributes.add(saValue);
        }
        return documentAttributes;
    }

    protected List<Row> createFieldRowsForBusinessObject(Class<? extends BusinessObject> businessObjectClass) {
        ArrayList<Row> searchFields = new ArrayList<Row>();
        List<String> primaryKeyNamesAsObjects = KNSServiceLocator.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(businessObjectClass);
        BusinessObjectEntry boEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObjectClass.getName());
        WorkflowAttributePropertyResolutionService propertyResolutionService = KRADServiceLocatorInternal.getWorkflowAttributePropertyResolutionService();
        Iterator<String> iterator = primaryKeyNamesAsObjects.iterator();
        while (iterator.hasNext()) {
            String primaryKeyNameAsObject;
            String attributeName = primaryKeyNameAsObject = iterator.next();
            BusinessObject businessObject = null;
            try {
                businessObject = businessObjectClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Field searchField = FieldUtils.getPropertyField(businessObjectClass, attributeName, false);
            String dataType = propertyResolutionService.determineFieldDataType(businessObjectClass, attributeName);
            searchField.setFieldDataType(dataType);
            ArrayList<Field> fieldList = new ArrayList<Field>();
            ArrayList<String> displayedFieldNames = new ArrayList<String>();
            displayedFieldNames.add(attributeName);
            LookupUtils.setFieldQuickfinder(businessObject, attributeName, searchField, displayedFieldNames);
            fieldList.add(searchField);
            searchFields.add(new Row(fieldList));
        }
        return searchFields;
    }
}

