/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.app.persistence.jpa;

import java.util.HashSet;
import java.util.Set;

/**
 * Business Object class exposer which adds non-KNS Rice entities to the KNS persistence units, so that these objects
 * can be used with KNS functionality - for instance, PersonImpl objects can be looked up.
 */
public class RiceToNervousSystemBusinessObjectClassExposer implements PersistableBusinessObjectClassExposer {

    /**
     * Exposes a list of non-KNS entity class names
     *
     * @see PersistableBusinessObjectClassExposer#exposePersistableBusinessObjectClassNames()
     */
    public Set<String> exposePersistableBusinessObjectClassNames() {
        return new HashSet<>();
    }

}
