/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.comparator;

import java.io.Serializable;
import java.util.Comparator;

public final class BooleanValueComparator implements Serializable, Comparator<Boolean> {
    private static final BooleanValueComparator INSTANCE = new BooleanValueComparator();

    private BooleanValueComparator() {
        //private
    }

    public static BooleanValueComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Boolean o1, Boolean o2) {
        int compared = 0;

        if (!o1.equals(o2)) {
            if (o1.equals(Boolean.FALSE)) {
                compared = 1;
            } else {
                compared = -1;
            }
        }

        return compared;
    }
}
