/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.uif.component;

/**
 * Declares methods for determining which client side events are supported by a <code>Component</code> and methods for
 * retrieving the event code
 * <p>
 * <p>
 * The code returned by the get*Script methods will be wrapped in the appropriate event registration code, therefore
 * only the body needs to be returned
 */
public interface ScriptEventSupport {

    /**
     * @return boolean true if event is supported, false if the event is not supported
     */
    boolean getSupportsOnLoad();

    /**
     * @return String JavaScript code that should be executed when the component's onLoad event is fired
     */
    String getOnLoadScript();

    /**
     * @param script script for onLoad to set.
     */
    void setOnLoadScript(String script);

    /**
     * @return boolean true if ready event is supported, false if the event is not supported
     */
    boolean getSupportsOnDocumentReady();

    /**
     * @param script script for onDocumentReadyScript to set.
     */
    void setOnDocumentReadyScript(String script);

    /**
     * @return the onDocumentReadyScript (run when the document ready event is triggered)
     */
    String getOnDocumentReadyScript();

    /**
     * @return boolean true if onUnload event is supported, false if the event is not supported
     */
    boolean getSupportsOnUnload();

    /**
     * @return String JavaScript code for onUnload event
     */
    String getOnUnloadScript();

    /**
     * @return boolean true if onClose event is supported, false if the event is not supported
     */
    boolean getSupportsOnClose();

    /**
     * @return String JavaScript code for onClose event.
     */
    String getOnCloseScript();

    /**
     * @return boolean true if onBlur event is supported, false if the event is not supported
     */
    boolean getSupportsOnBlur();

    /**
     * @return String JavaScript code to set for onBlur event.
     */
    String getOnBlurScript();

    /**
     * @param script String JavaScript code to set for onBlur event.
     */
    void setOnBlurScript(String script);

    /**
     * @return boolean true if onChange event is supported, false if the event is not supported
     */
    boolean getSupportsOnChange();

    /**
     * @return String JavaScript code that should be executed when the component's onChange event is fired
     */
    String getOnChangeScript();

    /**
     * @return boolean true if onClick event is supported, false if the event is not supported
     */
    boolean getSupportsOnClick();

    /**
     * @return String JavaScript code that should be executed when the component's onClick event is fired
     */
    String getOnClickScript();

    /**
     * @return boolean true if onDblClick event is supported, false if the event is not supported
     */
    boolean getSupportsOnDblClick();

    /**
     * @return String JavaScript code that should be executed when the component's onDblClick event is fired
     */
    String getOnDblClickScript();

    /**
     * @return boolean true if onFocus event is supported, false if the event is not supported
     */
    boolean getSupportsOnFocus();

    /**
     * @return String JavaScript code that should be executed when the component's onFocus event is fired
     */
    String getOnFocusScript();

    /**
     * @return boolean true if onSubmit event is supported, false if the event is not supported
     */
    boolean getSupportsOnSubmit();

    /**
     * @return String JavaScript code that should be executed when the component's onSubmit event is fired
     */
    String getOnSubmitScript();

    /**
     * @return boolean true if onKeyPress event is supported, false if the event is not supported
     */
    boolean getSupportsOnKeyPress();

    /**
     * @return String JavaScript code that should be executed when the component's onKeyPress event is fired
     */
    String getOnKeyPressScript();

    /**
     * @return boolean true if onKeyUp event is supported, false if the event is not supported
     */
    boolean getSupportsOnKeyUp();

    /**
     * @return String JavaScript code that should be executed when the component's onKeyUp event is fired
     */
    String getOnKeyUpScript();

    /**
     * @return boolean true if onKeyDown event is supported, false if the event is not supported
     */
    boolean getSupportsOnKeyDown();

    /**
     * @return String JavaScript code that should be executed when the component's onKeyDown event is fired
     */
    String getOnKeyDownScript();

    /**
     * @return boolean true if onMouseOver event is supported, false if the event is not supported
     */
    boolean getSupportsOnMouseOver();

    /**
     * @return String JavaScript code that should be executed when the component's onMouseOver event is fired
     */
    String getOnMouseOverScript();

    /**
     * @return boolean true if onMouseOut event is supported, false if the event is not supported
     */
    boolean getSupportsOnMouseOut();

    /**
     * @return String JavaScript code that should be executed when the component's onMouseOut event is fired
     */
    String getOnMouseOutScript();

    /**
     * @return boolean true if onMouseUp event is supported, false if the event is not supported
     */
    boolean getSupportsOnMouseUp();

    /**
     * @return String JavaScript code that should be executed when the component's onMouseUp event is fired
     */
    String getOnMouseUpScript();

    /**
     * @return boolean true if onMouseDown event is supported, false if the event is not supported
     */
    boolean getSupportsOnMouseDown();

    /**
     * @return String JavaScript code that should be executed when the component's onMouseDown event is fired
     */
    String getOnMouseDownScript();

    /**
     * @return boolean true if onMouseMove event is supported, false if the event is not supported
     */
    boolean getSupportsOnMouseMove();

    /**
     * @return String JavaScript code that should be executed when the component's onMouseMove event is fired
     */
    String getOnMouseMoveScript();

}
