/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.coreservice.framework.namespace;

import org.kuali.kfs.coreservice.api.namespace.NamespaceContract;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

/**
 * TODO: Likely should remove all methods from this interface after KULRICE-7170 is fixed
 */
public interface NamespaceEbo extends NamespaceContract,
    ExternalizableBusinessObject, MutableInactivatable {

    /**
     * It is a way of assigning the Namespace to a specific rice application or rice ecosystem.
     *
     * @return application id which owns this Namespace.  If this namespace has no application owner, then this
     * method will return null.
     */
    String getApplicationId();

    /**
     * @return name for the Namespace.  This can be null or a blank string.
     */
    String getName();

    /**
     * @return the version number for this object. In general, this value should only be null if the object has not yet
     *         been stored to a persistent data store. This version number is generally used for the purposes of
     *         optimistic locking.
     */
    Long getVersionNumber();

    /**
     * @return the globally unique object id of this object. In general, this value should only be null if the object
     *         has not yet been stored to a persistent data store.
     */
    String getObjectId();

    /**
     * @return true if active false if not.
     */
    boolean isActive();

    /**
     * Sets the record to active or inactive.
     */
    void setActive(boolean active);

    /**
     * @return the code value for this object. In general a code value cannot be null or a blank string.
     */
    String getCode();
}
