/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.kns.exception;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.exception.KualiException;

public class FileUploadLimitExceededException extends KualiException {

    private final ActionForm actionForm;
    private final ActionMapping actionMapping;

    public FileUploadLimitExceededException(String message, ActionForm actionForm, ActionMapping actionMapping) {
        super(message);
        this.actionForm = actionForm;
        this.actionMapping = actionMapping;
    }

    public ActionForm getActionForm() {
        return this.actionForm;
    }

    public ActionMapping getActionMapping() {
        return this.actionMapping;
    }

}
