/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.kns.question;

import java.util.ArrayList;

/**
 * This interface defines methods that are required to support c Confirmation Question.
 */
public interface Question {

    /**
     * returns the index associated with a specified button
     *
     * @param btnText the text of the button
     * @return the index of this button
     */
    String getButtonIndex(String btnText);

    /**
     * @return Returns the buttons.
     */
    ArrayList getButtons();

    /**
     * @param buttons The buttons to set.
     */
    void setButtons(ArrayList buttons);

    /**
     * @return Returns the question.
     */
    String getQuestion();

    /**
     * @param question The question to set.
     */
    void setQuestion(String question);
}
