/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.datadictionary;

import org.kuali.kfs.krad.comparator.BooleanValueComparator;
import org.kuali.kfs.krad.comparator.NumericValueComparator;
import org.kuali.kfs.krad.comparator.StringValueComparator;
import org.kuali.kfs.krad.comparator.DateValueComparator;

import java.util.Comparator;

public class LookupResultAttributeDefinition extends AttributeDefinition {

    private Comparator comparator;
    private boolean disableInquiry = false;

    public Comparator getComparator() {
        if (this.comparator != null) {
            return comparator;
        }

        return estimateComparator();
    }

    private Comparator estimateComparator() {
        Type type = getType();
        switch (type) {
            case BOOLEAN:
                return BooleanValueComparator.getInstance();
            case CURRENCY:
            case DECIMAL:
            case INTEGER:
            case LONG:
                return new NumericValueComparator();
            case DATE_RANGE:
            case DATE_TIME:
                return DateValueComparator.getInstance();
            default:
                return StringValueComparator.getInstance();
        }
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public boolean isDisableInquiry() {
        return disableInquiry;
    }

    public void setDisableInquiry(boolean disableInquiry) {
        this.disableInquiry = disableInquiry;
    }
}
