/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.datadictionary.validation.constraint;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import java.util.List;

/**
 * A case constraint is a constraint that is imposed only when a certain condition is met, for example, if the country
 * attribute value is "USA", then a prerequisite constraint may be imposed that the 'State' attribute is non-null.
 * <p>
 * This class is a direct copy of one that was in Kuali Student.
 *
 * @since 1.1
 */
@XmlAccessorType(XmlAccessType.FIELD)
public class CaseConstraint extends BaseConstraint {

    @XmlElement
    protected List<WhenConstraint> whenConstraint;
    @XmlElement
    protected String propertyName;
    @XmlElement
    protected String operator;
    @XmlElement
    protected boolean caseSensitive;

    public List<WhenConstraint> getWhenConstraint() {
        return whenConstraint;
    }

    public void setWhenConstraint(List<WhenConstraint> whenConstraint) {
        this.whenConstraint = whenConstraint;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public boolean isCaseSensitive() {
        return caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}
