/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.core.framework.persistence.ojb.conversion;

import java.security.GeneralSecurityException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.kuali.rice.core.api.CoreApiServiceLocator;

public class OjbKualiHashFieldConversion
implements FieldConversion {
    public Object javaToSql(Object source) {
        Object converted = source;
        if (converted != null) {
            if (converted.toString().endsWith("(&^HSH#&)")) {
                converted = StringUtils.stripEnd((String)converted.toString(), (String)"(&^HSH#&)");
            } else {
                try {
                    converted = CoreApiServiceLocator.getEncryptionService().hash(converted);
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException("Unable to hash value to db: " + e.getMessage());
                }
            }
        }
        return converted;
    }

    public Object sqlToJava(Object source) {
        if (source == null) {
            return "";
        }
        return source.toString() + "(&^HSH#&)";
    }
}

