/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.api.parameter;

import java.util.Collection;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterKey;
import org.kuali.kfs.coreservice.api.parameter.ParameterQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="parameterService", targetNamespace="http://kfs.kuali.org/core/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface ParameterRepositoryService {
    @WebMethod(operationName="createParameter")
    @WebResult(name="parameter")
    @CacheEvict(value={"http://kfs.kuali.org/core/v2_0/ParameterType"}, allEntries=true)
    public Parameter createParameter(@WebParam(name="parameter") Parameter var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateParameter")
    @WebResult(name="parameter")
    @CacheEvict(value={"http://kfs.kuali.org/core/v2_0/ParameterType"}, allEntries=true)
    public Parameter updateParameter(@WebParam(name="parameter") Parameter var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="getParameter")
    @WebResult(name="parameter")
    @Cacheable(value={"http://kfs.kuali.org/core/v2_0/ParameterType"}, key="'key=' + #p0.getCacheKey()")
    public Parameter getParameter(@WebParam(name="key") ParameterKey var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getParameterValueAsString")
    @WebResult(name="value")
    @Cacheable(value={"http://kfs.kuali.org/core/v2_0/ParameterType"}, key="'{getParameterValueAsString}' + 'key=' + #p0.getCacheKey()")
    public String getParameterValueAsString(@WebParam(name="key") ParameterKey var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getParameterValueAsBoolean")
    @WebResult(name="value")
    @Cacheable(value={"http://kfs.kuali.org/core/v2_0/ParameterType"}, key="'{getParameterValueAsBoolean}' + 'key=' + #p0.getCacheKey()")
    public Boolean getParameterValueAsBoolean(@WebParam(name="key") ParameterKey var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getParameterValuesAsString")
    @XmlElementWrapper(name="values", required=true)
    @XmlElement(name="value", required=false)
    @WebResult(name="values")
    @Cacheable(value={"http://kfs.kuali.org/core/v2_0/ParameterType"}, key="'{getParameterValuesAsString}' + 'key=' + #p0.getCacheKey()")
    public Collection<String> getParameterValuesAsString(@WebParam(name="key") ParameterKey var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getSubParameterValueAsString")
    @WebResult(name="value")
    public String getSubParameterValueAsString(@WebParam(name="key") ParameterKey var1, @WebParam(name="subParameterName") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getSubParameterValuesAsString")
    @XmlElementWrapper(name="values", required=true)
    @XmlElement(name="value", required=false)
    @WebResult(name="values")
    public Collection<String> getSubParameterValuesAsString(@WebParam(name="key") ParameterKey var1, @WebParam(name="subParameterName") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findParameters")
    @WebResult(name="results")
    public ParameterQueryResults findParameters(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;
}

