/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.krad.datadictionary.AttributeDefinitionBase;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.kfs.krad.datadictionary.HelpDefinition;
import org.kuali.kfs.krad.datadictionary.LookupAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.LookupResultAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.SortDefinition;
import org.kuali.kfs.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.LookupSearchService;
import org.kuali.rice.core.api.config.property.ConfigurationService;

@Deprecated
public class LookupDefinition
extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = 6733008572890721359L;
    protected String lookupableID;
    protected String title;
    protected String menubar;
    protected SortDefinition defaultSort;
    private LookupSearchService lookupSearchService;
    private List<LookupAttributeDefinition> lookupAttributeDefinitions = new LinkedList<LookupAttributeDefinition>();
    private List<LookupResultAttributeDefinition> lookupResultAttributeDefinitions = new LinkedList<LookupResultAttributeDefinition>();
    protected Map<String, LookupResultAttributeDefinition> lookupResultMap = new LinkedHashMap<String, LookupResultAttributeDefinition>();
    protected Map<String, LookupAttributeDefinition> lookupAttributeMap = new LinkedHashMap<String, LookupAttributeDefinition>();
    protected List<FieldDefinition> lookupFields = new ArrayList<FieldDefinition>();
    protected Map<String, FieldDefinition> lookupFieldMap = new LinkedHashMap<String, FieldDefinition>();
    protected List<FieldDefinition> resultFields = new ArrayList<FieldDefinition>();
    protected Map<String, FieldDefinition> resultFieldMap = new LinkedHashMap<String, FieldDefinition>();
    protected Integer resultSetLimit = null;
    protected Integer multipleValuesResultSetLimit = null;
    protected String extraButtonSource;
    protected String extraButtonParams;
    protected String searchIconOverride;
    protected int numOfColumns = 2;
    protected HelpDefinition helpDefinition;
    protected String helpUrl;
    protected boolean translateCodes = false;
    protected boolean disableSearchButtons = false;

    public void setLookupableID(String lookupableID) {
        if (lookupableID == null) {
            throw new IllegalArgumentException("invalid (null) lookupableID");
        }
        this.lookupableID = lookupableID;
    }

    public String getLookupableID() {
        return this.lookupableID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            throw new IllegalArgumentException("invalid (blank) title");
        }
        this.title = title;
    }

    public boolean hasMenubar() {
        return this.menubar != null;
    }

    public String getMenubar() {
        return this.menubar;
    }

    public void setMenubar(String menubar) {
        if (StringUtils.isBlank((CharSequence)menubar)) {
            throw new IllegalArgumentException("invalid (blank) menubar");
        }
        ConfigurationService kualiConfigurationservice = KRADServiceLocator.getKualiConfigurationService();
        this.menubar = menubar.replace("${kr.externalizable.images.url}", kualiConfigurationservice.getPropertyValueAsString("kr.externalizable.images.url")).replace("${externalizable.images.url}", kualiConfigurationservice.getPropertyValueAsString("externalizable.images.url"));
        this.menubar = this.menubar.replace("${application.url}", kualiConfigurationservice.getPropertyValueAsString("application.url"));
    }

    public boolean hasDefaultSort() {
        return this.defaultSort != null;
    }

    public SortDefinition getDefaultSort() {
        return this.defaultSort;
    }

    public void setDefaultSort(SortDefinition defaultSort) {
        if (defaultSort == null) {
            throw new IllegalArgumentException("invalid (null) defaultSort");
        }
        this.defaultSort = defaultSort;
    }

    public List getLookupFieldNames() {
        return new ArrayList<String>(this.lookupFieldMap.keySet());
    }

    public List<FieldDefinition> getLookupFields() {
        return this.lookupFields;
    }

    public FieldDefinition getLookupField(String attributeName) {
        return this.lookupFieldMap.get(attributeName);
    }

    public List<String> getResultFieldNames() {
        return new ArrayList<String>(this.resultFieldMap.keySet());
    }

    public List<FieldDefinition> getResultFields() {
        return this.resultFields;
    }

    public FieldDefinition getResultField(String attributeName) {
        return this.resultFieldMap.get(attributeName);
    }

    public void setResultSetLimit(Integer resultSetLimit) {
        this.resultSetLimit = resultSetLimit;
    }

    public boolean hasResultSetLimit() {
        return this.resultSetLimit != null;
    }

    public Integer getResultSetLimit() {
        return this.resultSetLimit;
    }

    public void setMultipleValuesResultSetLimit(Integer multipleValuesResultSetLimit) {
        this.multipleValuesResultSetLimit = multipleValuesResultSetLimit;
    }

    public boolean hasMultipleValuesResultSetLimit() {
        return this.multipleValuesResultSetLimit != null;
    }

    public Integer getMultipleValuesResultSetLimit() {
        return this.multipleValuesResultSetLimit;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (this.hasDefaultSort()) {
            this.defaultSort.completeValidation(rootBusinessObjectClass, (Class)null);
        }
        for (FieldDefinition lookupField : this.lookupFields) {
            lookupField.completeValidation(rootBusinessObjectClass, (Class)null);
        }
        for (FieldDefinition resultField : this.resultFields) {
            resultField.completeValidation(rootBusinessObjectClass, (Class)null);
        }
    }

    public boolean hasExtraButtonSource() {
        return this.extraButtonSource != null;
    }

    public String getExtraButtonSource() {
        return this.extraButtonSource;
    }

    public void setExtraButtonSource(String extraButtonSource) {
        if (StringUtils.isBlank((CharSequence)extraButtonSource)) {
            throw new IllegalArgumentException("invalid (blank) button source");
        }
        this.extraButtonSource = extraButtonSource;
    }

    public boolean hasExtraButtonParams() {
        return this.extraButtonParams != null;
    }

    public String getExtraButtonParams() {
        return this.extraButtonParams;
    }

    public void setExtraButtonParams(String extraButtonParams) {
        this.extraButtonParams = extraButtonParams;
    }

    public boolean hasSearchIconOverride() {
        return this.searchIconOverride != null;
    }

    public String getSearchIconOverride() {
        return this.searchIconOverride;
    }

    public void setSearchIconOverride(String searchIconOverride) {
        if (StringUtils.isBlank((CharSequence)searchIconOverride)) {
            throw new IllegalArgumentException("invalid (blank) search icon override");
        }
        this.searchIconOverride = searchIconOverride;
    }

    public String toString() {
        return "LookupDefinition '" + this.getTitle() + "'";
    }

    public void setLookupFields(List<FieldDefinition> lookupFields) {
        this.lookupFieldMap.clear();
        for (FieldDefinition lookupField : lookupFields) {
            if (lookupField == null) {
                throw new IllegalArgumentException("invalid (null) lookupField");
            }
            String keyName = lookupField.getAttributeName();
            if (this.lookupFieldMap.containsKey(keyName)) {
                throw new DuplicateEntryException("duplicate lookupField entry for attribute '" + keyName + "'");
            }
            this.lookupFieldMap.put(keyName, lookupField);
        }
        this.lookupFields = lookupFields;
    }

    public void setResultFields(List<FieldDefinition> resultFields) {
        this.resultFieldMap.clear();
        for (FieldDefinition resultField : resultFields) {
            if (resultField == null) {
                throw new IllegalArgumentException("invalid (null) resultField");
            }
            String keyName = resultField.getAttributeName();
            if (this.resultFieldMap.containsKey(keyName)) {
                throw new DuplicateEntryException("duplicate resultField entry for attribute '" + keyName + "'");
            }
            this.resultFieldMap.put(keyName, resultField);
        }
        this.resultFields = resultFields;
    }

    public int getNumOfColumns() {
        return this.numOfColumns;
    }

    public void setNumOfColumns(int numOfColumns) {
        this.numOfColumns = numOfColumns;
    }

    public HelpDefinition getHelpDefinition() {
        return this.helpDefinition;
    }

    public void setHelpDefinition(HelpDefinition helpDefinition) {
        this.helpDefinition = helpDefinition;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public boolean isTranslateCodes() {
        return this.translateCodes;
    }

    public void setTranslateCodes(boolean translateCodes) {
        this.translateCodes = translateCodes;
    }

    public boolean isDisableSearchButtons() {
        return this.disableSearchButtons;
    }

    public void setDisableSearchButtons(boolean disableSearchButtons) {
        this.disableSearchButtons = disableSearchButtons;
    }

    public LookupSearchService getLookupSearchService() {
        return this.lookupSearchService;
    }

    public void setLookupSearchService(LookupSearchService lookupSearchService) {
        this.lookupSearchService = lookupSearchService;
    }

    public List<LookupAttributeDefinition> getLookupAttributeDefinitions() {
        return this.lookupAttributeDefinitions;
    }

    public void setLookupAttributeDefinitions(List<LookupAttributeDefinition> lookupAttributeDefinitions) {
        this.lookupAttributeDefinitions = lookupAttributeDefinitions;
        this.lookupAttributeMap = lookupAttributeDefinitions.stream().collect(Collectors.toMap(AttributeDefinitionBase::getName, Function.identity()));
    }

    public LookupAttributeDefinition getLookupAttributeDefinition(String definitionName) {
        return this.lookupAttributeMap.get(definitionName);
    }

    public List<LookupResultAttributeDefinition> getLookupResultAttributeDefinitions() {
        return this.lookupResultAttributeDefinitions;
    }

    public LookupResultAttributeDefinition getLookupResultAttributeDefinition(String definitionName) {
        return this.lookupResultMap.get(definitionName);
    }

    public void setLookupResultAttributeDefinitions(List<LookupResultAttributeDefinition> lookupResultDefinitions) {
        this.lookupResultAttributeDefinitions = lookupResultDefinitions;
        this.lookupResultMap = this.lookupResultAttributeDefinitions.stream().collect(Collectors.toMap(AttributeDefinitionBase::getName, Function.identity()));
    }
}

