/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary.validation.fieldlevel;

import org.kuali.kfs.krad.datadictionary.exporter.ExportMap;
import org.kuali.kfs.krad.datadictionary.validation.FieldLevelValidationPattern;
import org.kuali.kfs.krad.datadictionary.validation.ValidationPattern;

public class FixedPointValidationPattern
extends FieldLevelValidationPattern {
    public static final String PATTERN_TYPE_PRECISION = "fixedPoint.precision";
    public static final String PATTERN_TYPE_SCALE = "fixedPoint.scale";
    protected boolean allowNegative;
    protected int precision;
    protected int scale;

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean getAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    @Override
    protected String getRegexString() {
        StringBuilder regex = new StringBuilder();
        if (this.allowNegative) {
            regex.append("-?");
        }
        regex.append("(").append("[0-9]{0,").append(this.getPrecision() - this.getScale()).append("}").append("\\.").append("[0-9]{1,").append(this.getScale()).append("}").append("|[0-9]{1,").append(this.getPrecision() - this.getScale()).append("}").append(")");
        return regex.toString();
    }

    @Override
    protected String getPatternTypeName() {
        return "fixedPoint";
    }

    @Override
    public ExportMap buildExportMap(String exportKey) {
        ExportMap exportMap = super.buildExportMap(exportKey);
        if (this.allowNegative) {
            exportMap.set("allowNegative", "true");
        }
        exportMap.set("precision", Integer.toString(this.precision));
        exportMap.set("scale", Integer.toString(this.scale));
        return exportMap;
    }

    @Override
    public String getValidationErrorMessageKey() {
        StringBuilder buf = new StringBuilder();
        buf.append("error.format.").append(this.getClass().getName());
        if (this.allowNegative) {
            buf.append(".allowNegative");
        }
        return buf.toString();
    }

    @Override
    public String[] getValidationErrorMessageParameters(String attributeLabel) {
        return new String[]{attributeLabel, String.valueOf(this.precision), String.valueOf(this.scale)};
    }

    @Override
    public void completeValidation() throws ValidationPattern.ValidationPatternException {
        boolean valid;
        super.completeValidation();
        boolean bl = valid = this.getPrecision() >= 1 && this.getScale() >= 0 && this.getPrecision() >= this.getScale();
        if (!valid) {
            throw new ValidationPattern.ValidationPatternException("The precision must be >= 1.  The scale must be >= 0.  The precision must be >= scale. Precision: " + this.getPrecision() + " Scale: " + this.getScale());
        }
    }
}

