/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.document.authorization;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.document.authorization.FieldRestriction;
import org.kuali.kfs.krad.datadictionary.mask.MaskFormatter;

public class BusinessObjectRestrictionsBase
implements BusinessObjectRestrictions {
    private Map<String, MaskFormatter> partiallyMaskedFields;
    private Map<String, MaskFormatter> fullyMaskedFields;
    protected Set<String> allRestrictedFields;

    public BusinessObjectRestrictionsBase() {
        this.clearAllRestrictions();
    }

    @Override
    public boolean hasAnyFieldRestrictions() {
        return !this.partiallyMaskedFields.isEmpty() || !this.fullyMaskedFields.isEmpty();
    }

    @Override
    public boolean hasRestriction(String fieldName) {
        return this.isPartiallyMaskedField(fieldName) || this.isFullyMaskedField(fieldName);
    }

    @Override
    public void addFullyMaskedField(String fieldName, MaskFormatter maskFormatter) {
        this.fullyMaskedFields.put(fieldName, maskFormatter);
    }

    @Override
    public void addPartiallyMaskedField(String fieldName, MaskFormatter maskFormatter) {
        this.partiallyMaskedFields.put(fieldName, maskFormatter);
    }

    @Override
    public FieldRestriction getFieldRestriction(String fieldName) {
        if (this.hasRestriction(fieldName)) {
            FieldRestriction fieldRestriction = null;
            if (this.isPartiallyMaskedField(fieldName)) {
                fieldRestriction = new FieldRestriction(fieldName, "partiallyMasked");
                fieldRestriction.setMaskFormatter(this.partiallyMaskedFields.get(this.normalizeFieldName(fieldName)));
            }
            if (this.isFullyMaskedField(fieldName)) {
                fieldRestriction = new FieldRestriction(fieldName, "masked");
                fieldRestriction.setMaskFormatter(this.fullyMaskedFields.get(this.normalizeFieldName(fieldName)));
            }
            return fieldRestriction;
        }
        return new FieldRestriction(fieldName, "editable");
    }

    @Override
    public Set<String> getAllFieldRestrictionNames() {
        return Stream.concat(this.partiallyMaskedFields.keySet().stream(), this.fullyMaskedFields.keySet().stream()).collect(Collectors.toSet());
    }

    public void clearAllRestrictions() {
        this.partiallyMaskedFields = new HashMap<String, MaskFormatter>();
        this.fullyMaskedFields = new HashMap<String, MaskFormatter>();
        this.allRestrictedFields = null;
    }

    protected String normalizeFieldName(String fieldName) {
        return fieldName;
    }

    protected boolean isFullyMaskedField(String fieldName) {
        String normalizedFieldName = this.normalizeFieldName(fieldName);
        return this.fullyMaskedFields.containsKey(normalizedFieldName);
    }

    protected boolean isPartiallyMaskedField(String fieldName) {
        String normalizedFieldName = this.normalizeFieldName(fieldName);
        return this.partiallyMaskedFields.containsKey(normalizedFieldName);
    }
}

