/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.comparator.NullValueComparator;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.datadictionary.control.ControlDefinition;
import org.kuali.kfs.krad.exception.ClassNotPersistableException;
import org.kuali.kfs.krad.lookup.SelectiveReferenceRefresher;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.Range;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.krad.bo.BusinessObject;

public final class LookupUtils {
    private static final Logger LOG = LogManager.getLogger(LookupUtils.class);
    private static String BASE_LOOKUP_ACTION_URL = null;
    private static String BASE_MULTIPLE_VALUE_LOOKUP_ACTION_URL = null;
    private static String BASE_INQUIRY_ACTION_URL = null;
    private static Map<Class, Map<String, Map>> referencesForForeignKey = new HashMap<Class, Map<String, Map>>();

    private LookupUtils() {
    }

    public static void removeHiddenCriteriaFields(Class businessObjectClass, Map fieldValues) {
        List<String> lookupFieldAttributeList = LookupUtils.getBusinessObjectMetaDataService().getLookupableFieldNames(businessObjectClass);
        if (lookupFieldAttributeList != null) {
            for (String attributeName : lookupFieldAttributeList) {
                ControlDefinition controlDef;
                if (!fieldValues.containsKey(attributeName) || (controlDef = LookupUtils.getDataDictionaryService().getAttributeControlDefinition(businessObjectClass, attributeName)) == null || !controlDef.isHidden()) continue;
                fieldValues.remove(attributeName);
            }
        }
    }

    public static Integer getSearchResultsLimit(Class businessObjectClass) {
        Integer limit = null;
        if (BusinessObject.class.isAssignableFrom(businessObjectClass)) {
            limit = LookupUtils.getBusinessObjectSearchResultsLimit(businessObjectClass);
        }
        if (limit == null) {
            limit = LookupUtils.getApplicationSearchResultsLimit();
        }
        return limit;
    }

    public static Integer getApplicationSearchResultsLimit() {
        String limitString = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "Lookup", "RESULTS_LIMIT");
        if (limitString != null) {
            return Integer.valueOf(limitString);
        }
        return null;
    }

    public static Integer getBusinessObjectSearchResultsLimit(Class businessObjectClass) {
        if (!LookupUtils.isMultipleValueLookup()) {
            return LookupUtils.getBusinessObjectDictionaryService().getLookupResultSetLimit(businessObjectClass);
        }
        return LookupUtils.getBusinessObjectDictionaryService().getMultipleValueLookupResultSetLimit(businessObjectClass);
    }

    private static boolean isMultipleValueLookup() {
        KualiForm kualiForm = KNSGlobalVariables.getKualiForm();
        if (kualiForm instanceof LookupForm) {
            LookupForm lookupForm = (LookupForm)kualiForm;
            return lookupForm.isMultipleValues();
        }
        return false;
    }

    public static void applySearchResultsLimit(Class businessObjectClass, Criteria criteria, DatabasePlatform platform) {
        Integer limit = LookupUtils.getSearchResultsLimit(businessObjectClass);
        if (limit != null) {
            criteria.addSql(platform.applyLimitSql(limit));
        }
    }

    public static Integer getApplicationMaximumSearchResulsPerPageForMultipleValueLookups() {
        String limitString = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "Lookup", "MULTIPLE_VALUE_RESULTS_PER_PAGE");
        if (limitString != null) {
            return Integer.valueOf(limitString);
        }
        return null;
    }

    public static List<String> translateReadOnlyFieldsToList(String readOnlyFieldsString) {
        ArrayList<String> readOnlyFieldsList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)readOnlyFieldsString)) {
            if (readOnlyFieldsString.indexOf(",") > 0) {
                StringTokenizer token = new StringTokenizer(readOnlyFieldsString, ",");
                while (token.hasMoreTokens()) {
                    String element = token.nextToken();
                    readOnlyFieldsList.add(element);
                }
            } else {
                readOnlyFieldsList.add(readOnlyFieldsString);
            }
        }
        return readOnlyFieldsList;
    }

    public static Map<String, String> translateFieldConversions(String fieldConversionsString) {
        HashMap<String, String> fieldConversionsMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)fieldConversionsString)) {
            if (fieldConversionsString.indexOf(",") > 0) {
                StringTokenizer token = new StringTokenizer(fieldConversionsString, ",");
                while (token.hasMoreTokens()) {
                    String element = token.nextToken();
                    fieldConversionsMap.put(element.substring(0, element.indexOf(":")), element.substring(element.indexOf(":") + 1));
                }
            } else {
                fieldConversionsMap.put(fieldConversionsString.substring(0, fieldConversionsString.indexOf(":")), fieldConversionsString.substring(fieldConversionsString.indexOf(":") + 1));
            }
        }
        return fieldConversionsMap;
    }

    @Deprecated
    public static Field setFieldQuickfinder(BusinessObject businessObject, String attributeName, Field field, List displayedFieldNames) {
        return LookupUtils.setFieldQuickfinder(businessObject, null, false, 0, attributeName, field, displayedFieldNames);
    }

    @Deprecated
    public static Field setFieldQuickfinder(BusinessObject businessObject, String attributeName, Field field, List displayedFieldNames, SelectiveReferenceRefresher srr) {
        return LookupUtils.setFieldQuickfinder(businessObject, null, false, 0, attributeName, field, displayedFieldNames, srr);
    }

    @Deprecated
    public static Field setFieldQuickfinder(BusinessObject businessObject, String collectionName, boolean addLine, int index, String attributeName, Field field, List displayedFieldNames, SelectiveReferenceRefresher srr) {
        field = LookupUtils.setFieldQuickfinder(businessObject, collectionName, addLine, index, attributeName, field, displayedFieldNames);
        if (srr != null) {
            String collectionPrefix = "";
            if (collectionName != null) {
                collectionPrefix = addLine ? "add." + collectionName + "." : collectionName + "[" + index + "].";
            }
            field.setReferencesToRefresh(LookupUtils.convertReferencesToSelectCollectionToString(srr.getAffectedReferencesFromLookup(businessObject, attributeName, collectionPrefix)));
        }
        return field;
    }

    @Deprecated
    public static Field setFieldQuickfinder(BusinessObject businessObject, String collectionName, boolean addLine, int index, String attributeName, Field field, List displayedFieldNames) {
        if (businessObject == null) {
            return field;
        }
        boolean noLookup = LookupUtils.getBusinessObjectDictionaryService().noLookupFieldLookup(businessObject.getClass(), attributeName);
        return LookupUtils.setFieldQuickfinder(businessObject, collectionName, addLine, index, attributeName, field, displayedFieldNames, noLookup);
    }

    @Deprecated
    public static Field setFieldQuickfinder(BusinessObject businessObject, String collectionName, boolean addLine, int index, String attributeName, Field field, List displayedFieldNames, boolean noLookupField) {
        if (businessObject == null) {
            return field;
        }
        if (noLookupField) {
            return field;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setFieldQuickfinder(" + businessObject.getClass().getName() + "," + attributeName + "," + field + "," + displayedFieldNames + ")");
        }
        DataObjectRelationship relationship = LookupUtils.getBusinessObjectMetaDataService().getBusinessObjectRelationship(businessObject, businessObject.getClass(), attributeName, "", false);
        String collectionPrefix = "";
        if (collectionName != null) {
            collectionPrefix = addLine ? "add." + collectionName + "." : collectionName + "[" + index + "].";
        }
        if (relationship == null) {
            Class c = ObjectUtils.getPropertyType(businessObject, attributeName, LookupUtils.getPersistenceStructureService());
            if (c != null) {
                if (attributeName.contains(".")) {
                    attributeName = StringUtils.substringBeforeLast((String)attributeName, (String)".");
                }
                RelationshipDefinition ddReference = LookupUtils.getBusinessObjectMetaDataService().getBusinessObjectRelationshipDefinition(businessObject, attributeName);
                relationship = LookupUtils.getBusinessObjectMetaDataService().getBusinessObjectRelationship(ddReference, businessObject, businessObject.getClass(), attributeName, "", false);
                if (relationship != null) {
                    field.setQuickFinderClassNameImpl(relationship.getRelatedClass().getName());
                    field.setFieldConversions(LookupUtils.generateFieldConversions(businessObject, collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, null));
                    field.setLookupParameters(LookupUtils.generateLookupParameters(businessObject, collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, null));
                    field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl(false));
                    field.setImageSrc(LookupUtils.getBusinessObjectDictionaryService().getSearchIconOverride(businessObject.getClass()));
                }
            }
            return field;
        }
        if (ObjectUtils.isNestedAttribute(attributeName)) {
            String nestedAttributePrefix = StringUtils.substringBeforeLast((String)attributeName, (String)".");
            field.setQuickFinderClassNameImpl(relationship.getRelatedClass().getName());
            field.setFieldConversions(LookupUtils.generateFieldConversions(businessObject, collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, nestedAttributePrefix));
            field.setLookupParameters(LookupUtils.generateLookupParameters(businessObject, collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, nestedAttributePrefix));
            field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl(false));
        } else {
            field.setQuickFinderClassNameImpl(relationship.getRelatedClass().getName());
            field.setFieldConversions(LookupUtils.generateFieldConversions(businessObject, collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, null));
            field.setLookupParameters(LookupUtils.generateLookupParameters(businessObject, collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, null));
            field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl(false));
        }
        field.setImageSrc(LookupUtils.getBusinessObjectDictionaryService().getSearchIconOverride(businessObject.getClass()));
        return field;
    }

    @Deprecated
    public static String getBaseLookupUrl(boolean isMultipleValue) {
        ConfigurationService kualiConfigurationService = KRADServiceLocator.getKualiConfigurationService();
        if (isMultipleValue) {
            if (BASE_MULTIPLE_VALUE_LOOKUP_ACTION_URL == null) {
                String lookupUrl = kualiConfigurationService.getPropertyValueAsString("application.url");
                if (!lookupUrl.endsWith("/")) {
                    lookupUrl = lookupUrl + "/";
                }
                BASE_MULTIPLE_VALUE_LOOKUP_ACTION_URL = lookupUrl = lookupUrl + "kr/multipleValueLookup.do";
            }
            return BASE_MULTIPLE_VALUE_LOOKUP_ACTION_URL;
        }
        if (BASE_LOOKUP_ACTION_URL == null) {
            String lookupUrl = kualiConfigurationService.getPropertyValueAsString("application.url");
            if (!lookupUrl.endsWith("/")) {
                lookupUrl = lookupUrl + "/";
            }
            BASE_LOOKUP_ACTION_URL = lookupUrl = lookupUrl + "kr/lookup.do";
        }
        return BASE_LOOKUP_ACTION_URL;
    }

    @Deprecated
    public static String getBaseInquiryUrl() {
        if (BASE_INQUIRY_ACTION_URL == null) {
            StringBuffer inquiryUrl = new StringBuffer(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url"));
            if (inquiryUrl.charAt(inquiryUrl.length() - 1) != '/') {
                inquiryUrl.append('/');
            }
            inquiryUrl.append("kr/");
            inquiryUrl.append("inquiry.do");
            BASE_INQUIRY_ACTION_URL = inquiryUrl.toString();
        }
        return BASE_INQUIRY_ACTION_URL;
    }

    public static String transformLookupUrlToMultiple(String lookupUrl) {
        return lookupUrl.replace("kr/lookup.do", "kr/multipleValueLookup.do");
    }

    private static void setFieldDirectInquiry(Field field) {
        if (StringUtils.isNotBlank((CharSequence)field.getFieldConversions())) {
            boolean directInquiriesEnabled = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-NS", "All", "ENABLE_DIRECT_INQUIRIES_IND");
            if (directInquiriesEnabled && StringUtils.isNotBlank((CharSequence)field.getFieldConversions())) {
                String fieldConversions = field.getFieldConversions();
                String newInquiryParameters = "";
                String[] conversions = StringUtils.split((String)fieldConversions, (String)",");
                for (int l = 0; l < conversions.length; ++l) {
                    String conversion = conversions[l];
                    String[] conversionPair = StringUtils.split((String)conversion, (String)":", (int)2);
                    String conversionFrom = conversionPair[0];
                    String conversionTo = conversionPair[1];
                    newInquiryParameters = newInquiryParameters + conversionTo + ":" + conversionFrom;
                    if (l >= conversions.length - 1) continue;
                    newInquiryParameters = newInquiryParameters + ",";
                }
                field.setInquiryParameters(newInquiryParameters);
            }
            field.setFieldDirectInquiryEnabled(directInquiriesEnabled);
        } else {
            field.setFieldDirectInquiryEnabled(false);
        }
    }

    public static Field setFieldDirectInquiry(BusinessObject businessObject, String attributeName, Field field) {
        if (businessObject == null) {
            return field;
        }
        Boolean noDirectInquiry = LookupUtils.getBusinessObjectDictionaryService().noDirectInquiryFieldLookup(businessObject.getClass(), attributeName);
        if (noDirectInquiry != null && noDirectInquiry.booleanValue() || noDirectInquiry == null) {
            return field;
        }
        LookupUtils.setFieldDirectInquiry(field);
        return field;
    }

    @Deprecated
    public static Map getPrimitiveReference(BusinessObject businessObject, String attributeName) {
        HashMap<String, Class> chosenReferenceByKeySize = new HashMap<String, Class>();
        HashMap<String, Class> chosenReferenceByFieldName = new HashMap<String, Class>();
        Map<String, Class> referenceClasses = null;
        try {
            Map propMap = referencesForForeignKey.computeIfAbsent(businessObject.getClass(), k -> new HashMap());
            if (propMap.containsKey(attributeName)) {
                referenceClasses = (Map<String, Class>)propMap.get(attributeName);
            } else {
                referenceClasses = LookupUtils.getBusinessObjectMetaDataService().getReferencesForForeignKey(businessObject, attributeName);
                if ((referenceClasses == null || referenceClasses.isEmpty()) && LookupUtils.getPersistenceStructureService().isPersistable(businessObject.getClass())) {
                    referenceClasses = LookupUtils.getPersistenceStructureService().getReferencesForForeignKey(businessObject.getClass(), attributeName);
                }
                propMap.put(attributeName, referenceClasses);
            }
        }
        catch (ClassNotPersistableException ex) {
            Map<String, Map> propMap = referencesForForeignKey.get(businessObject.getClass());
            propMap.put(attributeName, null);
        }
        if (referenceClasses == null || referenceClasses.isEmpty()) {
            return chosenReferenceByKeySize;
        }
        int minKeys = Integer.MAX_VALUE;
        Iterator<String> iterator = referenceClasses.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String attr = key = iterator.next();
            Class clazz = referenceClasses.get(attr);
            List<String> pkNames = LookupUtils.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(clazz);
            if (pkNames.size() < minKeys) {
                minKeys = pkNames.size();
                chosenReferenceByKeySize.clear();
                chosenReferenceByKeySize.put(attr, clazz);
            }
            if (!attributeName.startsWith(attr)) continue;
            chosenReferenceByFieldName.clear();
            chosenReferenceByFieldName.put(attr, clazz);
        }
        return chosenReferenceByFieldName.isEmpty() ? chosenReferenceByKeySize : chosenReferenceByFieldName;
    }

    public static BusinessObject getNestedBusinessObject(BusinessObject bo, String attributeName) {
        String[] nestedAttributes = StringUtils.split((String)attributeName, (String)".");
        BusinessObject childBO = null;
        if (nestedAttributes.length > 1) {
            String attributeStringSoFar = "";
            for (int i = 0; i < nestedAttributes.length - 1; ++i) {
                Class clazz;
                if (i != 0) {
                    attributeStringSoFar = attributeStringSoFar + ".";
                }
                if ((clazz = ObjectUtils.getPropertyType(bo, attributeStringSoFar = attributeStringSoFar + nestedAttributes[i], LookupUtils.getPersistenceStructureService())) == null || !BusinessObject.class.isAssignableFrom(clazz)) continue;
                try {
                    childBO = (BusinessObject)ObjectUtils.createNewObjectFromClass(clazz);
                    continue;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return childBO;
    }

    public static Class getNestedReferenceClass(BusinessObject businessObject, String attributeName) {
        BusinessObject bo = LookupUtils.getNestedBusinessObject(businessObject, attributeName);
        return null == bo ? null : bo.getClass();
    }

    @Deprecated
    private static String generateFieldConversions(BusinessObject businessObject, String collectionName, DataObjectRelationship relationship, String propertyPrefix, List displayedFieldNames, String nestedObjectPrefix) {
        String fieldConversions = "";
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateFieldConversions(" + businessObject.getClass().getName() + "," + collectionName + ",\n" + relationship + "\n," + propertyPrefix + "," + displayedFieldNames + "," + nestedObjectPrefix + ")");
        }
        for (Map.Entry<String, String> entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = entry.getValue();
            String toField = entry.getKey();
            if (!displayedFieldNames.contains(toField)) {
                toField = LookupUtils.translateToDisplayedField(businessObject.getClass(), toField, displayedFieldNames);
            }
            if (StringUtils.isNotBlank((CharSequence)fieldConversions)) {
                fieldConversions = fieldConversions + ",";
            }
            if (StringUtils.isNotEmpty((CharSequence)propertyPrefix)) {
                toField = propertyPrefix + "." + toField;
            }
            if (StringUtils.isNotEmpty((CharSequence)collectionName)) {
                toField = collectionName + toField;
            }
            fieldConversions = fieldConversions + fromField + ":" + toField;
        }
        return fieldConversions;
    }

    @Deprecated
    private static String generateLookupParameters(BusinessObject businessObject, String collectionName, DataObjectRelationship relationship, String propertyPrefix, List displayedFieldNames, String nestedObjectPrefix) {
        String lookupParameters = "";
        List<String> displayedQFFieldNames = LookupUtils.getBusinessObjectDictionaryService().getLookupFieldNames(relationship.getRelatedClass());
        for (Map.Entry<String, String> entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = entry.getKey();
            String toField = entry.getValue();
            if (relationship.getUserVisibleIdentifierKey() != null && !relationship.getUserVisibleIdentifierKey().equals(fromField)) continue;
            if (!displayedFieldNames.contains(fromField)) {
                fromField = LookupUtils.translateToDisplayedField(businessObject.getClass(), fromField, displayedFieldNames);
            }
            if (displayedQFFieldNames != null && !displayedQFFieldNames.contains(toField)) {
                toField = LookupUtils.translateToDisplayedField(relationship.getRelatedClass(), toField, displayedQFFieldNames);
            }
            if (StringUtils.isNotBlank((CharSequence)lookupParameters)) {
                lookupParameters = lookupParameters + ",";
            }
            if (propertyPrefix != null && !"".equals(propertyPrefix)) {
                fromField = propertyPrefix + "." + fromField;
            }
            if (StringUtils.isNotEmpty((CharSequence)collectionName)) {
                fromField = collectionName + fromField;
            }
            lookupParameters = lookupParameters + fromField + ":" + toField;
        }
        return lookupParameters;
    }

    @Deprecated
    private static String translateToDisplayedField(Class businessObjectClass, String fieldName, List displayedFieldNames) {
        if (LookupUtils.getPersistenceStructureService().isPersistable(businessObjectClass)) {
            Map nestedFkMap = LookupUtils.getPersistenceStructureService().getNestedForeignKeyMap(businessObjectClass);
            if (!displayedFieldNames.contains(fieldName)) {
                for (Object displayedFieldName : displayedFieldNames) {
                    String dispField = (String)displayedFieldName;
                    if (!nestedFkMap.containsKey(dispField) || !nestedFkMap.get(dispField).equals(fieldName)) continue;
                    fieldName = dispField;
                }
            }
        }
        return fieldName;
    }

    public static String convertReferencesToSelectCollectionToString(Collection<String> referencesToRefresh) {
        StringBuilder buf = new StringBuilder();
        for (String reference : referencesToRefresh) {
            buf.append(reference).append(",");
        }
        if (!referencesToRefresh.isEmpty()) {
            buf.delete(buf.length() - ",".length(), buf.length());
        }
        return buf.toString();
    }

    public static String convertSetOfObjectIdsToString(Set<String> objectIds) {
        if (objectIds.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String objectId : objectIds) {
            if (!StringUtils.isNotBlank((CharSequence)objectId)) continue;
            if (objectId.contains("||")) {
                throw new RuntimeException("object ID " + objectId + " contains the selected obj ID separator");
            }
            buf.append(objectId).append("||");
        }
        buf.delete(buf.length() - "||".length(), buf.length());
        return buf.toString();
    }

    public static Set<String> convertStringOfObjectIdsToSet(String objectIdsString) {
        HashSet<String> set = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)objectIdsString)) {
            String[] objectIds = StringUtils.splitByWholeSeparator((String)objectIdsString, (String)"||");
            Collections.addAll(set, objectIds);
        }
        return set;
    }

    public static Comparator findBestValueComparatorForColumn(List<ResultRow> resultTable, int column) {
        NullValueComparator comp = NullValueComparator.getInstance();
        for (ResultRow row : resultTable) {
            Comparator tempComp = row.getColumns().get(column).getValueComparator();
            if (tempComp == null || NullValueComparator.class.equals(tempComp.getClass())) continue;
            return tempComp;
        }
        return comp;
    }

    public static Map<String, String> preProcessRangeFields(Map<String, String> lookupFormFields) {
        HashMap<String, String> fieldsToUpdate = new HashMap<String, String>();
        Set<String> fieldsForLookup = lookupFormFields.keySet();
        for (String propName : fieldsForLookup) {
            if (!propName.startsWith("rangeLowerBoundKeyPrefix_")) continue;
            String rangedLowerBoundValue = lookupFormFields.get(propName);
            String rangedFieldName = StringUtils.remove((String)propName, (String)"rangeLowerBoundKeyPrefix_");
            String rangedValue = lookupFormFields.get(rangedFieldName);
            Range range = new Range();
            range.setLowerBoundInclusive(true);
            range.setUpperBoundInclusive(true);
            range.setLowerBoundValue(rangedLowerBoundValue);
            range.setUpperBoundValue(rangedValue);
            String expr = range.toString();
            if (StringUtils.isEmpty((CharSequence)expr)) {
                expr = rangedValue;
            }
            fieldsToUpdate.put(rangedFieldName, expr);
        }
        Set keysToUpdate = fieldsToUpdate.keySet();
        for (String updateKey : keysToUpdate) {
            lookupFormFields.put(updateKey, (String)fieldsToUpdate.get(updateKey));
        }
        return fieldsToUpdate;
    }

    public static Map<String, String> generateCompositeSelectedObjectIds(Set<String> previouslySelectedObjectIds, Set<String> displayedObjectIds, Set<String> selectedObjectIds) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (String previouslySelectedObjectId : previouslySelectedObjectIds) {
            tempMap.put(previouslySelectedObjectId, previouslySelectedObjectId);
        }
        for (String displayedObjectId : displayedObjectIds) {
            tempMap.remove(displayedObjectId);
        }
        for (String selectedObjectId : selectedObjectIds) {
            tempMap.put(selectedObjectId, selectedObjectId);
        }
        return tempMap;
    }

    public static DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    public static PersistenceStructureService getPersistenceStructureService() {
        return KRADServiceLocator.getPersistenceStructureService();
    }

    public static BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        return KNSServiceLocator.getBusinessObjectDictionaryService();
    }

    public static BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        return KNSServiceLocator.getBusinessObjectMetaDataService();
    }

    public static DateTimeService getDateTimeService() {
        return CoreApiServiceLocator.getDateTimeService();
    }
}

