/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service;

import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.lookup.LookupResultsService;
import org.kuali.kfs.kns.lookup.Lookupable;
import org.kuali.kfs.kns.question.Question;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.CfAuthenticationService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kns.service.SecurityLoggingService;
import org.kuali.kfs.kns.service.SessionDocumentService;
import org.kuali.kfs.kns.service.TransactionalDocumentDictionaryService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;

public final class KNSServiceLocator {
    public static final String BUSINESS_OBJECT_AUTHORIZATION_SERVICE = "cf.businessObjectAuthorizationService";
    public static final String BUSINESS_OBJECT_METADATA_SERVICE = "cf.businessObjectMetaDataService";
    public static final String BUSINESS_OBJECT_DICTIONARY_SERVICE = "cf.businessObjectDictionaryService";
    public static final String CF_AUTHENTICATION_SERVICE = "cfAuthenticationService";
    public static final String DATA_DICTIONARY_SERVICE = "cf.dataDictionaryService";
    public static final String DICTIONARY_VALIDATION_SERVICE = "cf.dictionaryValidationService";
    public static final String DOCUMENT_HELPER_SERVICE = "cf.documentHelperService";
    public static final String LOOKUP_RESULTS_SERVICE = "cf.lookupResultsService";
    public static final String KUALI_INQUIRABLE = "cf.kualiInquirable";
    public static final String KUALI_LOOKUPABLE = "cf.kualiLookupable";
    public static final String MAINTENANCE_DOCUMENT_DICTIONARY_SERVICE = "cf.maintenanceDocumentDictionaryService";
    public static final String SESSION_DOCUMENT_SERVICE = "cf.knsSessionDocumentService";
    public static final String TRANSACTIONAL_DOCUMENT_DICTIONARY_SERVICE = "cf.transactionalDocumentDictionaryService";
    public static final String SECURITY_LOGGING_SERVICE = "cf.securityLoggingService";

    private KNSServiceLocator() {
    }

    public static <T> T getService(String serviceName) {
        return (T)GlobalResourceLoader.getService((String)serviceName);
    }

    public static CfAuthenticationService getCfAuthenticationService() {
        return (CfAuthenticationService)KNSServiceLocator.getService(CF_AUTHENTICATION_SERVICE);
    }

    public static BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        return (BusinessObjectAuthorizationService)KNSServiceLocator.getService(BUSINESS_OBJECT_AUTHORIZATION_SERVICE);
    }

    public static BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        return (BusinessObjectMetaDataService)KNSServiceLocator.getService(BUSINESS_OBJECT_METADATA_SERVICE);
    }

    public static DictionaryValidationService getKNSDictionaryValidationService() {
        return (DictionaryValidationService)KNSServiceLocator.getService(DICTIONARY_VALIDATION_SERVICE);
    }

    public static LookupResultsService getLookupResultsService() {
        return (LookupResultsService)KNSServiceLocator.getService(LOOKUP_RESULTS_SERVICE);
    }

    public static Inquirable getKualiInquirable() {
        return (Inquirable)KNSServiceLocator.getService(KUALI_INQUIRABLE);
    }

    public static Lookupable getKualiLookupable() {
        return (Lookupable)KNSServiceLocator.getService(KUALI_LOOKUPABLE);
    }

    public static MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        return (MaintenanceDocumentDictionaryService)KNSServiceLocator.getService(MAINTENANCE_DOCUMENT_DICTIONARY_SERVICE);
    }

    public static TransactionalDocumentDictionaryService getTransactionalDocumentDictionaryService() {
        return (TransactionalDocumentDictionaryService)KNSServiceLocator.getService(TRANSACTIONAL_DOCUMENT_DICTIONARY_SERVICE);
    }

    public static SessionDocumentService getSessionDocumentService() {
        return (SessionDocumentService)KNSServiceLocator.getService(SESSION_DOCUMENT_SERVICE);
    }

    public static Lookupable getLookupable(String lookupableName) {
        return (Lookupable)KNSServiceLocator.getService(lookupableName);
    }

    public static DataDictionaryService getDataDictionaryService() {
        return (DataDictionaryService)KNSServiceLocator.getService(DATA_DICTIONARY_SERVICE);
    }

    public static BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        return (BusinessObjectDictionaryService)KNSServiceLocator.getService(BUSINESS_OBJECT_DICTIONARY_SERVICE);
    }

    public static DocumentHelperService getDocumentHelperService() {
        return (DocumentHelperService)KNSServiceLocator.getService(DOCUMENT_HELPER_SERVICE);
    }

    public static Question getQuestion(String questionName) {
        return (Question)KNSServiceLocator.getService(questionName);
    }

    public static SecurityLoggingService getSecurityLoggingService() {
        return (SecurityLoggingService)KNSServiceLocator.getService(SECURITY_LOGGING_SERVICE);
    }
}

