/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.HeaderNavigation;
import org.kuali.kfs.kns.datadictionary.KNSDocumentEntry;
import org.kuali.kfs.kns.datadictionary.LookupDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.kns.web.struts.form.KualiHelpForm;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.HelpDefinition;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;

public class KualiHelpAction
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger(KualiHelpAction.class);
    private static final String VALIDATION_PATTERN_STRING = "ValidationPattern";
    private static final String NO = "No";
    private static final String YES = "Yes";
    static final String DEFAULT_LOOKUP_HELP_TEXT_RESOURCE_KEY = "lookupHelpText";
    private static DataDictionaryService dataDictionaryService;
    private static ConfigurationService kualiConfigurationService;
    private static ParameterService parameterService;
    private static MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;

    private DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return dataDictionaryService;
    }

    private ConfigurationService getConfigurationService() {
        if (kualiConfigurationService == null) {
            kualiConfigurationService = KRADServiceLocator.getKualiConfigurationService();
        }
        return kualiConfigurationService;
    }

    private ParameterService getParameterService() {
        if (parameterService == null) {
            parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return parameterService;
    }

    private MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (maintenanceDocumentDictionaryService == null) {
            maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return maintenanceDocumentDictionaryService;
    }

    private DataDictionaryEntry getDataDictionaryEntry(String businessObjectClassName) {
        return this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(businessObjectClassName);
    }

    private AttributeDefinition getAttributeDefinition(String businessObjectClassName, String attributeName) {
        AttributeDefinition retval = null;
        if (this.getDataDictionaryEntry(businessObjectClassName) != null) {
            retval = this.getDataDictionaryEntry(businessObjectClassName).getAttributeDefinition(attributeName);
        }
        return retval;
    }

    private String getAttributeMaxLength(AttributeDefinition attribute) {
        return attribute.getMaxLength().toString();
    }

    private String getAttributeValidationPatternName(AttributeDefinition attribute) {
        String retval = "";
        if (attribute.getValidationPattern() != null) {
            retval = attribute.getValidationPattern().getClass().getName();
        }
        if (retval.indexOf(".") > 0) {
            retval = retval.substring(retval.lastIndexOf(".") + 1);
        }
        if (retval.endsWith(VALIDATION_PATTERN_STRING)) {
            retval = retval.substring(0, retval.lastIndexOf(VALIDATION_PATTERN_STRING));
        }
        return retval;
    }

    public ActionForward getAttributeHelpText(ActionMapping mapping, KualiHelpForm helpForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isBlank((CharSequence)helpForm.getBusinessObjectClassName()) || StringUtils.isBlank((CharSequence)helpForm.getAttributeName())) {
            throw new RuntimeException("Business object and attribute name not specified.");
        }
        AttributeDefinition attribute = this.getAttributeDefinition(helpForm.getBusinessObjectClassName(), helpForm.getAttributeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request for help on: " + helpForm.getBusinessObjectClassName() + " -- " + helpForm.getAttributeName());
            LOG.debug("  attribute: " + attribute);
        }
        if (attribute == null || StringUtils.isBlank((CharSequence)attribute.getSummary())) {
            helpForm.setResourceKey("message.nohelp");
            return this.getResourceHelpText(mapping, helpForm, request, response);
        }
        boolean required = attribute.isRequired();
        try {
            Class<?> boClass = Class.forName(helpForm.getBusinessObjectClassName());
            String docTypeName = this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(boClass);
            if (StringUtils.isNotBlank((CharSequence)docTypeName)) {
                MaintainableFieldDefinition field = this.getMaintenanceDocumentDictionaryService().getMaintainableField(docTypeName, helpForm.getAttributeName());
                if (field != null) {
                    required = field.isRequired();
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)("BO class " + boClass.getName() + " does not have a maint doc definition.  Defaulting to using DD for definition"));
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.warn("Unable to obtain maintainable field for BO property.", (Throwable)ex);
        }
        helpForm.setHelpLabel(attribute.getLabel());
        helpForm.setHelpSummary(attribute.getSummary());
        helpForm.setHelpDescription(attribute.getDescription());
        helpForm.setHelpRequired(required ? YES : NO);
        helpForm.setHelpMaxLength(this.getAttributeMaxLength(attribute));
        helpForm.setValidationPatternName(this.getAttributeValidationPatternName(attribute));
        return mapping.findForward("basic");
    }

    public ActionForward getAttributeHelpText(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getAttributeHelpText(mapping, (KualiHelpForm)form, request, response);
    }

    public ActionForward getDocumentHelpText(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiHelpForm helpForm = (KualiHelpForm)form;
        String documentTypeName = helpForm.getDocumentTypeName();
        if (StringUtils.isBlank((CharSequence)documentTypeName)) {
            throw new RuntimeException("Document type name not specified.");
        }
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        DocumentEntry entry = dataDictionary.getDocumentEntry(documentTypeName);
        String label = "";
        String summary = "";
        String description = "";
        HelpDefinition helpDefinition = null;
        String apcHelpUrl = null;
        if (entry != null) {
            DocumentType docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(entry.getDocumentTypeName());
            label = docType.getLabel();
            description = docType.getDescription();
            if (StringUtils.isNotBlank((CharSequence)docType.getHelpDefinitionUrl())) {
                apcHelpUrl = WebUtils.toAbsoluteURL(ConfigContext.getCurrentContextConfig().getProperty("externalizable.help.url"), docType.getHelpDefinitionUrl());
            }
        }
        if (StringUtils.isNotBlank(apcHelpUrl)) {
            response.sendRedirect(apcHelpUrl);
            return null;
        }
        helpForm.setHelpLabel(label);
        helpForm.setHelpSummary(summary);
        helpForm.setHelpDescription(description);
        helpForm.setHelpDefinition(helpDefinition);
        return mapping.findForward("basic");
    }

    public ActionForward getBusinessObjectHelpText(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiHelpForm helpForm = (KualiHelpForm)form;
        String objectClassName = helpForm.getBusinessObjectClassName();
        if (StringUtils.isBlank((CharSequence)objectClassName)) {
            throw new RuntimeException("Document type name not specified.");
        }
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        BusinessObjectEntry entry = (BusinessObjectEntry)dataDictionary.getBusinessObjectEntry(objectClassName);
        String apcHelpUrl = null;
        String label = "";
        String objectDescription = "";
        if (entry != null) {
            HelpDefinition helpDefinition = entry.getHelpDefinition();
            label = entry.getObjectLabel();
            objectDescription = entry.getObjectDescription();
            if (null != helpDefinition && null != helpDefinition.getParameterNamespace() && null != helpDefinition.getParameterDetailType() && null != helpDefinition.getParameterName()) {
                apcHelpUrl = this.getHelpUrl(helpDefinition.getParameterNamespace(), helpDefinition.getParameterDetailType(), helpDefinition.getParameterName());
            }
        }
        if (!StringUtils.isBlank(apcHelpUrl)) {
            response.sendRedirect(apcHelpUrl);
            return null;
        }
        helpForm.setHelpLabel(label);
        helpForm.setHelpDescription(objectDescription);
        return mapping.findForward("basic");
    }

    public ActionForward getPageHelpText(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiHelpForm helpForm = (KualiHelpForm)form;
        String documentTypeName = helpForm.getDocumentTypeName();
        String pageName = helpForm.getPageName();
        if (StringUtils.isBlank((CharSequence)documentTypeName)) {
            throw new RuntimeException("Document type name not specified.");
        }
        if (StringUtils.isBlank((CharSequence)pageName)) {
            throw new RuntimeException("Page name not specified.");
        }
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        KNSDocumentEntry entry = (KNSDocumentEntry)((Object)dataDictionary.getDocumentEntry(documentTypeName));
        String apcHelpUrl = null;
        if (entry != null) {
            for (HeaderNavigation headerNavigation : entry.getHeaderNavigationList()) {
                HelpDefinition helpDefinition;
                if (!headerNavigation.getHeaderTabDisplayName().equals(pageName) || null == (helpDefinition = headerNavigation.getHelpDefinition()) || null == helpDefinition.getParameterNamespace() || null == helpDefinition.getParameterDetailType() || null == helpDefinition.getParameterName()) continue;
                apcHelpUrl = this.getHelpUrl(helpDefinition.getParameterNamespace(), helpDefinition.getParameterDetailType(), helpDefinition.getParameterName());
            }
        }
        if (!StringUtils.isBlank(apcHelpUrl)) {
            response.sendRedirect(apcHelpUrl);
            return null;
        }
        helpForm.setHelpLabel(pageName);
        helpForm.setHelpDescription("No help content available.");
        return mapping.findForward("basic");
    }

    public ActionForward getStoredHelpUrl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiHelpForm helpForm = (KualiHelpForm)form;
        String helpParameterNamespace = helpForm.getHelpParameterNamespace();
        String helpParameterDetailType = helpForm.getHelpParameterDetailType();
        String helpParameterName = helpForm.getHelpParameterName();
        if (StringUtils.isBlank((CharSequence)helpParameterNamespace)) {
            throw new RuntimeException("Parameter Namespace not specified.");
        }
        if (StringUtils.isBlank((CharSequence)helpParameterDetailType)) {
            throw new RuntimeException("Detail Type not specified.");
        }
        if (StringUtils.isBlank((CharSequence)helpParameterName)) {
            throw new RuntimeException("Parameter Name not specified.");
        }
        String apcHelpUrl = this.getHelpUrl(helpParameterNamespace, helpParameterDetailType, helpParameterName);
        if (!StringUtils.isBlank((CharSequence)apcHelpUrl)) {
            response.sendRedirect(apcHelpUrl);
            return null;
        }
        helpForm.setHelpDescription("No help content available.");
        return mapping.findForward("basic");
    }

    public ActionForward getResourceHelpText(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiHelpForm helpForm = (KualiHelpForm)form;
        String resourceKey = helpForm.getResourceKey();
        this.populateHelpFormForResourceText(helpForm, resourceKey);
        return mapping.findForward("basic");
    }

    protected void populateHelpFormForResourceText(KualiHelpForm helpForm, String resourceKey) {
        if (StringUtils.isBlank((CharSequence)resourceKey)) {
            throw new RuntimeException("Help resource key not specified.");
        }
        helpForm.setHelpLabel("");
        helpForm.setHelpSummary("");
        helpForm.setHelpDescription(this.getConfigurationService().getPropertyValueAsString(resourceKey));
    }

    public ActionForward getLookupHelpText(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DataDictionary dataDictionary;
        BusinessObjectEntry entry;
        LookupDefinition lookupDefinition;
        String docSearchHelpUrl;
        DocumentType docType;
        KualiHelpForm helpForm = (KualiHelpForm)form;
        if (!StringUtils.isEmpty((CharSequence)helpForm.getSearchDocumentTypeName()) && (docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(helpForm.getSearchDocumentTypeName())) != null && !StringUtils.isEmpty((CharSequence)docType.getDocSearchHelpUrl()) && StringUtils.isNotBlank((CharSequence)(docSearchHelpUrl = WebUtils.toAbsoluteURL(ConfigContext.getCurrentContextConfig().getProperty("externalizable.help.url"), docType.getDocSearchHelpUrl())))) {
            response.sendRedirect(docSearchHelpUrl);
            return null;
        }
        String lookupBusinessObjectClassName = helpForm.getLookupBusinessObjectClassName();
        if (!StringUtils.isBlank((CharSequence)lookupBusinessObjectClassName) && (lookupDefinition = (entry = (BusinessObjectEntry)(dataDictionary = this.getDataDictionaryService().getDataDictionary()).getBusinessObjectEntry(lookupBusinessObjectClassName)).getLookupDefinition()) != null) {
            if (!(lookupDefinition.getHelpDefinition() == null || StringUtils.isBlank((CharSequence)lookupDefinition.getHelpDefinition().getParameterNamespace()) || StringUtils.isBlank((CharSequence)lookupDefinition.getHelpDefinition().getParameterDetailType()) || StringUtils.isBlank((CharSequence)lookupDefinition.getHelpDefinition().getParameterName()))) {
                String apcHelpUrl = this.getHelpUrl(lookupDefinition.getHelpDefinition().getParameterNamespace(), lookupDefinition.getHelpDefinition().getParameterDetailType(), lookupDefinition.getHelpDefinition().getParameterName());
                if (!StringUtils.isBlank((CharSequence)apcHelpUrl)) {
                    response.sendRedirect(apcHelpUrl);
                    return null;
                }
            } else if (!StringUtils.isBlank((CharSequence)lookupDefinition.getHelpUrl())) {
                String apcHelpUrl = WebUtils.toAbsoluteURL(ConfigContext.getCurrentContextConfig().getProperty("externalizable.help.url"), lookupDefinition.getHelpUrl());
                response.sendRedirect(apcHelpUrl);
                return null;
            }
        }
        this.populateHelpFormForResourceText(helpForm, this.getDefaultLookupHelpResourceKey());
        return mapping.findForward("basic");
    }

    protected String getDefaultLookupHelpResourceKey() {
        return DEFAULT_LOOKUP_HELP_TEXT_RESOURCE_KEY;
    }

    private String getHelpUrl(String parameterNamespace, String parameterDetailTypeCode, String parameterName) {
        return WebUtils.toAbsoluteURL(this.getConfigurationService().getPropertyValueAsString("externalizable.help.url"), this.getParameterService().getParameterValueAsString(parameterNamespace, parameterDetailTypeCode, parameterName));
    }

    public ActionForward getHelpUrlByNamespace(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getStoredHelpUrl(mapping, form, request, response);
    }
}

