/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;
import org.kuali.kfs.krad.datadictionary.DataObjectEntry;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingDefinition;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.bo.BusinessObject;

public class BusinessObjectEntry
extends DataObjectEntry {
    protected Class<? extends BusinessObject> baseBusinessObjectClass;

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        super.setDataObjectClass(businessObjectClass);
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        if (this.getRelationships() != null) {
            for (RelationshipDefinition rd : this.getRelationships()) {
                rd.setSourceClass(businessObjectClass);
            }
        }
    }

    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return super.getDataObjectClass();
    }

    public void setBaseBusinessObjectClass(Class<? extends BusinessObject> baseBusinessObjectClass) {
        this.baseBusinessObjectClass = baseBusinessObjectClass;
    }

    public Class<? extends BusinessObject> getBaseBusinessObjectClass() {
        return this.baseBusinessObjectClass;
    }

    @Override
    public void completeValidation() {
        try {
            super.completeValidation();
            if (this.inactivationBlockingDefinitions != null && !this.inactivationBlockingDefinitions.isEmpty()) {
                for (InactivationBlockingDefinition inactivationBlockingDefinition : this.inactivationBlockingDefinitions) {
                    inactivationBlockingDefinition.completeValidation((Class)this.getDataObjectClass(), (Class)null);
                }
            }
        }
        catch (DataDictionaryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DataDictionaryException("Exception validating " + this, ex);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.inactivationBlockingDefinitions != null) {
            for (InactivationBlockingDefinition ibd : this.inactivationBlockingDefinitions) {
                ibd.setBusinessObjectClass(this.getBusinessObjectClass());
                if (StringUtils.isNotBlank((CharSequence)ibd.getBlockedReferencePropertyName()) && ibd.getBlockedBusinessObjectClass() == null) {
                    ibd.setBlockedBusinessObjectClass(DataDictionary.getAttributeClass(this.getDataObjectClass(), ibd.getBlockedReferencePropertyName()));
                }
                ibd.setBlockingReferenceBusinessObjectClass(this.getBusinessObjectClass());
            }
        }
    }

    @Override
    public String toString() {
        return "BusinessObjectEntry for " + this.getBusinessObjectClass();
    }
}

