/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.bo.BusinessObject;

public class InactivationBlockingDefinition
extends DataDictionaryDefinitionBase
implements InactivationBlockingMetadata {
    private static final long serialVersionUID = -8765429636173190984L;
    protected Class<? extends BusinessObject> blockingReferenceBusinessObjectClass;
    protected String blockedReferencePropertyName;
    protected Class<? extends BusinessObject> blockedBusinessObjectClass;
    protected String inactivationBlockingDetectionServiceBeanName;
    protected String relationshipLabel;
    protected Class<? extends BusinessObject> businessObjectClass;

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (StringUtils.isBlank((CharSequence)this.inactivationBlockingDetectionServiceBeanName) && StringUtils.isBlank((CharSequence)this.blockedReferencePropertyName)) {
            throw new AttributeValidationException("inactivationBlockingDetectionServiceBeanName and  blockedReferencePropertyName can't both be blank in InactivationBlockingDefinition for class " + rootBusinessObjectClass.getName());
        }
        if (this.getBlockedBusinessObjectClass() == null) {
            throw new AttributeValidationException("Unable to determine blockedReferenceBusinessObjectClass in InactivationBlockingDefinition for class " + rootBusinessObjectClass.getName());
        }
        if (!BusinessObject.class.isAssignableFrom(this.getBlockedBusinessObjectClass())) {
            throw new AttributeValidationException("InactivationBlockingDefinitions must block a reference of type BusinessObject.  Class name: " + rootBusinessObjectClass.getName() + " blockedReferencePropertyName " + this.blockedReferencePropertyName + " class that should have been a BusinessObject: " + this.getBlockedBusinessObjectClass());
        }
    }

    @Override
    public String getBlockedReferencePropertyName() {
        return this.blockedReferencePropertyName;
    }

    public void setBlockedReferencePropertyName(String blockedReferencePropertyName) {
        this.blockedReferencePropertyName = blockedReferencePropertyName;
    }

    @Override
    public Class<? extends BusinessObject> getBlockedBusinessObjectClass() {
        return this.blockedBusinessObjectClass;
    }

    public void setBlockedBusinessObjectClass(Class<? extends BusinessObject> blockedBusinessObjectClass) {
        this.blockedBusinessObjectClass = blockedBusinessObjectClass;
    }

    @Override
    public String getInactivationBlockingDetectionServiceBeanName() {
        return this.inactivationBlockingDetectionServiceBeanName;
    }

    public void setInactivationBlockingDetectionServiceBeanName(String inactivationBlockingDetectionServiceImpl) {
        this.inactivationBlockingDetectionServiceBeanName = inactivationBlockingDetectionServiceImpl;
    }

    @Override
    public Class<? extends BusinessObject> getBlockingReferenceBusinessObjectClass() {
        return this.blockingReferenceBusinessObjectClass;
    }

    public void setBlockingReferenceBusinessObjectClass(Class<? extends BusinessObject> blockingReferenceBusinessObjectClass) {
        this.blockingReferenceBusinessObjectClass = blockingReferenceBusinessObjectClass;
    }

    @Override
    public String getRelationshipLabel() {
        return this.relationshipLabel;
    }

    public void setRelationshipLabel(String relationshipLabel) {
        this.relationshipLabel = relationshipLabel;
    }

    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }

    public String toString() {
        return "InactivationBlockingDefinition: blockedClass=" + this.blockedBusinessObjectClass.getName() + " /blockingReferenceProperty=" + this.blockedReferencePropertyName + " /blockingClass=" + this.blockingReferenceBusinessObjectClass.getName();
    }
}

