/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;
import org.kuali.kfs.krad.datadictionary.ViewTypeDictionaryIndex;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.service.ViewTypeService;
import org.kuali.kfs.krad.uif.util.ViewModelUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class UifDictionaryIndex
implements Runnable {
    private static final Logger LOG = LogManager.getLogger();
    private DefaultListableBeanFactory ddBeans;
    private Map<String, String> viewBeanEntriesById;
    private Map<String, ViewTypeDictionaryIndex> viewEntriesByType;

    public UifDictionaryIndex(DefaultListableBeanFactory ddBeans) {
        this.ddBeans = ddBeans;
    }

    @Override
    public void run() {
        LOG.info("Starting View Index Building");
        this.buildViewIndicies();
        LOG.info("Completed View Index Building");
    }

    public View getViewById(String viewId) {
        String beanName = this.viewBeanEntriesById.get(viewId);
        if (StringUtils.isBlank((CharSequence)beanName)) {
            throw new DataDictionaryException("Unable to find View with id: " + viewId);
        }
        return (View)this.ddBeans.getBean(beanName, View.class);
    }

    public View getViewByTypeIndex(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        String index = this.buildTypeIndex(indexKey);
        ViewTypeDictionaryIndex typeIndex = this.getTypeIndex(viewTypeName);
        String beanName = typeIndex.get(index);
        if (StringUtils.isNotBlank((CharSequence)beanName)) {
            return (View)this.ddBeans.getBean(beanName, View.class);
        }
        return null;
    }

    public boolean viewByTypeExist(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        boolean viewExist = false;
        String index = this.buildTypeIndex(indexKey);
        ViewTypeDictionaryIndex typeIndex = this.getTypeIndex(viewTypeName);
        String beanName = typeIndex.get(index);
        if (StringUtils.isNotBlank((CharSequence)beanName)) {
            viewExist = true;
        }
        return viewExist;
    }

    public PropertyValues getViewPropertiesById(String viewId) {
        String beanName = this.viewBeanEntriesById.get(viewId);
        if (StringUtils.isBlank((CharSequence)beanName)) {
            BeanDefinition beanDefinition = this.ddBeans.getMergedBeanDefinition(beanName);
            return beanDefinition.getPropertyValues();
        }
        return null;
    }

    public PropertyValues getViewPropertiesByType(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        String index = this.buildTypeIndex(indexKey);
        ViewTypeDictionaryIndex typeIndex = this.getTypeIndex(viewTypeName);
        String beanName = typeIndex.get(index);
        if (StringUtils.isNotBlank((CharSequence)beanName)) {
            BeanDefinition beanDefinition = this.ddBeans.getMergedBeanDefinition(beanName);
            return beanDefinition.getPropertyValues();
        }
        return null;
    }

    public List<View> getViewsForType(UifConstants.ViewType viewTypeName) {
        ArrayList<View> typeViews = new ArrayList<View>();
        if (this.viewEntriesByType.containsKey(viewTypeName.name())) {
            ViewTypeDictionaryIndex typeIndex = this.viewEntriesByType.get(viewTypeName.name());
            for (Map.Entry<String, String> typeEntry : typeIndex.getViewIndex().entrySet()) {
                View typeView = (View)this.ddBeans.getBean(typeEntry.getValue(), View.class);
                typeViews.add(typeView);
            }
        } else {
            throw new DataDictionaryException("Unable to find view index for type: " + (Object)((Object)viewTypeName));
        }
        return typeViews;
    }

    protected void buildViewIndicies() {
        String[] beanNames;
        this.viewBeanEntriesById = new HashMap<String, String>();
        this.viewEntriesByType = new HashMap<String, ViewTypeDictionaryIndex>();
        for (String beanName : beanNames = this.ddBeans.getBeanNamesForType(View.class)) {
            BeanDefinition beanDefinition = this.ddBeans.getMergedBeanDefinition(beanName);
            MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
            String id = ViewModelUtils.getStringValFromPVs((PropertyValues)propertyValues, "id");
            if (StringUtils.isBlank((CharSequence)id)) {
                id = beanName;
            }
            if (this.viewBeanEntriesById.containsKey(id)) {
                throw new DataDictionaryException("Two views must not share the same id. Found duplicate id: " + id);
            }
            this.viewBeanEntriesById.put(id, beanName);
            this.indexViewForType((PropertyValues)propertyValues, beanName);
        }
    }

    protected void indexViewForType(PropertyValues propertyValues, String beanName) {
        String viewTypeName = ViewModelUtils.getStringValFromPVs(propertyValues, "viewTypeName");
        if (StringUtils.isBlank((CharSequence)viewTypeName)) {
            return;
        }
        UifConstants.ViewType viewType = UifConstants.ViewType.valueOf(viewTypeName);
        ViewTypeService typeService = KRADServiceLocatorWeb.getViewService().getViewTypeService(viewType);
        if (typeService == null) {
            return;
        }
        Map<String, String> typeParameters = typeService.getParametersFromViewConfiguration(propertyValues);
        String index = this.buildTypeIndex(typeParameters);
        ViewTypeDictionaryIndex typeIndex = this.getTypeIndex(viewType);
        typeIndex.put(index, beanName);
    }

    protected ViewTypeDictionaryIndex getTypeIndex(UifConstants.ViewType viewType) {
        ViewTypeDictionaryIndex typeIndex;
        if (this.viewEntriesByType.containsKey(viewType.name())) {
            typeIndex = this.viewEntriesByType.get(viewType.name());
        } else {
            typeIndex = new ViewTypeDictionaryIndex();
            this.viewEntriesByType.put(viewType.name(), typeIndex);
        }
        return typeIndex;
    }

    protected String buildTypeIndex(Map<String, String> typeParameters) {
        String index = "";
        for (String parameterName : typeParameters.keySet()) {
            if (StringUtils.isNotBlank((CharSequence)index)) {
                index = index + "|||";
            }
            index = index + parameterName + "^^" + typeParameters.get(parameterName);
        }
        return index;
    }
}

