/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.datadictionary.validation.constraint.ValidDataPatternConstraint;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class FixedPointPatternConstraint
extends ValidDataPatternConstraint {
    protected boolean allowNegative;
    protected int precision;
    protected int scale;

    @Override
    protected String getRegexString() {
        StringBuilder regex = new StringBuilder();
        if (this.isAllowNegative()) {
            regex.append("-?");
        }
        regex.append("(").append("[0-9]{0,").append(this.getPrecision() - this.getScale()).append("}").append("\\.").append("[0-9]{1,").append(this.getScale()).append("}").append("|[0-9]{1,").append(this.getPrecision() - this.getScale()).append("}").append(")");
        return regex.toString();
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            ConfigurationService configService = KRADServiceLocator.getKualiConfigurationService();
            if (this.allowNegative) {
                this.validationMessageParams.add(configService.getPropertyValueAsString("validation.positiveOrNegative"));
            } else {
                this.validationMessageParams.add(configService.getPropertyValueAsString("validation.positive"));
            }
            this.validationMessageParams.add(Integer.toString(this.precision));
            this.validationMessageParams.add(Integer.toString(this.scale));
        }
        return this.validationMessageParams;
    }
}

